/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d3;

import boofcv.alg.cloud.AccessColorIndex;
import boofcv.alg.cloud.AccessPointIndex;
import boofcv.gui.BoofSwingUtil;
import boofcv.gui.d3.PointCloudViewerPanelSwing;
import boofcv.struct.Point3dRgbI_F64;
import boofcv.struct.packed.PackedBigArrayPoint3D_F32;
import boofcv.visualize.PointCloudViewer;
import georegression.struct.ConvertFloatType;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F32;
import georegression.struct.se.Se3_F64;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.ddogleg.struct.BigDogArray_I32;
import org.ddogleg.struct.DogArray;
import org.jetbrains.annotations.Nullable;

public class PointCloudViewerSwing
implements PointCloudViewer {
    PointCloudViewerPanelSwing panel = new PointCloudViewerPanelSwing(60.0f, 1.0f);

    @Override
    public void setShowAxis(boolean show) {
    }

    @Override
    public void setTranslationStep(double step) {
        BoofSwingUtil.invokeNowOrLater(() -> this.panel.setStepSize((float)step));
    }

    @Override
    public void setDotSize(int pixels) {
        BoofSwingUtil.invokeNowOrLater(() -> this.panel.setDotRadius(pixels));
    }

    @Override
    public void setClipDistance(double distance) {
        BoofSwingUtil.invokeNowOrLater(() -> {
            this.panel.maxRenderDistance = (float)distance;
        });
    }

    @Override
    public void setFog(boolean active) {
        BoofSwingUtil.invokeNowOrLater(() -> {
            this.panel.fog = active;
        });
    }

    @Override
    public void setBackgroundColor(int rgb) {
        BoofSwingUtil.invokeNowOrLater(() -> {
            this.panel.backgroundColor = rgb;
        });
    }

    @Override
    public void setColorFrame(boolean useWorld) {
        this.panel.colorizeUsingWorldFrame = useWorld;
    }

    @Override
    public void addCloud(PointCloudViewer.IteratePoint iterator, boolean hasColor) {
        Point3D_F64 p = new Point3D_F64();
        if (SwingUtilities.isEventDispatchThread()) {
            while (iterator.hasNext()) {
                int rgb = iterator.next(p);
                this.panel.addPoint((float)p.x, (float)p.y, (float)p.z, hasColor ? rgb : -16777216);
            }
        } else {
            SwingUtilities.invokeLater(() -> {
                while (iterator.hasNext()) {
                    int rgb = iterator.next(p);
                    this.panel.addPoint((float)p.x, (float)p.y, (float)p.z, hasColor ? rgb : -16777216);
                }
            });
        }
    }

    @Override
    public void addCloud(AccessPointIndex<Point3D_F64> accessPoint, @Nullable AccessColorIndex accessColor, int size) {
        Point3D_F64 p = new Point3D_F64();
        if (SwingUtilities.isEventDispatchThread()) {
            for (int i = 0; i < size; ++i) {
                accessPoint.getPoint(i, p);
                int rgb = accessColor == null ? -16777216 : accessColor.getRGB(i);
                this.panel.addPoint((float)p.x, (float)p.y, (float)p.z, rgb);
            }
        } else {
            SwingUtilities.invokeLater(() -> {
                for (int i = 0; i < size; ++i) {
                    accessPoint.getPoint(i, p);
                    int rgb = accessColor == null ? -16777216 : accessColor.getRGB(i);
                    this.panel.addPoint((float)p.x, (float)p.y, (float)p.z, rgb);
                }
            });
        }
    }

    @Override
    public void addPoint(double x, double y, double z, int rgb) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel.addPoint((float)x, (float)y, (float)z, rgb);
        } else {
            SwingUtilities.invokeLater(() -> this.panel.addPoint((float)x, (float)y, (float)z, rgb));
        }
    }

    @Override
    public void addWireFrame(List<Point3D_F64> vertexes, boolean closed, int rgb, int widthPixels) {
        BoofSwingUtil.invokeNowOrLater(() -> this.panel.addWireFrame(vertexes, closed, rgb, widthPixels));
    }

    @Override
    public void clearPoints() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.panel.clearCloud();
        } else {
            SwingUtilities.invokeLater(() -> this.panel.clearCloud());
        }
    }

    @Override
    public void setColorizer(PointCloudViewer.Colorizer colorizer) {
        this.panel.colorizer = colorizer;
    }

    @Override
    public void removeColorizer() {
        this.panel.colorizer = null;
    }

    @Override
    public void setCameraHFov(double radians) {
        BoofSwingUtil.invokeNowOrLater(() -> this.panel.setHorizontalFieldOfView((float)radians));
    }

    @Override
    public void setCameraToWorld(Se3_F64 cameraToWorld) {
        Se3_F64 worldToCamera = cameraToWorld.invert((Se3_F64)null);
        Se3_F32 worldToCameraF32 = new Se3_F32();
        ConvertFloatType.convert(worldToCamera, worldToCameraF32);
        BoofSwingUtil.invokeNowOrLater(() -> this.panel.setWorldToCamera(worldToCameraF32));
    }

    @Override
    public Se3_F64 getCameraToWorld(@Nullable Se3_F64 cameraToWorld) {
        if (cameraToWorld == null) {
            cameraToWorld = new Se3_F64();
        }
        Se3_F32 worldToCamera = this.panel.getWorldToCamera(null);
        ConvertFloatType.convert(worldToCamera.invert((Se3_F32)null), cameraToWorld);
        return cameraToWorld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DogArray<Point3dRgbI_F64> copyCloud(@Nullable DogArray<Point3dRgbI_F64> copy) {
        if (copy == null) {
            copy = new DogArray<Point3dRgbI_F64>(Point3dRgbI_F64::new);
        } else {
            copy.reset();
        }
        DogArray<Point3dRgbI_F64> _copy = copy;
        PackedBigArrayPoint3D_F32 cloudXyz = this.panel.getCloudXyz();
        BigDogArray_I32 cloudColor = this.panel.getCloudColor();
        PackedBigArrayPoint3D_F32 packedBigArrayPoint3D_F32 = cloudXyz;
        synchronized (packedBigArrayPoint3D_F32) {
            if (cloudXyz.size() == cloudColor.size) {
                cloudXyz.forIdx(0, cloudXyz.size(), (idx, point) -> ((Point3dRgbI_F64)_copy.grow()).setTo(point.x, point.y, point.z, cloudColor.get(idx)));
            } else {
                cloudXyz.forIdx(0, cloudXyz.size(), (idx, point) -> ((Point3dRgbI_F64)_copy.grow()).setTo(point.x, point.y, point.z));
            }
        }
        return copy;
    }

    @Override
    public JComponent getComponent() {
        return this.panel;
    }
}

