/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.controls.JCheckBoxValue;
import boofcv.misc.BoofLambdas;
import boofcv.visualize.PeriodicColorizer;
import boofcv.visualize.PointCloudViewer;
import boofcv.visualize.SingleAxisMagentaBlue;
import boofcv.visualize.SingleAxisRgb;
import boofcv.visualize.TwoAxisRgbPlane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSlider;

public class ControlPanelPointCloud
extends StandardAlgConfigPanel {
    int colorScheme = 0;
    public double clipDistance = 0.0;
    public boolean fog = false;
    public int periodAdjust = 500;
    public int offsetAdjust = 500;
    public int speedAdjust = 500;
    protected int backgroundColor3D = 0;
    protected final JComboBox comboColorizer = this.combo(this.colorScheme, "Color", "X-YZ", "Y-XZ", "Z-XY", "RB-X", "RB-Y", "RB-Z", "RGB-X", "RGB-Y", "RGB-Z");
    protected final JButton bColorBackGround = new JButton();
    protected final JSlider sliderPeriodColor = this.slider(0, 1000, this.periodAdjust, 120);
    protected final JSlider sliderOffsetColor = this.slider(0, 1000, this.offsetAdjust, 120);
    protected final JSlider sliderSpeed3D = this.slider(0, 1000, this.speedAdjust, 120);
    protected JFormattedTextField fieldClip = this.textfield(this.clipDistance, 0.0, Double.NaN, 100);
    protected JCheckBox checkFog = this.checkbox("", this.fog, "Turn on/off fog");
    protected JCheckBoxValue checkColorFrame = this.checkboxWrap("Global", true).tt("If pseudo color is generated using global or camera reference frame");
    protected BoofLambdas.ProcessCall callbackBackground = () -> {};
    protected BoofLambdas.ProcessCall callbackModified = () -> {};

    public ControlPanelPointCloud(BoofLambdas.ProcessCall callback) {
        this();
        this.callbackBackground = callback;
        this.callbackModified = callback;
    }

    public ControlPanelPointCloud() {
        this.layoutControls();
    }

    protected void layoutControls() {
        JPanel clipPanel = new JPanel();
        clipPanel.setLayout(new BoxLayout(clipPanel, 0));
        clipPanel.add(this.fieldClip);
        clipPanel.add(this.checkFog);
        this.addLabeled(this.createColorPanel(), "Color", "Point cloud colorization method");
        this.addLabeled(clipPanel, "Clip", "Set to a non-zero value to specify a max distance for rendering");
        this.addLabeled(this.sliderOffsetColor, "Offset", "Pseudo color offset of periodic function");
        this.addLabeled(this.sliderPeriodColor, "Period", "The pseudo color's period");
        this.addLabeled(this.sliderSpeed3D, "Speed", "Adjust translational speed through point cloud");
    }

    public void configure(PointCloudViewer pcv, double periodBaseline, double translateBaseline) {
        double periodColor = periodBaseline * this.periodScale();
        PeriodicColorizer colorizer = null;
        switch (this.colorScheme) {
            case 0: {
                pcv.removeColorizer();
                break;
            }
            case 1: {
                colorizer = new TwoAxisRgbPlane.X_YZ(4.0);
                break;
            }
            case 2: {
                colorizer = new TwoAxisRgbPlane.Y_XZ(4.0);
                break;
            }
            case 3: {
                colorizer = new TwoAxisRgbPlane.Z_XY(4.0);
                break;
            }
            case 4: {
                colorizer = new SingleAxisMagentaBlue.X();
                break;
            }
            case 5: {
                colorizer = new SingleAxisMagentaBlue.Y();
                break;
            }
            case 6: {
                colorizer = new SingleAxisMagentaBlue.Z();
                break;
            }
            case 7: {
                colorizer = new SingleAxisRgb.X();
                break;
            }
            case 8: {
                colorizer = new SingleAxisRgb.Y();
                break;
            }
            case 9: {
                colorizer = new SingleAxisRgb.Z();
            }
        }
        if (colorizer != null) {
            colorizer.setPeriod(periodColor);
            colorizer.setOffset(this.offsetScale());
            pcv.setColorizer(colorizer);
        }
        pcv.setColorFrame(this.checkColorFrame.value);
        pcv.setBackgroundColor(this.backgroundColor3D);
        pcv.setTranslationStep(this.speedScale() * translateBaseline);
        if (this.clipDistance > 0.0) {
            pcv.setClipDistance(this.clipDistance);
            pcv.setFog(this.fog);
        } else {
            pcv.setClipDistance(Double.MAX_VALUE);
            pcv.setFog(false);
        }
    }

    public void setEnabledAll(boolean enabled) {
        this.comboColorizer.setEnabled(enabled);
        this.sliderOffsetColor.setEnabled(enabled);
        this.sliderPeriodColor.setEnabled(enabled);
        this.sliderSpeed3D.setEnabled(enabled);
        this.bColorBackGround.setEnabled(enabled);
        this.fieldClip.setEnabled(enabled);
        this.checkFog.setEnabled(enabled);
    }

    private JPanel createColorPanel() {
        this.bColorBackGround.addActionListener(e -> {
            Color newColor = JColorChooser.showDialog(this, "Background Color", new Color(this.getActiveBackgroundColor()));
            if (newColor == null) {
                return;
            }
            this.setColorButtonColor(newColor.getRGB());
            this.callbackBackground.process();
        });
        this.bColorBackGround.setPreferredSize(new Dimension(20, 20));
        this.bColorBackGround.setMinimumSize(this.bColorBackGround.getPreferredSize());
        this.bColorBackGround.setMaximumSize(this.bColorBackGround.getPreferredSize());
        this.bColorBackGround.setBorder(BorderFactory.createLineBorder(Color.WHITE));
        this.bColorBackGround.setIcon(new FlatIcon());
        this.bColorBackGround.setToolTipText("Click to change the background color");
        this.setColorButtonColor(this.backgroundColor3D);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.setBorder(BorderFactory.createEmptyBorder());
        p.add(this.bColorBackGround);
        p.add(Box.createRigidArea(new Dimension(5, 5)));
        p.add(this.comboColorizer);
        p.add(this.checkColorFrame.check);
        return p;
    }

    protected int getActiveBackgroundColor() {
        return this.backgroundColor3D;
    }

    protected void setColorButtonColor(int color) {
        this.backgroundColor3D = color;
        this.bColorBackGround.repaint();
    }

    @Override
    public void controlChanged(Object source) {
        if (source == this.sliderPeriodColor) {
            this.periodAdjust = this.sliderPeriodColor.getValue();
        } else if (source == this.sliderOffsetColor) {
            this.offsetAdjust = this.sliderOffsetColor.getValue();
        } else if (source == this.sliderSpeed3D) {
            this.speedAdjust = this.sliderSpeed3D.getValue();
        } else if (source == this.comboColorizer) {
            this.colorScheme = this.comboColorizer.getSelectedIndex();
        } else if (source == this.checkFog) {
            this.fog = this.checkFog.isSelected();
        } else if (source == this.fieldClip) {
            this.clipDistance = ((Number)this.fieldClip.getValue()).doubleValue();
        } else if (source != this.checkColorFrame.check) {
            throw new RuntimeException("Egads");
        }
        this.callbackModified.process();
    }

    public double periodScale() {
        if (this.periodAdjust > 500) {
            double f = (double)(this.periodAdjust - 500) / 500.0;
            return 1.0 + f * 10.0;
        }
        if (this.periodAdjust < 500) {
            double f = (double)(500 - this.periodAdjust) / 500.0;
            return 1.0 - 0.98 * f;
        }
        return 1.0;
    }

    public double offsetScale() {
        return (double)(this.offsetAdjust - 500) / 500.0;
    }

    public double speedScale() {
        if (this.speedAdjust > 500) {
            double f = (double)(this.speedAdjust - 500) / 500.0;
            return Math.pow(2.0, f * 6.0);
        }
        if (this.speedAdjust < 500) {
            double f = (double)(500 - this.speedAdjust) / 500.0;
            return 1.0 - 0.98 * f;
        }
        return 1.0;
    }

    public void setCallbackBackground(BoofLambdas.ProcessCall callbackBackground) {
        this.callbackBackground = callbackBackground;
    }

    public void setCallbackModified(BoofLambdas.ProcessCall callbackModified) {
        this.callbackModified = callbackModified;
    }

    private class FlatIcon
    implements Icon {
        private FlatIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(new Color(ControlPanelPointCloud.this.getActiveBackgroundColor()));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }

        @Override
        public int getIconWidth() {
            return 20;
        }

        @Override
        public int getIconHeight() {
            return 20;
        }
    }
}

