/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.abst.disparity.ConfigSpeckleFilter;
import boofcv.abst.disparity.DisparitySmoother;
import boofcv.abst.disparity.StereoDisparity;
import boofcv.factory.disparity.BlockMatchingApproach;
import boofcv.factory.disparity.ConfigDisparity;
import boofcv.factory.disparity.ConfigDisparityBM;
import boofcv.factory.disparity.ConfigDisparityError;
import boofcv.factory.disparity.ConfigDisparitySGM;
import boofcv.factory.disparity.DisparityError;
import boofcv.factory.disparity.DisparitySgmError;
import boofcv.factory.disparity.FactoryStereoDisparity;
import boofcv.factory.transform.census.CensusVariants;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.controls.JConfigLength;
import boofcv.gui.image.ShowImages;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class ControlPanelDisparityDense
extends StandardAlgConfigPanel {
    private static final String[] ERRORS_BLOCK = new String[]{"SAD", "Census", "NCC"};
    private static final String[] ERRORS_SGM = new String[]{"Absolute Diff", "Census", "HMI"};
    private final ConfigDisparity configDisparity;
    public final ConfigSpeckleFilter configSpeckle;
    JComboBox<String> comboMethod;
    JComboBox<String> comboError;
    JTabbedPane tabbedPane = new JTabbedPane();
    ControlsBlockMatching controlBM;
    ControlsSemiGlobal controlSGM;
    ControlsSAD controlSad;
    ControlsCensus controlCensus;
    ControlsNCC controlNCC;
    ControlsMutualInfo controlHMI;
    ControlsSpeckleConnComp controlSpeckle;
    boolean ignoreChanges = false;
    Listener listener;
    Class imageType;

    public ControlPanelDisparityDense(ConfigDisparity configDisparity, ConfigSpeckleFilter configSpeckle, Class imageType) {
        this.setBorder(BorderFactory.createEmptyBorder());
        this.configDisparity = configDisparity;
        this.configSpeckle = configSpeckle;
        this.imageType = imageType;
        this.comboMethod = this.combo(e -> this.handleMethod(), configDisparity.approach.ordinal(), "BlockMatch", "BlockMatch-5", "SGM");
        this.comboError = this.isBlockSelected() ? this.combo(e -> this.handleErrorSelected(false), configDisparity.approachBM.errorType.ordinal(), (Object[])ERRORS_BLOCK) : this.combo(e -> this.handleErrorSelected(false), configDisparity.approachSGM.errorType.ordinal(), (Object[])ERRORS_SGM);
        this.controlBM = new ControlsBlockMatching();
        this.controlSGM = new ControlsSemiGlobal();
        this.controlSad = new ControlsSAD();
        this.controlCensus = new ControlsCensus();
        this.controlNCC = new ControlsNCC();
        this.controlHMI = new ControlsMutualInfo();
        this.controlSpeckle = new ControlsSpeckleConnComp();
        this.tabbedPane.addTab("Method", this.getModelControl(this.isBlockSelected()));
        this.tabbedPane.addTab("Error", this.getErrorControl(this.comboError.getSelectedIndex()));
        this.tabbedPane.addTab("Smooth", this.controlSpeckle);
        this.controlBM.setPreferredSize(this.controlSGM.getPreferredSize());
        this.addLabeled(this.comboMethod, "Method");
        this.addLabeled(this.comboError, "Error");
        this.add(this.tabbedPane);
        this.handleErrorSelected(true);
    }

    public static ControlPanelDisparityDense createRange(int disparityMin, int disparityRange, Class imageType) {
        ConfigDisparity c = new ConfigDisparity();
        c.approachBM.disparityMin = disparityMin;
        c.approachBM.disparityRange = disparityRange;
        c.approachSGM.disparityMin = disparityMin;
        c.approachSGM.disparityRange = disparityRange;
        c.approachBM.saveScore = true;
        c.approachBM5.saveScore = true;
        return new ControlPanelDisparityDense(c, new ConfigSpeckleFilter(), imageType);
    }

    public void broadcastChange() {
        Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        if (this.ignoreChanges) {
            return;
        }
        listener.handleDisparityChange();
    }

    public void updateControlEnabled() {
        if (!this.isBlockSelected()) {
            this.controlSGM.updateControlsEnabled();
        }
    }

    public void getDisparityConfig(ConfigDisparity dst) {
        this.configDisparity.approachBM5.setTo(this.configDisparity.approachBM);
        dst.setTo(this.configDisparity);
    }

    public StereoDisparity createAlgorithm() {
        this.configDisparity.approachBM5.setTo(this.configDisparity.approachBM);
        return FactoryStereoDisparity.generic(this.configDisparity, this.imageType);
    }

    public DisparitySmoother createSmoother() {
        this.configDisparity.approachBM5.setTo(this.configDisparity.approachBM);
        Class dispType = this.configDisparity.isSubpixel() ? GrayF32.class : GrayU8.class;
        return FactoryStereoDisparity.removeSpeckle(this.configSpeckle, dispType);
    }

    public int getDisparityMin() {
        if (this.isBlockSelected()) {
            return this.configDisparity.approachBM.disparityMin;
        }
        return this.configDisparity.approachSGM.disparityMin;
    }

    public int getDisparityRange() {
        if (this.isBlockSelected()) {
            return this.configDisparity.approachBM.disparityRange;
        }
        return this.configDisparity.approachSGM.disparityRange;
    }

    private void handleMethod() {
        if (this.configDisparity.approach.ordinal() == this.comboMethod.getSelectedIndex()) {
            return;
        }
        boolean previousBlock = this.isBlockSelected();
        this.configDisparity.approach = ConfigDisparity.Approach.values()[this.comboMethod.getSelectedIndex()];
        boolean block = this.isBlockSelected();
        this.ignoreChanges = true;
        if (block != previousBlock) {
            int activeTab = this.tabbedPane.getSelectedIndex();
            if (block) {
                this.comboError.setModel(new DefaultComboBoxModel<String>(ERRORS_BLOCK));
                this.comboError.setSelectedIndex(this.configDisparity.approachBM.errorType.ordinal());
            } else {
                this.comboError.setModel(new DefaultComboBoxModel<String>(ERRORS_SGM));
                this.comboError.setSelectedIndex(this.configDisparity.approachSGM.errorType.ordinal());
            }
            Component c = this.getModelControl(block);
            if (!block) {
                this.controlSGM.updateControlsEnabled();
            }
            this.tabbedPane.removeTabAt(0);
            this.tabbedPane.insertTab("Method", null, c, null, 0);
            this.tabbedPane.setSelectedIndex(activeTab);
            this.handleErrorSelected(true);
        }
        SwingUtilities.invokeLater(() -> {
            this.ignoreChanges = false;
            this.broadcastChange();
        });
    }

    private Component getModelControl(boolean block) {
        StandardAlgConfigPanel c = block ? this.controlBM : this.controlSGM;
        return c;
    }

    private boolean isBlockSelected() {
        return this.configDisparity.approach != ConfigDisparity.Approach.SGM;
    }

    private void handleErrorSelected(boolean force) {
        int previousIdx;
        boolean block = this.isBlockSelected();
        int n = previousIdx = block ? this.configDisparity.approachBM.errorType.ordinal() : this.configDisparity.approachSGM.errorType.ordinal();
        if (!force && previousIdx == this.comboError.getSelectedIndex()) {
            return;
        }
        int selectedIdx = this.comboError.getSelectedIndex();
        if (!force) {
            this.ignoreChanges = true;
        }
        int activeTab = this.tabbedPane.getSelectedIndex();
        if (block) {
            this.configDisparity.approachBM.errorType = DisparityError.values()[selectedIdx];
            this.controlCensus.update(this.configDisparity.approachBM.configCensus);
            this.controlNCC.update(this.configDisparity.approachBM.configNCC);
        } else {
            this.configDisparity.approachSGM.errorType = DisparitySgmError.values()[selectedIdx];
            this.controlCensus.update(this.configDisparity.approachSGM.configCensus);
            this.controlHMI.update(this.configDisparity.approachSGM.configHMI);
        }
        Component c = this.getErrorControl(selectedIdx);
        this.tabbedPane.removeTabAt(1);
        this.tabbedPane.insertTab("Error", null, c, null, 1);
        this.tabbedPane.setSelectedIndex(activeTab);
        if (!force) {
            SwingUtilities.invokeLater(() -> {
                this.ignoreChanges = false;
                this.broadcastChange();
            });
        }
    }

    private Component getErrorControl(int selectedIdx) {
        StandardAlgConfigPanel c;
        if (this.isBlockSelected()) {
            StandardAlgConfigPanel standardAlgConfigPanel;
            switch (selectedIdx) {
                case 0: {
                    standardAlgConfigPanel = this.controlSad;
                    break;
                }
                case 1: {
                    standardAlgConfigPanel = this.controlCensus;
                    break;
                }
                case 2: {
                    standardAlgConfigPanel = this.controlNCC;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown");
                }
            }
            c = standardAlgConfigPanel;
        } else {
            StandardAlgConfigPanel standardAlgConfigPanel;
            switch (selectedIdx) {
                case 0: {
                    standardAlgConfigPanel = this.controlSad;
                    break;
                }
                case 1: {
                    standardAlgConfigPanel = this.controlCensus;
                    break;
                }
                case 2: {
                    standardAlgConfigPanel = this.controlHMI;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown");
                }
            }
            c = standardAlgConfigPanel;
        }
        return c;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public static void main(String[] args) {
        ControlPanelDisparityDense controls = ControlPanelDisparityDense.createRange(0, 150, GrayU8.class);
        ShowImages.showWindow(controls, "Controls");
    }

    public class ControlsBlockMatching
    extends StandardAlgConfigPanel {
        JSpinner spinnerDisparityMin;
        JSpinner spinnerDisparityRange;
        JSpinner radiusXSpinner;
        JSpinner radiusYSpinner;
        JSpinner spinnerError;
        JSpinner spinnerReverse;
        JSpinner spinnerTexture;
        JCheckBox subpixelToggle;

        ControlsBlockMatching() {
            this.spinnerDisparityMin = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachBM.disparityMin, 0, 1000, 5);
            this.spinnerDisparityRange = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachBM.disparityRange, 1, 254, 5);
            this.radiusXSpinner = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachBM.regionRadiusX, 0, 50, 1);
            this.radiusYSpinner = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachBM.regionRadiusY, 0, 50, 1);
            this.spinnerError = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachBM.maxPerPixelError, -1.0, 80.0, 5.0);
            this.spinnerReverse = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachBM.validateRtoL, -1, 50, 1);
            this.spinnerTexture = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachBM.texture, 0.0, 1.0, 0.05, 1, 3);
            this.subpixelToggle = this.checkbox("Subpixel", ControlPanelDisparityDense.this.configDisparity.approachBM.subpixel, "Subpixel Disparity Estimate");
            this.setBorder(BorderFactory.createEmptyBorder());
            this.addLabeled(this.spinnerDisparityMin, "Min Disp.", "Minimum disparity value considered. (Pixels)");
            this.addLabeled(this.spinnerDisparityRange, "Range Disp.", "Range of disparity values searched. (Pixels)");
            this.addLabeled(this.radiusXSpinner, "Radius X", "Block Width. (Pixels)");
            this.addLabeled(this.radiusYSpinner, "Radius Y", "Block Height. (Pixels)");
            this.addLabeled(this.spinnerError, "Max Error", "Maximum allowed matching error");
            this.addLabeled(this.spinnerTexture, "Texture", "Texture validation. 0 = disabled. 1 = most strict.");
            this.addLabeled(this.spinnerReverse, "Reverse", "Reverse Validation Tolerance. -1 = disable. (Pixels)");
            this.addAlignLeft(this.subpixelToggle);
        }

        @Override
        public void controlChanged(Object source) {
            ConfigDisparityBM c = ControlPanelDisparityDense.this.configDisparity.approachBM;
            if (source == this.spinnerReverse) {
                c.validateRtoL = ((Number)this.spinnerReverse.getValue()).intValue();
            } else if (source == this.spinnerDisparityMin) {
                c.disparityMin = ((Number)this.spinnerDisparityMin.getValue()).intValue();
            } else if (source == this.spinnerDisparityRange) {
                c.disparityRange = ((Number)this.spinnerDisparityRange.getValue()).intValue();
            } else if (source == this.spinnerError) {
                c.maxPerPixelError = ((Number)this.spinnerError.getValue()).intValue();
            } else if (source == this.radiusXSpinner) {
                c.regionRadiusX = ((Number)this.radiusXSpinner.getValue()).intValue();
            } else if (source == this.radiusYSpinner) {
                c.regionRadiusY = ((Number)this.radiusYSpinner.getValue()).intValue();
            } else if (source == this.spinnerTexture) {
                c.texture = ((Number)this.spinnerTexture.getValue()).doubleValue();
            } else if (source == this.subpixelToggle) {
                c.subpixel = this.subpixelToggle.isSelected();
            } else {
                throw new RuntimeException("Unknown");
            }
            ControlPanelDisparityDense.this.broadcastChange();
        }
    }

    public class ControlsSemiGlobal
    extends StandardAlgConfigPanel {
        JComboBox<String> comboPaths;
        JSpinner spinnerPenaltySmall;
        JSpinner spinnerPenaltyLarge;
        JSpinner spinnerDisparityMin;
        JSpinner spinnerDisparityRange;
        JSpinner spinnerError;
        JSpinner spinnerReverse;
        JSpinner spinnerTexture;
        JCheckBox subpixelToggle;
        JCheckBox useBlocks;
        JComboBox<String> comboBlockApproach;
        JSpinner radiusXSpinner;
        JSpinner radiusYSpinner;

        ControlsSemiGlobal() {
            this.comboPaths = this.combo(ControlPanelDisparityDense.this.configDisparity.approachSGM.paths.ordinal(), "1", "2", "4", "8", "16");
            this.spinnerPenaltySmall = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachSGM.penaltySmallChange, 0, 2047, 10);
            this.spinnerPenaltyLarge = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachSGM.penaltyLargeChange, 1, 2047, 10);
            this.spinnerDisparityMin = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachSGM.disparityMin, 0, 1000, 5);
            this.spinnerDisparityRange = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachSGM.disparityRange, 1, 254, 5);
            this.spinnerError = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachSGM.maxError, -1, Short.MAX_VALUE, 200);
            this.spinnerReverse = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachSGM.validateRtoL, -1, 50, 1);
            this.spinnerTexture = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachSGM.texture, 0.0, 1.0, 0.05, 1, 3);
            this.subpixelToggle = this.checkbox("Subpixel", ControlPanelDisparityDense.this.configDisparity.approachSGM.subpixel);
            this.useBlocks = this.checkbox("Use Blocks", ControlPanelDisparityDense.this.configDisparity.approachSGM.useBlocks);
            this.comboBlockApproach = this.combo(ControlPanelDisparityDense.this.configDisparity.approachSGM.configBlockMatch.approach.ordinal(), (Object[])BlockMatchingApproach.values());
            this.radiusXSpinner = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachSGM.configBlockMatch.radiusX, 0, 50, 1);
            this.radiusYSpinner = this.spinner(ControlPanelDisparityDense.this.configDisparity.approachSGM.configBlockMatch.radiusY, 0, 50, 1);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.addLabeled(this.spinnerDisparityMin, "Min Disp.");
            this.addLabeled(this.spinnerDisparityRange, "Range Disp.");
            this.addLabeled(this.spinnerError, "Max Error");
            this.addLabeled(this.spinnerTexture, "Texture");
            this.addLabeled(this.spinnerReverse, "Reverse");
            this.addLabeled(this.comboPaths, "Paths");
            this.addLabeled(this.spinnerPenaltySmall, "Penalty Small");
            this.addLabeled(this.spinnerPenaltyLarge, "Penalty Large");
            this.addAlignLeft(this.subpixelToggle);
            this.addAlignLeft(this.useBlocks);
            this.addLabeled(this.comboBlockApproach, "Approach");
            this.addLabeled(this.radiusXSpinner, "Radius X");
            this.addLabeled(this.radiusYSpinner, "Radius Y");
            this.updateControlsEnabled();
        }

        @Override
        public void controlChanged(Object source) {
            ConfigDisparitySGM c = ControlPanelDisparityDense.this.configDisparity.approachSGM;
            if (source == this.spinnerReverse) {
                c.validateRtoL = ((Number)this.spinnerReverse.getValue()).intValue();
            } else if (source == this.spinnerDisparityMin) {
                c.disparityMin = ((Number)this.spinnerDisparityMin.getValue()).intValue();
            } else if (source == this.spinnerDisparityRange) {
                c.disparityRange = ((Number)this.spinnerDisparityRange.getValue()).intValue();
            } else if (source == this.spinnerError) {
                c.maxError = ((Number)this.spinnerError.getValue()).intValue();
            } else if (source == this.spinnerTexture) {
                c.texture = ((Number)this.spinnerTexture.getValue()).doubleValue();
            } else if (source == this.spinnerPenaltySmall) {
                c.penaltySmallChange = ((Number)this.spinnerPenaltySmall.getValue()).intValue();
            } else if (source == this.spinnerPenaltyLarge) {
                c.penaltyLargeChange = ((Number)this.spinnerPenaltyLarge.getValue()).intValue();
            } else if (source == this.radiusXSpinner) {
                c.configBlockMatch.radiusX = ((Number)this.radiusXSpinner.getValue()).intValue();
            } else if (source == this.radiusYSpinner) {
                c.configBlockMatch.radiusY = ((Number)this.radiusYSpinner.getValue()).intValue();
            } else if (source == this.comboPaths) {
                c.paths = ConfigDisparitySGM.Paths.values()[this.comboPaths.getSelectedIndex()];
            } else if (source == this.subpixelToggle) {
                c.subpixel = this.subpixelToggle.isSelected();
            } else if (source == this.useBlocks) {
                c.useBlocks = this.useBlocks.isSelected();
                this.updateControlsEnabled();
            } else if (source == this.comboBlockApproach) {
                c.configBlockMatch.approach = BlockMatchingApproach.values()[this.comboBlockApproach.getSelectedIndex()];
            } else {
                throw new RuntimeException("Unknown");
            }
            ControlPanelDisparityDense.this.broadcastChange();
        }

        void updateControlsEnabled() {
            boolean e = ControlPanelDisparityDense.this.configDisparity.approachSGM.useBlocks;
            this.comboBlockApproach.setEnabled(e);
            this.radiusXSpinner.setEnabled(e);
            this.radiusYSpinner.setEnabled(e);
        }
    }

    static class ControlsSAD
    extends StandardAlgConfigPanel {
        ControlsSAD() {
        }
    }

    class ControlsCensus
    extends StandardAlgConfigPanel {
        JComboBox<String> comboVariant = this.combo(0, (Object[])CensusVariants.values());
        ConfigDisparityError.Census settings;

        public ControlsCensus() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.addLabeled(this.comboVariant, "Variant");
        }

        public void update(ConfigDisparityError.Census settings) {
            this.settings = settings;
            this.comboVariant.setSelectedIndex(settings.variant.ordinal());
        }

        @Override
        public void controlChanged(Object source) {
            if (source != this.comboVariant) {
                throw new RuntimeException("Unknown");
            }
            this.settings.variant = CensusVariants.values()[this.comboVariant.getSelectedIndex()];
            ControlPanelDisparityDense.this.broadcastChange();
        }
    }

    class ControlsNCC
    extends StandardAlgConfigPanel {
        JSpinner spinnerEps = this.spinner(0.0, 0.0, 1.0, 0.001, "0.0E0", 10);
        ConfigDisparityError.NCC settings;

        ControlsNCC() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.addLabeled(this.spinnerEps, "EPS");
        }

        public void update(ConfigDisparityError.NCC settings) {
            this.settings = settings;
            this.spinnerEps.setValue(settings.eps);
        }

        @Override
        public void controlChanged(Object source) {
            if (source != this.spinnerEps) {
                throw new RuntimeException("Unknown");
            }
            this.settings.eps = ((Number)this.spinnerEps.getValue()).doubleValue();
            ControlPanelDisparityDense.this.broadcastChange();
        }
    }

    class ControlsMutualInfo
    extends StandardAlgConfigPanel {
        JSpinner spinnerBlur = this.spinner(1, 0, 10, 1);
        JSpinner spinnerPyramidWidth = this.spinner(20, 20, 10000, 50);
        JSpinner spinnerExtra = this.spinner(0, 0, 5, 1);
        ConfigDisparityError.HMI settings;

        ControlsMutualInfo() {
            this.setBorder(BorderFactory.createEmptyBorder());
            this.addLabeled(this.spinnerBlur, "Blur Radius");
            this.addLabeled(this.spinnerPyramidWidth, "Pyr Min W");
            this.addLabeled(this.spinnerExtra, "Extra Iter.");
        }

        public void update(ConfigDisparityError.HMI settings) {
            this.settings = settings;
            this.spinnerBlur.setValue(settings.smoothingRadius);
            this.spinnerPyramidWidth.setValue(settings.pyramidLayers.minWidth);
            this.spinnerExtra.setValue(settings.extraIterations);
        }

        @Override
        public void controlChanged(Object source) {
            if (source == this.spinnerBlur) {
                this.settings.smoothingRadius = ((Number)this.spinnerBlur.getValue()).intValue();
            } else if (source == this.spinnerPyramidWidth) {
                this.settings.pyramidLayers.minWidth = ((Number)this.spinnerPyramidWidth.getValue()).intValue();
                this.settings.pyramidLayers.minHeight = ((Number)this.spinnerPyramidWidth.getValue()).intValue();
            } else if (source == this.spinnerExtra) {
                this.settings.extraIterations = ((Number)this.spinnerExtra.getValue()).intValue();
            } else {
                throw new RuntimeException("Unknown");
            }
            ControlPanelDisparityDense.this.broadcastChange();
        }
    }

    class ControlsSpeckleConnComp
    extends StandardAlgConfigPanel {
        JSpinner spinnerSimilar;
        JConfigLength lengthRegion;

        public ControlsSpeckleConnComp() {
            this.spinnerSimilar = this.spinner(ControlPanelDisparityDense.this.configSpeckle.similarTol, 0.0, 100.0, 0.5);
            this.lengthRegion = this.configLength(ControlPanelDisparityDense.this.configSpeckle.maximumArea, 0.0, 1000000.0);
            this.setBorder(BorderFactory.createEmptyBorder());
            this.addLabeled(this.spinnerSimilar, "Simularity", "How similar two pixel values need to be considered connected.");
            this.addLabeled(this.lengthRegion, "Region", "Maximum region size for removal");
        }

        @Override
        public void controlChanged(Object source) {
            if (source == this.spinnerSimilar) {
                ControlPanelDisparityDense.this.configSpeckle.similarTol = ((Number)this.spinnerSimilar.getValue()).floatValue();
            } else if (source == this.lengthRegion) {
                ControlPanelDisparityDense.this.configSpeckle.maximumArea.setTo(this.lengthRegion.getValue());
            } else {
                throw new RuntimeException("Unknown");
            }
            ControlPanelDisparityDense.this.broadcastChange();
        }
    }

    public static interface Listener {
        public void handleDisparityChange();
    }
}

