/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.controls;

import boofcv.abst.feature.associate.AssociateDescription2D;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.tracker.ConfigTrackerDda;
import boofcv.abst.tracker.PointTracker;
import boofcv.factory.feature.associate.ConfigAssociate;
import boofcv.factory.feature.describe.ConfigDescribeRegion;
import boofcv.factory.feature.detdesc.ConfigDetectDescribe;
import boofcv.factory.feature.detect.interest.ConfigDetectInterestPoint;
import boofcv.factory.tracker.FactoryPointTracker;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.gui.controls.ControlPanelDetDescAssocBase;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import java.awt.BorderLayout;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SwingUtilities;

public class ControlPanelDdaTracker
extends ControlPanelDetDescAssocBase {
    private final JPanel controlPanel = new JPanel(new BorderLayout());
    private final Listener listener;
    public final ConfigTrackerDda configDDA;
    private ControlTracker controlTrackerDDA;

    public ControlPanelDdaTracker(Listener listener) {
        this.listener = listener;
        this.configDDA = new ConfigTrackerDda();
        this.configDetDesc.detectFastHessian.maxFeaturesPerScale = 400;
        this.configDetDesc.detectPoint.general.threshold = 100.0f;
        this.configDetDesc.detectPoint.general.radius = 4;
        this.configDetDesc.detectPoint.shiTomasi.radius = 4;
        this.configAssociate.greedy.scoreRatioThreshold = 0.75;
    }

    public ControlPanelDdaTracker(Listener listener, ConfigTrackerDda configTracker, ConfigDetectDescribe detDesc, ConfigAssociate associate) {
        this.listener = listener;
        this.configDDA = configTracker;
        this.configDetDesc = detDesc;
        this.configAssociate = associate;
    }

    @Override
    public void initializeControlsGUI() {
        this.associateWithPixels = true;
        super.initializeControlsGUI();
        this.controlTrackerDDA = new ControlTracker();
        this.controlTrackerDDA.setBorder(BorderFactory.createTitledBorder("Tracker"));
        this.add(this.controlTrackerDDA);
        this.addLabeled(this.comboDetect, "Detect", "Point feature detectors");
        this.addLabeled(this.comboDescribe, "Describe", "Point feature Descriptors");
        this.addLabeled(this.comboAssociate, "Associate", "Feature association Approach");
        this.add(this.controlPanel);
        this.updateActiveControls(0);
    }

    @Override
    protected void handleControlsUpdated() {
        this.listener.changedPointTrackerDda();
    }

    public <T extends ImageBase<T>> PointTracker<T> createTracker(ImageType<T> imageType) {
        Class inputType = imageType.getImageClass();
        DetectDescribePoint detDesc = this.createDetectDescribe(inputType);
        AssociateDescription2D associate = this.createAssociate2(detDesc);
        return FactoryPointTracker.dda(detDesc, associate, this.configDDA);
    }

    private void updateActiveControls(int which) {
        JPanel inside;
        this.controlPanel.removeAll();
        switch (which) {
            case 0: {
                JPanel jPanel = this.getDetectorPanel();
                break;
            }
            case 1: {
                JPanel jPanel = this.getDescriptorPanel();
                break;
            }
            case 2: {
                JPanel jPanel = this.getAssociatePanel();
                break;
            }
            default: {
                JPanel jPanel = inside = null;
            }
        }
        if (inside != null) {
            this.controlPanel.add("Center", inside);
        }
        this.controlPanel.validate();
        SwingUtilities.invokeLater(this::repaint);
    }

    @Override
    public void controlChanged(Object source) {
        int which = -1;
        if (source == this.comboDetect) {
            this.configDetDesc.typeDetector = ConfigDetectInterestPoint.Type.values()[this.comboDetect.getSelectedIndex()];
            which = 0;
        } else if (source == this.comboDescribe) {
            this.configDetDesc.typeDescribe = ConfigDescribeRegion.Type.values()[this.comboDescribe.getSelectedIndex()];
            which = 1;
            if (this.configDetDesc.typeDescribe == ConfigDescribeRegion.Type.BRIEF) {
                this.configAssociate.type = ConfigAssociate.AssociationType.GREEDY;
                this.comboAssociate.setEnabled(false);
            } else {
                this.configAssociate.type = ConfigAssociate.AssociationType.values()[this.comboAssociate.getSelectedIndex()];
                this.comboAssociate.setEnabled(true);
            }
        } else if (source == this.comboAssociate) {
            this.configAssociate.type = ConfigAssociate.AssociationType.values()[this.comboAssociate.getSelectedIndex()];
            which = 2;
        }
        this.updateActiveControls(which);
        this.listener.changedPointTrackerDda();
    }

    public static interface Listener {
        public void changedPointTrackerDda();
    }

    public class ControlTracker
    extends StandardAlgConfigPanel {
        JSpinner spinnerMaxUnused;
        JCheckBox checkUpdate;

        public ControlTracker() {
            this.spinnerMaxUnused = this.spinner(ControlPanelDdaTracker.this.configDDA.maxInactiveTracks, 0, 5000, 10);
            this.checkUpdate = this.checkbox("Update Description", ControlPanelDdaTracker.this.configDDA.updateDescription);
            this.addLabeled(this.spinnerMaxUnused, "Max Unused", "Maximum number of unused/not visible tracks kept around");
            this.addAlignLeft(this.checkUpdate, "If the description is updated after every frame or not");
        }

        @Override
        public void controlChanged(Object source) {
            if (source == this.spinnerMaxUnused) {
                ControlPanelDdaTracker.this.configDDA.maxInactiveTracks = (Integer)this.spinnerMaxUnused.getValue();
            } else if (source == this.checkUpdate) {
                ControlPanelDdaTracker.this.configDDA.updateDescription = this.checkUpdate.isSelected();
            } else {
                throw new RuntimeException("BUG");
            }
            ControlPanelDdaTracker.this.listener.changedPointTrackerDda();
        }
    }
}

