/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.abst.fiducial.calib.RenderCalibrationTargets;
import boofcv.gui.BoofSwingUtil;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import georegression.struct.point.Point2D_F64;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class RenderCalibrationTargetsGraphics2D
extends RenderCalibrationTargets {
    int padding;
    double unitsToPixels;
    BufferedImage buffered;
    Graphics2D g2;
    double paperWidth;
    double paperHeight;
    int offsetX;
    int offsetY;

    public RenderCalibrationTargetsGraphics2D(int padding, double unitsToPixels) {
        this.padding = padding;
        this.unitsToPixels = unitsToPixels;
    }

    public void setPaperSize(double widthUnits, double heightUnits) {
        this.paperWidth = widthUnits;
        this.paperHeight = heightUnits;
    }

    @Override
    public void specifySize(double width, double height) {
        int w = (int)(this.unitsToPixels * width + 0.5);
        int h = (int)(this.unitsToPixels * height + 0.5);
        if (this.paperWidth <= 0.0 || this.paperHeight <= 0.0) {
            this.offsetX = this.offsetY = this.padding;
        } else {
            this.offsetX = ((int)(this.unitsToPixels * this.paperWidth + 0.5) - w) / 2;
            this.offsetY = ((int)(this.unitsToPixels * this.paperHeight + 0.5) - h) / 2;
        }
        this.buffered = this.offsetX <= 0 || this.offsetY <= 0 ? new BufferedImage(w, h, 1) : new BufferedImage(w + 2 * this.offsetX, h + 2 * this.offsetY, 1);
        this.g2 = this.buffered.createGraphics();
        this.g2.setColor(Color.WHITE);
        this.g2.fillRect(0, 0, this.buffered.getWidth(), this.buffered.getHeight());
        this.g2.setColor(Color.BLACK);
        BoofSwingUtil.antialiasing(this.g2);
    }

    @Override
    public void markerToTarget(double x, double y, Point2D_F64 p) {
        p.x = (double)this.offsetX + x * this.unitsToPixels;
        p.y = (double)this.offsetY + y * this.unitsToPixels;
    }

    @Override
    public void drawSquare(double x, double y, double width) {
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.x = (double)this.offsetX + x * this.unitsToPixels;
        r.y = (double)this.offsetY + y * this.unitsToPixels;
        r.height = r.width = width * this.unitsToPixels;
        this.g2.fill(r);
    }

    @Override
    public void drawCircle(double cx, double cy, double diameter) {
        Ellipse2D.Double ellipse = new Ellipse2D.Double();
        ellipse.x = (double)this.offsetX + (cx - diameter / 2.0) * this.unitsToPixels;
        ellipse.y = (double)this.offsetY + (cy - diameter / 2.0) * this.unitsToPixels;
        ellipse.width = diameter * this.unitsToPixels;
        ellipse.height = diameter * this.unitsToPixels;
        this.g2.fill(ellipse);
    }

    public double getWidthWorld() {
        return (double)this.buffered.getWidth() / this.unitsToPixels;
    }

    public double getHeightWorld() {
        return (double)this.buffered.getHeight() / this.unitsToPixels;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public GrayU8 getGrayU8() {
        GrayU8 gray = new GrayU8(this.buffered.getWidth(), this.buffered.getHeight());
        ConvertBufferedImage.convertFrom(this.buffered, gray);
        return gray;
    }

    public GrayF32 getGrayF32() {
        GrayF32 gray = new GrayF32(this.buffered.getWidth(), this.buffered.getHeight());
        ConvertBufferedImage.convertFrom(this.buffered, gray);
        return gray;
    }

    public BufferedImage getBuffered() {
        return this.buffered;
    }
}

