/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.tracker;

import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.abst.tracker.ConfigCirculantTracker;
import boofcv.abst.tracker.ConfigComaniciu2003;
import boofcv.alg.interpolate.InterpolatePixelMB;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.tracker.circulant.CirculantTracker;
import boofcv.alg.tracker.meanshift.LikelihoodHistCoupled_PL_U8;
import boofcv.alg.tracker.meanshift.LikelihoodHistCoupled_SB_U8;
import boofcv.alg.tracker.meanshift.LikelihoodHueSatHistCoupled_PL_U8;
import boofcv.alg.tracker.meanshift.LikelihoodHueSatHistInd_PL_U8;
import boofcv.alg.tracker.meanshift.LocalWeightedHistogramRotRect;
import boofcv.alg.tracker.meanshift.PixelLikelihood;
import boofcv.alg.tracker.meanshift.TrackerMeanShiftComaniciu2003;
import boofcv.alg.tracker.sfot.ConfigSfot;
import boofcv.alg.tracker.sfot.SparseFlowObjectTracker;
import boofcv.alg.tracker.tld.ConfigTld;
import boofcv.alg.tracker.tld.TldTracker;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageMultiBand;
import boofcv.struct.image.ImageType;

public class FactoryTrackerObjectAlgs {
    public static <T extends ImageGray<T>, D extends ImageGray<D>> TldTracker<T, D> createTLD(ConfigTld config, InterpolatePixelS<T> interpolate, ImageGradient<T, D> gradient, Class<T> imageType, Class<D> derivType) {
        return new TldTracker<T, D>(config, interpolate, gradient, imageType, derivType);
    }

    public static <T extends ImageGray<T>, D extends ImageGray<D>> SparseFlowObjectTracker<T, D> createSparseFlow(ConfigSfot config, Class<T> imageType, Class<D> derivType, ImageGradient<T, D> gradient) {
        return new SparseFlowObjectTracker<T, D>(config, imageType, derivType, gradient);
    }

    public static <T extends ImageMultiBand<T>> PixelLikelihood<T> likelihoodHueSatHistIndependent(double maxPixelValue, int numHistogramBins, ImageType<T> imageType) {
        if (imageType.getFamily() != ImageType.Family.PLANAR) {
            throw new IllegalArgumentException("Only Planar images supported currently");
        }
        if (imageType.getNumBands() != 3) {
            throw new IllegalArgumentException("Input image type must have 3 bands.");
        }
        if (imageType.getDataType() == ImageDataType.U8) {
            return new LikelihoodHueSatHistInd_PL_U8((int)maxPixelValue, numHistogramBins);
        }
        throw new RuntimeException("Band type not yet supported " + imageType.getDataType());
    }

    public static <T extends ImageMultiBand<T>> PixelLikelihood<T> likelihoodHueSatHistCoupled(double maxPixelValue, int numHistogramBins, ImageType<T> imageType) {
        if (imageType.getFamily() != ImageType.Family.PLANAR) {
            throw new IllegalArgumentException("Only Planar images supported currently");
        }
        if (imageType.getNumBands() != 3) {
            throw new IllegalArgumentException("Input image type must have 3 bands.");
        }
        if (imageType.getDataType() == ImageDataType.U8) {
            return new LikelihoodHueSatHistCoupled_PL_U8((int)maxPixelValue, numHistogramBins);
        }
        throw new RuntimeException("Band type not yet supported " + imageType.getDataType());
    }

    public static <T extends ImageBase<T>> PixelLikelihood<T> likelihoodHistogramCoupled(double maxPixelValue, int numHistogramBins, ImageType<T> imageType) {
        switch (imageType.getFamily()) {
            case GRAY: {
                if (imageType.getDataType() != ImageDataType.U8) {
                    throw new IllegalArgumentException("Only U8 currently supported");
                }
                return new LikelihoodHistCoupled_SB_U8((int)maxPixelValue, numHistogramBins);
            }
            case PLANAR: {
                if (imageType.getDataType() == ImageDataType.U8) {
                    return new LikelihoodHistCoupled_PL_U8((int)maxPixelValue, numHistogramBins);
                }
                throw new RuntimeException("Band type not yet supported " + imageType.getDataType());
            }
        }
        throw new IllegalArgumentException("Image family not yet supported. Try Planar");
    }

    public static <T extends ImageGray<T>> CirculantTracker<T> circulant(ConfigCirculantTracker config, Class<T> imageType) {
        if (config == null) {
            config = new ConfigCirculantTracker();
        }
        InterpolatePixelS<T> interp = FactoryInterpolation.bilinearPixelS(imageType, BorderType.EXTENDED);
        return new CirculantTracker<T>(config.output_sigma_factor, config.sigma, config.lambda, config.interp_factor, config.padding, config.workSpace, config.maxPixelValue, interp);
    }

    public static <T extends ImageBase<T>> TrackerMeanShiftComaniciu2003<T> meanShiftComaniciu2003(ConfigComaniciu2003 config, ImageType<T> imageType) {
        if (config == null) {
            config = new ConfigComaniciu2003();
        }
        InterpolatePixelMB<T> interp = FactoryInterpolation.createPixelMB(0.0, config.maxPixelValue, config.interpolation, BorderType.EXTENDED, imageType);
        LocalWeightedHistogramRotRect<T> hist = new LocalWeightedHistogramRotRect<T>(config.numSamples, config.numSigmas, config.numHistogramBins, imageType.getNumBands(), config.maxPixelValue, interp);
        return new TrackerMeanShiftComaniciu2003<T>(config.updateHistogram, config.meanShiftMaxIterations, config.meanShiftMinimumChange, config.scaleWeight, config.minimumSizeRatio, config.scaleChange, hist);
    }
}

