/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.structure;

import boofcv.abst.feature.associate.AssociateDescriptionHashSets;
import boofcv.abst.feature.describe.DescribePoint;
import boofcv.abst.feature.describe.DescribePointRadiusAngle;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.geo.bundle.MetricBundleAdjustmentUtils;
import boofcv.abst.scene.nister2006.FeatureSceneRecognitionNister2006;
import boofcv.alg.mvs.MultiViewStereoFromKnownSceneStructure;
import boofcv.alg.similar.ConfigSimilarImagesSceneRecognition;
import boofcv.alg.similar.ConfigSimilarImagesTrackThenMatch;
import boofcv.alg.similar.ImageSimilarityAssociatedRatio;
import boofcv.alg.similar.SimilarImagesSceneRecognition;
import boofcv.alg.similar.SimilarImagesTrackThenMatch;
import boofcv.alg.structure.EpipolarScore3D;
import boofcv.alg.structure.GeneratePairwiseImageGraph;
import boofcv.alg.structure.GenerateStereoPairGraphFromScene;
import boofcv.alg.structure.SparseSceneToDenseCloud;
import boofcv.alg.structure.score3d.ScoreFundamentalHomographyCompatibility;
import boofcv.alg.structure.score3d.ScoreFundamentalVsRotation;
import boofcv.alg.structure.score3d.ScoreRatioFundamentalHomography;
import boofcv.alg.video.SelectFramesForReconstruction3D;
import boofcv.factory.disparity.FactoryStereoDisparity;
import boofcv.factory.feature.associate.FactoryAssociation;
import boofcv.factory.feature.describe.FactoryDescribePoint;
import boofcv.factory.feature.describe.FactoryDescribePointRadiusAngle;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.factory.scene.FactorySceneRecognition;
import boofcv.factory.sfm.ConfigBundleUtils;
import boofcv.factory.struct.FactoryTupleDesc;
import boofcv.factory.structure.ConfigEpipolarScore3D;
import boofcv.factory.structure.ConfigGeneratePairwiseImageGraph;
import boofcv.factory.structure.ConfigSelectFrames3D;
import boofcv.factory.structure.ConfigSparseToDenseCloud;
import boofcv.factory.tracker.FactoryPointTracker;
import boofcv.struct.KernelRadius2D;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.homography.Homography2D_F64;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class FactorySceneReconstruction {
    public static MetricBundleAdjustmentUtils bundleUtils(@Nullable ConfigBundleUtils config) {
        if (config == null) {
            config = new ConfigBundleUtils();
        }
        MetricBundleAdjustmentUtils alg = new MetricBundleAdjustmentUtils(config.triangulation, config.homogenous);
        alg.configConverge.setTo(config.converge);
        alg.configScale = config.scale;
        alg.keepFraction = config.keepFraction;
        return alg;
    }

    public static GeneratePairwiseImageGraph generatePairwise(@Nullable ConfigGeneratePairwiseImageGraph config) {
        if (config == null) {
            config = new ConfigGeneratePairwiseImageGraph();
        }
        EpipolarScore3D scorer = FactorySceneReconstruction.epipolarScore3D(config.score);
        return new GeneratePairwiseImageGraph(scorer);
    }

    public static EpipolarScore3D epipolarScore3D(ConfigEpipolarScore3D config) {
        EpipolarScore3D epipolarScore3D;
        ModelMatcher<DMatrixRMaj, AssociatedPair> ransac3D = FactoryMultiViewRobust.fundamentalRansac(config.fundamental, config.ransacF);
        switch (config.type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case MODEL_INLIERS: {
                Ransac<Homography2D_F64, AssociatedPair> ransacH = FactoryMultiViewRobust.homographyRansac(config.typeInliers.homography, config.typeInliers.ransacH);
                ScoreRatioFundamentalHomography alg = new ScoreRatioFundamentalHomography(ransac3D, ransacH);
                alg.minimumInliers.setTo(config.typeInliers.minimumInliers);
                alg.ratio3D = config.typeInliers.ratio3D;
                epipolarScore3D = alg;
                break;
            }
            case FUNDAMENTAL_COMPATIBLE: {
                ScoreFundamentalHomographyCompatibility alg = new ScoreFundamentalHomographyCompatibility(ransac3D);
                alg.inlierErrorTol = config.typeCompatible.inlierErrorTol;
                alg.ratio3D = config.typeCompatible.ratio3D;
                alg.maxRatioScore = config.typeCompatible.maxRatioScore;
                alg.minimumInliers.setTo(config.typeCompatible.minimumInliers);
                epipolarScore3D = alg;
                break;
            }
            case FUNDAMENTAL_ROTATION: {
                ScoreFundamentalVsRotation alg = new ScoreFundamentalVsRotation(ransac3D);
                alg.inlierErrorTol = config.typeRotation.inlierErrorTol;
                alg.ratio3D = config.typeRotation.ratio3D;
                alg.maxRatioScore = config.typeRotation.maxRatioScore;
                alg.minimumInliers.setTo(config.typeRotation.minimumInliers);
                epipolarScore3D = alg;
                break;
            }
        }
        return epipolarScore3D;
    }

    public static <T extends ImageGray<T>> SparseSceneToDenseCloud<T> sparseSceneToDenseCloud(@Nullable ConfigSparseToDenseCloud config, ImageType<T> imageType) {
        if (config == null) {
            config = new ConfigSparseToDenseCloud();
        }
        Class grayType = imageType.getImageClass();
        SparseSceneToDenseCloud s2c = new SparseSceneToDenseCloud(grayType);
        MultiViewStereoFromKnownSceneStructure mvs = s2c.getMultiViewStereo();
        mvs.minimumQuality3D = config.mvs.minimumQuality3D;
        mvs.maximumCenterOverlap = config.mvs.maximumCenterOverlap;
        mvs.maxCombinePairs = config.mvs.maxCombinePairs;
        mvs.getComputeFused().disparityErrorThresholdScale = config.mvs.disparityErrorThresholdScale;
        mvs.setStereoDisparity(FactoryStereoDisparity.generic(config.disparity, grayType, GrayF32.class));
        mvs.getComputeFused().setDisparitySmoother(FactoryStereoDisparity.removeSpeckle(config.smoother, GrayF32.class));
        GenerateStereoPairGraphFromScene generateGraph = s2c.getGenerateGraph();
        generateGraph.targetDisparity = config.graph.targetDisparity;
        generateGraph.countSmootherParam = config.graph.countSmootherParam;
        generateGraph.minimumCommonFeaturesFrac = config.graph.minimumCommonFeaturesFrac;
        KernelRadius2D blockSize = config.disparity.getBlockSize();
        mvs.getComputeFused().disparityBlockRadius = blockSize.getLargestAxis();
        return s2c;
    }

    public static <Image extends ImageBase<Image>, TD extends TupleDesc<TD>> SimilarImagesSceneRecognition<Image, TD> createSimilarImages(@Nullable ConfigSimilarImagesSceneRecognition config, ImageType<Image> imageType) {
        if (config == null) {
            config = new ConfigSimilarImagesSceneRecognition();
        }
        DetectDescribePoint detector = FactoryDetectDescribe.generic(config.features, imageType.getImageClass());
        FeatureSceneRecognitionNister2006<TupleDesc> recognitizer = FactorySceneRecognition.createSceneNister2006(config.recognizeNister2006, detector::createDescription);
        AssociateDescriptionHashSets associator = new AssociateDescriptionHashSets(FactoryAssociation.generic(config.associate, detector));
        SimilarImagesSceneRecognition similar = new SimilarImagesSceneRecognition(detector, associator, recognitizer, () -> FactoryTupleDesc.createPacked(detector));
        similar.setSimilarityTest(new ImageSimilarityAssociatedRatio(config.minimumSimilar));
        similar.setLimitMatchesConsider(config.limitMatchesConsider);
        return similar;
    }

    public static <Image extends ImageGray<Image>, TD extends TupleDesc<TD>> SimilarImagesTrackThenMatch<Image, TD> createTrackThenMatch(@Nullable ConfigSimilarImagesTrackThenMatch config, ImageType<Image> imageType) {
        if (config == null) {
            config = new ConfigSimilarImagesTrackThenMatch();
        }
        DescribePoint detector = FactoryDescribePoint.generic(config.descriptions, imageType);
        FeatureSceneRecognitionNister2006<TupleDesc> recognitizer = FactorySceneRecognition.createSceneNister2006(config.recognizeNister2006, detector::createDescription);
        AssociateDescriptionHashSets associator = new AssociateDescriptionHashSets(FactoryAssociation.generic(config.associate, detector));
        SimilarImagesTrackThenMatch<Image, TupleDesc> similar = new SimilarImagesTrackThenMatch<Image, TupleDesc>(detector, associator, recognitizer, () -> FactoryTupleDesc.createPacked(detector));
        similar.setSimilarityTest(new ImageSimilarityAssociatedRatio(config.minimumSimilar));
        similar.setLimitQuery(config.limitQuery);
        similar.setMinimumRecognizeDistance(config.minimumRecognizeDistance);
        similar.searchRadius = config.sequentialSearchRadius;
        similar.minimumCommonTracks.setTo(config.sequentialMinimumCommonTracks);
        return similar;
    }

    public static <T extends ImageGray<T>> SelectFramesForReconstruction3D<T> frameSelector3D(@Nullable ConfigSelectFrames3D config, ImageType<T> imageType) {
        if (config == null) {
            config = new ConfigSelectFrames3D();
        }
        Class grayType = imageType.getImageClass();
        DescribePointRadiusAngle describe = FactoryDescribePointRadiusAngle.generic(config.describe, imageType);
        SelectFramesForReconstruction3D alg = new SelectFramesForReconstruction3D(describe);
        alg.config.setTo(config);
        alg.setTracker(FactoryPointTracker.tracker(config.tracker, grayType, null));
        alg.setAssociate(FactoryAssociation.generic2(config.associate, describe));
        alg.setScorer(FactorySceneReconstruction.epipolarScore3D(config.scorer3D));
        return alg;
    }
}

