/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.shape;

import boofcv.factory.shape.ConfigPolygonFromContour;
import boofcv.factory.shape.ConfigRefinePolygonLineToImage;
import boofcv.struct.Configuration;
import org.jetbrains.annotations.Nullable;

public class ConfigPolygonDetector
implements Configuration {
    public ConfigPolygonFromContour detector = new ConfigPolygonFromContour(3, 10000);
    public double minimumRefineEdgeIntensity = 6.0;
    public boolean refineContour = false;
    public boolean adjustForThresholdBias = true;
    @Nullable
    public ConfigRefinePolygonLineToImage refineGray = new ConfigRefinePolygonLineToImage();

    public ConfigPolygonDetector(int minimumSides, int maximumSides) {
        this.detector = new ConfigPolygonFromContour(minimumSides, maximumSides);
    }

    public ConfigPolygonDetector(boolean clockwise, int minimumSides, int maximumSides) {
        this.detector = new ConfigPolygonFromContour(clockwise, minimumSides, maximumSides);
    }

    public ConfigPolygonDetector() {
    }

    public ConfigPolygonDetector setTo(ConfigPolygonDetector src) {
        this.detector.setTo(src.detector);
        this.minimumRefineEdgeIntensity = src.minimumRefineEdgeIntensity;
        this.refineContour = src.refineContour;
        this.adjustForThresholdBias = src.adjustForThresholdBias;
        if (src.refineGray == null) {
            this.refineGray = null;
        } else {
            if (this.refineGray == null) {
                this.refineGray = new ConfigRefinePolygonLineToImage();
            }
            this.refineGray.setTo(src.refineGray);
        }
        return this;
    }

    @Override
    public void checkValidity() {
    }

    public String toString() {
        return "ConfigPolygonDetector{detector=" + this.detector + ", minimumEdgeIntensity=" + this.minimumRefineEdgeIntensity + ", refineContour=" + this.refineContour + ", refineGray=" + this.refineGray + "}";
    }
}

