/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.scene;

import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.abst.feature.detect.interest.PointDetectorTypes;
import boofcv.abst.scene.ConfigFeatureToSceneRecognition;
import boofcv.abst.scene.FeatureSceneRecognition;
import boofcv.abst.scene.WrapFeatureToSceneRecognition;
import boofcv.abst.scene.ann.ConfigRecognitionNearestNeighbor;
import boofcv.abst.scene.ann.FeatureSceneRecognitionNearestNeighbor;
import boofcv.abst.scene.nister2006.ConfigRecognitionNister2006;
import boofcv.abst.scene.nister2006.FeatureSceneRecognitionNister2006;
import boofcv.factory.feature.detdesc.FactoryDetectDescribe;
import boofcv.factory.feature.detect.interest.ConfigDetectInterestPoint;
import boofcv.factory.tracker.ConfigPointTracker;
import boofcv.misc.BoofLambdas;
import boofcv.misc.FactoryFilterLambdas;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import org.ddogleg.struct.Factory;
import org.jetbrains.annotations.Nullable;

public class FactorySceneRecognition {
    public static ConfigPointTracker createDefaultTrackerConfig() {
        ConfigPointTracker config = new ConfigPointTracker();
        config.typeTracker = ConfigPointTracker.TrackerType.KLT;
        config.klt.pruneClose = true;
        config.klt.toleranceFB = 1.0;
        config.klt.templateRadius = 5;
        config.klt.maximumTracks.setFixed(800.0);
        config.klt.config.maxIterations = 30;
        config.detDesc.typeDetector = ConfigDetectInterestPoint.Type.POINT;
        config.detDesc.detectPoint.type = PointDetectorTypes.SHI_TOMASI;
        config.detDesc.detectPoint.shiTomasi.radius = 3;
        config.detDesc.detectPoint.general.radius = 6;
        config.detDesc.detectPoint.general.threshold = 0.0f;
        return config;
    }

    public static <Image extends ImageBase<Image>, TD extends TupleDesc<TD>> WrapFeatureToSceneRecognition<Image, TD> createFeatureToScene(@Nullable ConfigFeatureToSceneRecognition config, ImageType<Image> imageType) {
        FeatureSceneRecognition<TupleDesc> featureSceneRecognition;
        if (config == null) {
            config = new ConfigFeatureToSceneRecognition();
        }
        DetectDescribePoint detector = FactoryDetectDescribe.generic(config.features, imageType.getImageClass());
        BoofLambdas.Transform<Image> downSample = FactoryFilterLambdas.createDownSampleFilter(config.maxImagePixels, imageType);
        switch (config.typeRecognize) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NISTER_2006: {
                featureSceneRecognition = FactorySceneRecognition.createSceneNister2006(config.recognizeNister2006, detector::createDescription);
                break;
            }
            case NEAREST_NEIGHBOR: {
                featureSceneRecognition = FactorySceneRecognition.createSceneNearestNeighbor(config.recognizeNeighbor, detector::createDescription);
            }
        }
        FeatureSceneRecognition<TupleDesc> recognitizer = featureSceneRecognition;
        WrapFeatureToSceneRecognition alg = new WrapFeatureToSceneRecognition(detector, downSample, recognitizer);
        alg.config = config;
        return alg;
    }

    public static <TD extends TupleDesc<TD>> FeatureSceneRecognitionNister2006<TD> createSceneNister2006(@Nullable ConfigRecognitionNister2006 config, Factory<TD> factory) {
        if (config == null) {
            config = new ConfigRecognitionNister2006();
        }
        return new FeatureSceneRecognitionNister2006<TD>(config, factory);
    }

    public static <TD extends TupleDesc<TD>> FeatureSceneRecognitionNearestNeighbor<TD> createSceneNearestNeighbor(@Nullable ConfigRecognitionNearestNeighbor config, Factory<TD> factory) {
        if (config == null) {
            config = new ConfigRecognitionNearestNeighbor();
        }
        return new FeatureSceneRecognitionNearestNeighbor<TD>(config, factory);
    }
}

