/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.geo;

import boofcv.abst.geo.Estimate1ofEpipolar;
import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.Estimate1ofPrNP;
import boofcv.abst.geo.Estimate1ofTrifocalTensor;
import boofcv.abst.geo.EstimateNofEpipolar;
import boofcv.abst.geo.EstimateNofPnP;
import boofcv.abst.geo.RefineEpipolar;
import boofcv.abst.geo.RefinePnP;
import boofcv.abst.geo.RefineThreeViewProjective;
import boofcv.abst.geo.RefineTriangulateEpipolar;
import boofcv.abst.geo.RefineTriangulateMetric;
import boofcv.abst.geo.RefineTriangulateMetricH;
import boofcv.abst.geo.RefineTriangulateProjective;
import boofcv.abst.geo.Triangulate2ViewsMetric;
import boofcv.abst.geo.Triangulate2ViewsMetricH;
import boofcv.abst.geo.Triangulate2ViewsProjective;
import boofcv.abst.geo.TriangulateNViewsMetric;
import boofcv.abst.geo.TriangulateNViewsMetricH;
import boofcv.abst.geo.TriangulateNViewsProjective;
import boofcv.abst.geo.bundle.BundleAdjustment;
import boofcv.abst.geo.bundle.BundleAdjustmentSchur;
import boofcv.abst.geo.bundle.BundleAdjustmentSchur_DDRM;
import boofcv.abst.geo.bundle.BundleAdjustmentSchur_DSCC;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.abst.geo.bundle.SceneStructureProjective;
import boofcv.abst.geo.f.Estimate1toNofEpipolar;
import boofcv.abst.geo.f.EstimateNto1ofEpipolar;
import boofcv.abst.geo.f.LeastSquaresFundamental;
import boofcv.abst.geo.f.WrapEssentialNister5;
import boofcv.abst.geo.f.WrapFundamentalLinear7;
import boofcv.abst.geo.f.WrapFundamentalLinear8;
import boofcv.abst.geo.h.HomographyDLT_to_Epipolar;
import boofcv.abst.geo.h.HomographyTLS_to_Epipolar;
import boofcv.abst.geo.h.LeastSquaresHomography;
import boofcv.abst.geo.pose.Estimate1toNofPnP;
import boofcv.abst.geo.pose.EstimateNto1ofPnP;
import boofcv.abst.geo.pose.IPPE_to_EstimatePnP;
import boofcv.abst.geo.pose.PnPRefineRodrigues;
import boofcv.abst.geo.pose.WrapP3PLineDistance;
import boofcv.abst.geo.pose.WrapPRnPDirectLinearTransform;
import boofcv.abst.geo.pose.WrapPnPLepetitEPnP;
import boofcv.abst.geo.selfcalib.GenerateMetricTripleFromProjective;
import boofcv.abst.geo.selfcalib.ProjectiveToMetricCameraDualQuadratic;
import boofcv.abst.geo.selfcalib.ProjectiveToMetricCameraEssentialGuessAndCheck;
import boofcv.abst.geo.selfcalib.ProjectiveToMetricCameraPracticalGuessAndCheck;
import boofcv.abst.geo.selfcalib.ProjectiveToMetricCameras;
import boofcv.abst.geo.triangulate.TriangulateRefineEpipolarLS;
import boofcv.abst.geo.triangulate.TriangulateRefineMetricHgLS;
import boofcv.abst.geo.triangulate.TriangulateRefineMetricLS;
import boofcv.abst.geo.triangulate.TriangulateRefineProjectiveLS;
import boofcv.abst.geo.triangulate.TriangulateThenRefineMetric;
import boofcv.abst.geo.triangulate.TriangulateThenRefineMetricH;
import boofcv.abst.geo.triangulate.TriangulateThenRefineProjective;
import boofcv.abst.geo.triangulate.Wrap2ViewPixelDepthLinear;
import boofcv.abst.geo.triangulate.Wrap2ViewsTriangulateGeometric;
import boofcv.abst.geo.triangulate.Wrap2ViewsTriangulateGeometricH;
import boofcv.abst.geo.triangulate.Wrap2ViewsTriangulateMetricDLTH;
import boofcv.abst.geo.triangulate.Wrap2ViewsTriangulateProjectiveDLT;
import boofcv.abst.geo.triangulate.WrapNViewsTriangulateMetricDLT;
import boofcv.abst.geo.triangulate.WrapNViewsTriangulateMetricHgDLT;
import boofcv.abst.geo.triangulate.WrapNViewsTriangulateProjectiveDLT;
import boofcv.abst.geo.trifocal.WrapRefineThreeViewProjectiveGeometric;
import boofcv.abst.geo.trifocal.WrapTrifocalAlgebraicPoint7;
import boofcv.abst.geo.trifocal.WrapTrifocalLinearPoint7;
import boofcv.alg.geo.ModelObservationResidualN;
import boofcv.alg.geo.bundle.BundleAdjustmentMetricResidualFunction;
import boofcv.alg.geo.bundle.BundleAdjustmentMetricSchurJacobian_DDRM;
import boofcv.alg.geo.bundle.BundleAdjustmentMetricSchurJacobian_DSCC;
import boofcv.alg.geo.bundle.BundleAdjustmentProjectiveResidualFunction;
import boofcv.alg.geo.bundle.BundleAdjustmentProjectiveSchurJacobian_DDRM;
import boofcv.alg.geo.bundle.BundleAdjustmentProjectiveSchurJacobian_DSCC;
import boofcv.alg.geo.bundle.CodecSceneStructureMetric;
import boofcv.alg.geo.bundle.CodecSceneStructureProjective;
import boofcv.alg.geo.f.DistanceEpipolarConstraint;
import boofcv.alg.geo.h.HomographyDirectLinearTransform;
import boofcv.alg.geo.h.HomographyRadial6Pts;
import boofcv.alg.geo.h.HomographyResidualSampson;
import boofcv.alg.geo.h.HomographyResidualTransfer;
import boofcv.alg.geo.h.HomographyTotalLeastSquares;
import boofcv.alg.geo.pose.P3PFinsterwalder;
import boofcv.alg.geo.pose.P3PGrunert;
import boofcv.alg.geo.pose.PRnPDirectLinearTransform;
import boofcv.alg.geo.pose.PnPLepetitEPnP;
import boofcv.alg.geo.pose.PoseFromPairLinear6;
import boofcv.alg.geo.robust.ModelGeneratorViews;
import boofcv.alg.geo.selfcalib.MetricCameraTriple;
import boofcv.alg.geo.selfcalib.RefineDualQuadraticAlgebraicError;
import boofcv.alg.geo.selfcalib.SelfCalibrationEssentialGuessAndCheck;
import boofcv.alg.geo.selfcalib.SelfCalibrationLinearDualQuadratic;
import boofcv.alg.geo.selfcalib.SelfCalibrationPraticalGuessAndCheckFocus;
import boofcv.alg.geo.trifocal.RefineThreeViewProjectiveGeometric;
import boofcv.alg.geo.trifocal.TrifocalAlgebraicPoint7;
import boofcv.factory.geo.ConfigBundleAdjustment;
import boofcv.factory.geo.ConfigPixelsToMetric;
import boofcv.factory.geo.ConfigSelfCalibDualQuadratic;
import boofcv.factory.geo.ConfigSelfCalibEssentialGuess;
import boofcv.factory.geo.ConfigSelfCalibPracticalGuess;
import boofcv.factory.geo.ConfigThreeViewRefine;
import boofcv.factory.geo.ConfigTriangulation;
import boofcv.factory.geo.ConfigTrifocal;
import boofcv.factory.geo.EnumEssential;
import boofcv.factory.geo.EnumFundamental;
import boofcv.factory.geo.EnumPNP;
import boofcv.factory.geo.EpipolarError;
import boofcv.misc.ConfigConverge;
import boofcv.struct.calib.ElevateViewInfo;
import boofcv.struct.geo.AssociatedPair;
import boofcv.struct.geo.AssociatedTriple;
import georegression.fitting.MotionTransformPoint;
import georegression.fitting.se.FitSpecialEuclideanOps_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.FactoryOptimizationSparse;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.UnconstrainedLeastSquaresSchur;
import org.ddogleg.optimization.lm.ConfigLevenbergMarquardt;
import org.ddogleg.optimization.trustregion.ConfigTrustRegion;
import org.ddogleg.solver.PolynomialOps;
import org.ddogleg.solver.RootFinderType;
import org.ddogleg.struct.DogArray;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.DMatrixSparseCSC;
import org.jetbrains.annotations.Nullable;

public class FactoryMultiView {
    public static BundleAdjustment<SceneStructureMetric> bundleSparseMetric(@Nullable ConfigBundleAdjustment config) {
        if (config == null) {
            config = new ConfigBundleAdjustment();
        }
        UnconstrainedLeastSquaresSchur<DMatrixSparseCSC> minimizer = config.configOptimizer instanceof ConfigTrustRegion ? FactoryOptimizationSparse.doglegSchur((ConfigTrustRegion)config.configOptimizer) : FactoryOptimizationSparse.levenbergMarquardtSchur((ConfigLevenbergMarquardt)config.configOptimizer);
        return new BundleAdjustmentSchur_DSCC<SceneStructureMetric>(minimizer, (BundleAdjustmentSchur.FunctionResiduals<SceneStructureMetric>)new BundleAdjustmentMetricResidualFunction(), new BundleAdjustmentMetricSchurJacobian_DSCC(), (BundleAdjustmentSchur.Codec<SceneStructureMetric>)new CodecSceneStructureMetric());
    }

    public static BundleAdjustment<SceneStructureProjective> bundleSparseProjective(@Nullable ConfigBundleAdjustment config) {
        if (config == null) {
            config = new ConfigBundleAdjustment();
        }
        UnconstrainedLeastSquaresSchur<DMatrixSparseCSC> minimizer = config.configOptimizer instanceof ConfigTrustRegion ? FactoryOptimizationSparse.doglegSchur((ConfigTrustRegion)config.configOptimizer) : FactoryOptimizationSparse.levenbergMarquardtSchur((ConfigLevenbergMarquardt)config.configOptimizer);
        return new BundleAdjustmentSchur_DSCC<SceneStructureProjective>(minimizer, (BundleAdjustmentSchur.FunctionResiduals<SceneStructureProjective>)new BundleAdjustmentProjectiveResidualFunction(), new BundleAdjustmentProjectiveSchurJacobian_DSCC(), (BundleAdjustmentSchur.Codec<SceneStructureProjective>)new CodecSceneStructureProjective());
    }

    public static BundleAdjustment<SceneStructureMetric> bundleDenseMetric(boolean robust, @Nullable ConfigBundleAdjustment config) {
        if (config == null) {
            config = new ConfigBundleAdjustment();
        }
        UnconstrainedLeastSquaresSchur<DMatrixRMaj> minimizer = config.configOptimizer instanceof ConfigTrustRegion ? FactoryOptimization.doglegSchur(robust, (ConfigTrustRegion)config.configOptimizer) : FactoryOptimization.levenbergMarquardtSchur(robust, (ConfigLevenbergMarquardt)config.configOptimizer);
        return new BundleAdjustmentSchur_DDRM<SceneStructureMetric>(minimizer, (BundleAdjustmentSchur.FunctionResiduals<SceneStructureMetric>)new BundleAdjustmentMetricResidualFunction(), new BundleAdjustmentMetricSchurJacobian_DDRM(), (BundleAdjustmentSchur.Codec<SceneStructureMetric>)new CodecSceneStructureMetric());
    }

    public static BundleAdjustment<SceneStructureProjective> bundleDenseProjective(boolean robust, @Nullable ConfigBundleAdjustment config) {
        if (config == null) {
            config = new ConfigBundleAdjustment();
        }
        UnconstrainedLeastSquaresSchur<DMatrixRMaj> minimizer = config.configOptimizer instanceof ConfigTrustRegion ? FactoryOptimization.doglegSchur(robust, (ConfigTrustRegion)config.configOptimizer) : FactoryOptimization.levenbergMarquardtSchur(robust, (ConfigLevenbergMarquardt)config.configOptimizer);
        return new BundleAdjustmentSchur_DDRM<SceneStructureProjective>(minimizer, (BundleAdjustmentSchur.FunctionResiduals<SceneStructureProjective>)new BundleAdjustmentProjectiveResidualFunction(), new BundleAdjustmentProjectiveSchurJacobian_DDRM(), (BundleAdjustmentSchur.Codec<SceneStructureProjective>)new CodecSceneStructureProjective());
    }

    public static HomographyDLT_to_Epipolar homographyDLT(boolean normalizeInput) {
        return new HomographyDLT_to_Epipolar(new HomographyDirectLinearTransform(normalizeInput));
    }

    public static HomographyTLS_to_Epipolar homographyTLS() {
        return new HomographyTLS_to_Epipolar(new HomographyTotalLeastSquares());
    }

    public static HomographyRadial6Pts homographyWithRadial() {
        return new HomographyRadial6Pts();
    }

    public static LeastSquaresHomography homographyRefine(double tol, int maxIterations, EpipolarError type) {
        ModelObservationResidualN<DMatrixRMaj, AssociatedPair> modelObservationResidualN;
        switch (type) {
            case SIMPLE: {
                modelObservationResidualN = new HomographyResidualTransfer();
                break;
            }
            case SAMPSON: {
                modelObservationResidualN = new HomographyResidualSampson();
                break;
            }
            default: {
                throw new IllegalArgumentException("Type not supported: " + type);
            }
        }
        ModelObservationResidualN<DMatrixRMaj, AssociatedPair> residuals = modelObservationResidualN;
        return new LeastSquaresHomography(tol, maxIterations, residuals);
    }

    public static EstimateNofEpipolar fundamental_N(EnumFundamental which) {
        EstimateNofEpipolar estimateNofEpipolar;
        switch (which) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LINEAR_8: {
                estimateNofEpipolar = new Estimate1toNofEpipolar(new WrapFundamentalLinear8(true));
                break;
            }
            case LINEAR_7: {
                estimateNofEpipolar = new WrapFundamentalLinear7(true);
            }
        }
        return estimateNofEpipolar;
    }

    public static EstimateNofEpipolar essential_N(EnumEssential which) {
        EstimateNofEpipolar estimateNofEpipolar;
        switch (which) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LINEAR_8: {
                estimateNofEpipolar = new Estimate1toNofEpipolar(new WrapFundamentalLinear8(false));
                break;
            }
            case LINEAR_7: {
                estimateNofEpipolar = new WrapFundamentalLinear7(false);
                break;
            }
            case NISTER_5: {
                estimateNofEpipolar = new WrapEssentialNister5();
            }
        }
        return estimateNofEpipolar;
    }

    public static Estimate1ofEpipolar fundamental_1(EnumFundamental which, int numRemoveAmbiguity) {
        if (which == EnumFundamental.LINEAR_8) {
            return new WrapFundamentalLinear8(true);
        }
        if (numRemoveAmbiguity <= 0) {
            throw new IllegalArgumentException("numRemoveAmbiguity must be greater than zero");
        }
        EstimateNofEpipolar alg = FactoryMultiView.fundamental_N(which);
        DistanceEpipolarConstraint distance = new DistanceEpipolarConstraint();
        return new EstimateNto1ofEpipolar(alg, distance, numRemoveAmbiguity);
    }

    public static Estimate1ofEpipolar essential_1(EnumEssential which, int numRemoveAmbiguity) {
        if (which == EnumEssential.LINEAR_8) {
            return new WrapFundamentalLinear8(false);
        }
        if (numRemoveAmbiguity <= 0) {
            throw new IllegalArgumentException("numRemoveAmbiguity must be greater than zero");
        }
        EstimateNofEpipolar alg = FactoryMultiView.essential_N(which);
        DistanceEpipolarConstraint distance = new DistanceEpipolarConstraint();
        return new EstimateNto1ofEpipolar(alg, distance, numRemoveAmbiguity);
    }

    public static RefineEpipolar fundamentalRefine(double tol, int maxIterations, EpipolarError type) {
        LeastSquaresFundamental leastSquaresFundamental;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case SAMPSON: {
                leastSquaresFundamental = new LeastSquaresFundamental(tol, maxIterations, true);
                break;
            }
            case SIMPLE: {
                leastSquaresFundamental = new LeastSquaresFundamental(tol, maxIterations, false);
            }
        }
        return leastSquaresFundamental;
    }

    public static Estimate1ofTrifocalTensor trifocal_1(@Nullable ConfigTrifocal config) {
        Estimate1ofTrifocalTensor estimate1ofTrifocalTensor;
        if (config == null) {
            config = new ConfigTrifocal();
        }
        switch (config.which) {
            case LINEAR_7: {
                estimate1ofTrifocalTensor = new WrapTrifocalLinearPoint7();
                break;
            }
            case ALGEBRAIC_7: {
                ConfigConverge cc = config.converge;
                UnconstrainedLeastSquares<DMatrixRMaj> optimizer = FactoryOptimization.levenbergMarquardt(null, false);
                TrifocalAlgebraicPoint7 alg = new TrifocalAlgebraicPoint7(optimizer, cc.maxIterations, cc.ftol, cc.gtol);
                estimate1ofTrifocalTensor = new WrapTrifocalAlgebraicPoint7(alg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + config.which);
            }
        }
        return estimate1ofTrifocalTensor;
    }

    public static RefineThreeViewProjective threeViewRefine(@Nullable ConfigThreeViewRefine config) {
        if (config == null) {
            config = new ConfigThreeViewRefine();
        }
        if (config.which == ConfigThreeViewRefine.Algorithm.GEOMETRIC) {
            RefineThreeViewProjectiveGeometric alg = new RefineThreeViewProjectiveGeometric();
            alg.getConverge().setTo(config.converge);
            alg.setScale(config.normalizePixels);
            return new WrapRefineThreeViewProjectiveGeometric(alg);
        }
        throw new IllegalArgumentException("Unknown algorithm " + config.which);
    }

    public static EstimateNofPnP pnp_N(EnumPNP which, int numIterations) {
        EstimateNofPnP estimateNofPnP;
        MotionTransformPoint<Se3_F64, Point3D_F64> motionFit = FitSpecialEuclideanOps_F64.fitPoints3D();
        switch (which) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case P3P_GRUNERT: {
                P3PGrunert grunert = new P3PGrunert(PolynomialOps.createRootFinder(5, RootFinderType.STURM));
                estimateNofPnP = new WrapP3PLineDistance(grunert, motionFit);
                break;
            }
            case P3P_FINSTERWALDER: {
                P3PFinsterwalder finster = new P3PFinsterwalder(PolynomialOps.createRootFinder(4, RootFinderType.STURM));
                estimateNofPnP = new WrapP3PLineDistance(finster, motionFit);
                break;
            }
            case EPNP: {
                estimateNofPnP = new Estimate1toNofPnP(FactoryMultiView.pnp_1(which, numIterations, 0));
                break;
            }
            case IPPE: {
                estimateNofPnP = new Estimate1toNofPnP(new IPPE_to_EstimatePnP(FactoryMultiView.homographyTLS()));
            }
        }
        return estimateNofPnP;
    }

    public static Estimate1ofPnP pnp_1(EnumPNP which, int numIterations, int numTest) {
        if (which == EnumPNP.EPNP) {
            PnPLepetitEPnP alg = new PnPLepetitEPnP(0.1);
            alg.setNumIterations(numIterations);
            return new WrapPnPLepetitEPnP(alg);
        }
        if (which == EnumPNP.IPPE) {
            HomographyTLS_to_Epipolar H = FactoryMultiView.homographyTLS();
            return new IPPE_to_EstimatePnP(H);
        }
        DogArray<Se3_F64> solutions = new DogArray<Se3_F64>(4, Se3_F64::new);
        return new EstimateNto1ofPnP(FactoryMultiView.pnp_N(which, -1), solutions, numTest);
    }

    public static Estimate1ofPrNP prnp_1() {
        return new WrapPRnPDirectLinearTransform(new PRnPDirectLinearTransform());
    }

    public static Estimate1ofPnP computePnPwithEPnP(int numIterations, double magicNumber) {
        PnPLepetitEPnP alg = new PnPLepetitEPnP(magicNumber);
        alg.setNumIterations(numIterations);
        return new WrapPnPLepetitEPnP(alg);
    }

    public static RefinePnP pnpRefine(double tol, int maxIterations) {
        return new PnPRefineRodrigues(tol, maxIterations);
    }

    public static PoseFromPairLinear6 poseFromPair() {
        return new PoseFromPairLinear6();
    }

    public static Triangulate2ViewsMetric triangulate2ViewMetric(@Nullable ConfigTriangulation config) {
        Triangulate2ViewsMetric triangulate2ViewsMetric;
        if (config == null) {
            config = new ConfigTriangulation();
        }
        switch (config.type) {
            case DLT: {
                triangulate2ViewsMetric = new Wrap2ViewPixelDepthLinear();
                break;
            }
            case GEOMETRIC: {
                triangulate2ViewsMetric = new Wrap2ViewsTriangulateGeometric();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown or unsupported type " + config.type);
            }
        }
        return triangulate2ViewsMetric;
    }

    public static Triangulate2ViewsMetricH triangulate2ViewMetricH(@Nullable ConfigTriangulation config) {
        Triangulate2ViewsMetricH triangulate2ViewsMetricH;
        if (config == null) {
            config = new ConfigTriangulation();
        }
        switch (config.type) {
            case DLT: {
                triangulate2ViewsMetricH = new Wrap2ViewsTriangulateMetricDLTH();
                break;
            }
            case GEOMETRIC: {
                triangulate2ViewsMetricH = new Wrap2ViewsTriangulateGeometricH();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown or unsupported type " + config.type);
            }
        }
        return triangulate2ViewsMetricH;
    }

    public static Triangulate2ViewsProjective triangulate2ViewProjective(@Nullable ConfigTriangulation config) {
        if (config == null) {
            config = new ConfigTriangulation();
        }
        if (config.type == ConfigTriangulation.Type.DLT) {
            return new Wrap2ViewsTriangulateProjectiveDLT();
        }
        throw new IllegalArgumentException("Unknown or unsupported type " + config.type);
    }

    public static TriangulateNViewsMetric triangulateNViewMetric(@Nullable ConfigTriangulation config) {
        TriangulateNViewsMetric triangulateNViewsMetric;
        if (config == null) {
            config = new ConfigTriangulation();
        }
        switch (config.type) {
            case DLT: {
                triangulateNViewsMetric = new WrapNViewsTriangulateMetricDLT();
                break;
            }
            case GEOMETRIC: {
                WrapNViewsTriangulateMetricDLT estimator = new WrapNViewsTriangulateMetricDLT();
                TriangulateRefineMetricLS refiner = new TriangulateRefineMetricLS(config.converge.gtol, config.converge.maxIterations);
                triangulateNViewsMetric = new TriangulateThenRefineMetric(estimator, refiner);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown or unsupported type " + config.type);
            }
        }
        return triangulateNViewsMetric;
    }

    public static TriangulateNViewsMetricH triangulateNViewMetricH(@Nullable ConfigTriangulation config) {
        TriangulateNViewsMetricH triangulateNViewsMetricH;
        if (config == null) {
            config = new ConfigTriangulation();
        }
        switch (config.type) {
            case DLT: {
                triangulateNViewsMetricH = new WrapNViewsTriangulateMetricHgDLT();
                break;
            }
            case GEOMETRIC: {
                WrapNViewsTriangulateMetricHgDLT estimator = new WrapNViewsTriangulateMetricHgDLT();
                TriangulateRefineMetricHgLS refiner = new TriangulateRefineMetricHgLS(config.converge.gtol, config.converge.maxIterations);
                triangulateNViewsMetricH = new TriangulateThenRefineMetricH(estimator, refiner);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown or unsupported type " + config.type);
            }
        }
        return triangulateNViewsMetricH;
    }

    public static TriangulateNViewsProjective triangulateNViewProj(@Nullable ConfigTriangulation config) {
        TriangulateNViewsProjective triangulateNViewsProjective;
        if (config == null) {
            config = new ConfigTriangulation();
        }
        switch (config.type) {
            case DLT: {
                triangulateNViewsProjective = new WrapNViewsTriangulateProjectiveDLT();
                break;
            }
            case GEOMETRIC: 
            case ALGEBRAIC: {
                WrapNViewsTriangulateProjectiveDLT estimator = new WrapNViewsTriangulateProjectiveDLT();
                TriangulateRefineProjectiveLS refiner = new TriangulateRefineProjectiveLS(config.converge.gtol, config.converge.maxIterations);
                triangulateNViewsProjective = new TriangulateThenRefineProjective(estimator, refiner);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown or unsupported type " + config.type);
            }
        }
        return triangulateNViewsProjective;
    }

    public static RefineTriangulateEpipolar triangulateRefineEpipolar(ConfigConverge config) {
        return new TriangulateRefineEpipolarLS(config.gtol, config.maxIterations);
    }

    public static RefineTriangulateMetric triangulateRefineMetric(ConfigConverge config) {
        return new TriangulateRefineMetricLS(config.gtol, config.maxIterations);
    }

    public static RefineTriangulateMetricH triangulateRefineMetricH(ConfigConverge config) {
        return new TriangulateRefineMetricHgLS(config.gtol, config.maxIterations);
    }

    public static RefineTriangulateProjective triangulateRefineProj(ConfigConverge config) {
        return new TriangulateRefineProjectiveLS(config.gtol, config.maxIterations);
    }

    public static ModelGeneratorViews<MetricCameraTriple, AssociatedTriple, ElevateViewInfo> selfCalibThree(@Nullable ConfigPixelsToMetric config) {
        ProjectiveToMetricCameras projectiveToMetricCameras;
        if (config == null) {
            config = new ConfigPixelsToMetric();
        }
        config.checkValidity();
        Estimate1ofTrifocalTensor trifocal = FactoryMultiView.trifocal_1(config.trifocal);
        switch (config.type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DUAL_QUADRATIC: {
                projectiveToMetricCameras = FactoryMultiView.projectiveToMetric(config.dualQuadratic);
                break;
            }
            case ESSENTIAL_GUESS: {
                projectiveToMetricCameras = FactoryMultiView.projectiveToMetric(config.essentialGuess);
                break;
            }
            case PRACTICAL_GUESS: {
                projectiveToMetricCameras = FactoryMultiView.projectiveToMetric(config.practicalGuess);
            }
        }
        ProjectiveToMetricCameras selfcalib = projectiveToMetricCameras;
        return new GenerateMetricTripleFromProjective(trifocal, selfcalib);
    }

    public static ProjectiveToMetricCameras projectiveToMetric(@Nullable ConfigSelfCalibDualQuadratic config) {
        if (config == null) {
            config = new ConfigSelfCalibDualQuadratic();
        }
        config.checkValidity();
        ConfigSelfCalibDualQuadratic c = config;
        SelfCalibrationLinearDualQuadratic selfCalib = c.knownAspectRatio ? new SelfCalibrationLinearDualQuadratic(c.aspectRatio) : new SelfCalibrationLinearDualQuadratic(c.zeroSkew);
        ProjectiveToMetricCameraDualQuadratic ret = new ProjectiveToMetricCameraDualQuadratic(selfCalib);
        ret.invalidFractionAccept = c.invalidFractionAccept;
        ret.getRefiner().converge.setTo(c.refineAlgebraic);
        return ret;
    }

    public static ProjectiveToMetricCameras projectiveToMetric(@Nullable ConfigSelfCalibEssentialGuess config) {
        if (config == null) {
            config = new ConfigSelfCalibEssentialGuess();
        }
        config.checkValidity();
        ConfigSelfCalibEssentialGuess c = config;
        SelfCalibrationEssentialGuessAndCheck selfCalib = new SelfCalibrationEssentialGuessAndCheck();
        selfCalib.fixedFocus = c.fixedFocus;
        selfCalib.numberOfSamples = c.numberOfSamples;
        selfCalib.sampleFocalRatioMin = c.sampleMin;
        selfCalib.sampleFocalRatioMax = c.sampleMax;
        return new ProjectiveToMetricCameraEssentialGuessAndCheck(selfCalib);
    }

    public static ProjectiveToMetricCameras projectiveToMetric(@Nullable ConfigSelfCalibPracticalGuess config) {
        if (config == null) {
            config = new ConfigSelfCalibPracticalGuess();
        }
        config.checkValidity();
        ConfigSelfCalibPracticalGuess c = config;
        SelfCalibrationPraticalGuessAndCheckFocus selfCalib = new SelfCalibrationPraticalGuessAndCheckFocus();
        selfCalib.setSampling(c.sampleMin, c.sampleMax, c.numberOfSamples);
        selfCalib.setSingleCamera(c.fixedFocus);
        return new ProjectiveToMetricCameraPracticalGuessAndCheck(selfCalib);
    }

    public static RefineDualQuadraticAlgebraicError refineDualAbsoluteQuadratic(ConfigConverge config) {
        RefineDualQuadraticAlgebraicError alg = new RefineDualQuadraticAlgebraicError();
        alg.getConverge().setTo(config);
        return alg;
    }
}

