/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.disparity;

import boofcv.factory.disparity.BlockMatchingApproach;
import boofcv.factory.disparity.ConfigDisparityError;
import boofcv.factory.disparity.DisparitySgmError;
import boofcv.struct.Configuration;
import boofcv.struct.KernelRadius2D;
import boofcv.struct.border.BorderType;

public class ConfigDisparitySGM
implements Configuration {
    public int disparityMin = 0;
    public int disparityRange = 100;
    public int maxError = -1;
    public int validateRtoL = 1;
    public double texture = 0.15;
    public boolean subpixel = true;
    public int penaltySmallChange = 200;
    public int penaltyLargeChange = 2000;
    public Paths paths = Paths.P8;
    public DisparitySgmError errorType = DisparitySgmError.CENSUS;
    public boolean useBlocks = true;
    public ConfigDisparityError.Census configCensus = new ConfigDisparityError.Census();
    public ConfigDisparityError.HMI configHMI = new ConfigDisparityError.HMI();
    public ConfigBlockMatchError configBlockMatch = new ConfigBlockMatchError();
    public BorderType border = BorderType.REFLECT;

    public KernelRadius2D getBlockSize() {
        if (this.useBlocks) {
            return this.configBlockMatch.getBlockSize();
        }
        return new KernelRadius2D(1, 1);
    }

    public ConfigDisparitySGM setTo(ConfigDisparitySGM src) {
        this.disparityMin = src.disparityMin;
        this.disparityRange = src.disparityRange;
        this.maxError = src.maxError;
        this.validateRtoL = src.validateRtoL;
        this.texture = src.texture;
        this.subpixel = src.subpixel;
        this.penaltySmallChange = src.penaltySmallChange;
        this.penaltyLargeChange = src.penaltyLargeChange;
        this.paths = src.paths;
        this.errorType = src.errorType;
        this.useBlocks = src.useBlocks;
        this.configCensus.setTo(src.configCensus);
        this.configHMI.setTo(src.configHMI);
        this.configBlockMatch.setTo(src.configBlockMatch);
        this.border = src.border;
        return this;
    }

    @Override
    public void checkValidity() {
        if (this.penaltyLargeChange <= this.penaltySmallChange) {
            throw new IllegalArgumentException("large penalty must be larger than small");
        }
        if (this.penaltySmallChange < 0 || this.penaltySmallChange > 2047) {
            throw new IllegalArgumentException("Invalid value for penaltySmallChange.");
        }
        if (this.penaltyLargeChange < 0 || this.penaltyLargeChange > 2047) {
            throw new IllegalArgumentException("Invalid value for penaltySmallChange.");
        }
        if (this.disparityMin < 0) {
            throw new IllegalArgumentException("Minimum disparity must be >= 0");
        }
        this.configBlockMatch.checkValidity();
    }

    public static enum Paths {
        P1(1),
        P2(2),
        P4(4),
        P8(8),
        P16(16);

        private final int count;

        private Paths(int count) {
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class ConfigBlockMatchError
    implements Configuration {
        public int radiusX = 2;
        public int radiusY = 2;
        public BlockMatchingApproach approach = BlockMatchingApproach.BEST5;

        public KernelRadius2D getBlockSize() {
            KernelRadius2D kernelRadius2D;
            switch (this.approach) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case BASIC: {
                    kernelRadius2D = new KernelRadius2D(this.radiusX, this.radiusY);
                    break;
                }
                case BEST5: {
                    int rx = (2 * this.radiusX + 1) * 3 / 2;
                    int ry = (2 * this.radiusY + 1) * 3 / 2;
                    kernelRadius2D = new KernelRadius2D(rx, ry);
                    break;
                }
            }
            return kernelRadius2D;
        }

        public ConfigBlockMatchError setTo(ConfigBlockMatchError src) {
            this.radiusX = src.radiusX;
            this.radiusY = src.radiusY;
            return this;
        }

        @Override
        public void checkValidity() {
            if (this.radiusX <= 0 || this.radiusY <= 0) {
                throw new IllegalArgumentException("Radius must be positive");
            }
        }
    }
}

