/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.disparity;

import boofcv.factory.disparity.ConfigDisparityBM;
import boofcv.factory.disparity.ConfigDisparityBMBest5;
import boofcv.factory.disparity.ConfigDisparitySGM;
import boofcv.struct.Configuration;
import boofcv.struct.KernelRadius2D;

public class ConfigDisparity
implements Configuration {
    public Approach approach = Approach.BLOCK_MATCH;
    public final ConfigDisparityBM approachBM = new ConfigDisparityBM();
    public final ConfigDisparityBMBest5 approachBM5 = new ConfigDisparityBMBest5();
    public final ConfigDisparitySGM approachSGM = new ConfigDisparitySGM();

    public KernelRadius2D getBlockSize() {
        KernelRadius2D kernelRadius2D;
        switch (this.approach) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BLOCK_MATCH: {
                kernelRadius2D = this.approachBM.getBlockSize();
                break;
            }
            case BLOCK_MATCH_5: {
                kernelRadius2D = this.approachBM5.getBlockSize();
                break;
            }
            case SGM: {
                kernelRadius2D = this.approachSGM.getBlockSize();
            }
        }
        return kernelRadius2D;
    }

    @Override
    public void checkValidity() {
        this.approachBM.checkValidity();
        this.approachBM5.checkValidity();
        this.approachSGM.checkValidity();
    }

    public ConfigDisparity setTo(ConfigDisparity src) {
        this.approach = src.approach;
        this.approachBM.setTo(src.approachBM);
        this.approachBM5.setTo(src.approachBM5);
        this.approachSGM.setTo(src.approachSGM);
        return this;
    }

    public boolean isSubpixel() {
        boolean bl;
        switch (this.approach) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case BLOCK_MATCH: {
                bl = this.approachBM.subpixel;
                break;
            }
            case BLOCK_MATCH_5: {
                bl = this.approachBM5.subpixel;
                break;
            }
            case SGM: {
                bl = this.approachSGM.subpixel;
            }
        }
        return bl;
    }

    public static enum Approach {
        BLOCK_MATCH,
        BLOCK_MATCH_5,
        SGM;

    }
}

