/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.transform.pyramid.impl;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;

public class ImplPyramidOps_MT {
    public static void scaleImageUp(GrayF32 input, GrayF32 output, int scale, InterpolatePixelS<GrayF32> interp) {
        output.reshape(input.width * scale, input.height * scale);
        float fdiv = 1.0f / (float)scale;
        interp.setImage(input);
        BoofConcurrency.loopFor(0, output.height, y -> {
            float inputY = (float)y * fdiv;
            int indexOutput = output.getIndex(0, y);
            for (int x = 0; x < output.width; ++x) {
                float inputX = (float)x * fdiv;
                output.data[indexOutput++] = interp.get(inputX, inputY);
            }
        });
    }

    public static void scaleDown2(GrayF32 input, GrayF32 output) {
        output.reshape(input.width / 2, input.height / 2);
        BoofConcurrency.loopFor(0, output.height, y -> {
            int indexInput = 2 * y * input.stride;
            int indexOutput = y * output.stride;
            int x = 0;
            while (x < output.width) {
                output.data[indexOutput++] = input.data[indexInput];
                ++x;
                indexInput += 2;
            }
        });
    }

    public static void scaleImageUp(GrayU8 input, GrayU8 output, int scale, InterpolatePixelS<GrayU8> interp) {
        output.reshape(input.width * scale, input.height * scale);
        float fdiv = 1.0f / (float)scale;
        interp.setImage(input);
        BoofConcurrency.loopFor(0, output.height, y -> {
            float inputY = (float)y * fdiv;
            int indexOutput = output.getIndex(0, y);
            for (int x = 0; x < output.width; ++x) {
                float inputX = (float)x * fdiv;
                output.data[indexOutput++] = (byte)interp.get(inputX, inputY);
            }
        });
    }

    public static void scaleDown2(GrayU8 input, GrayU8 output) {
        output.reshape(input.width / 2, input.height / 2);
        BoofConcurrency.loopFor(0, output.height, y -> {
            int indexInput = 2 * y * input.stride;
            int indexOutput = y * output.stride;
            int x = 0;
            while (x < output.width) {
                output.data[indexOutput++] = input.data[indexInput];
                ++x;
                indexInput += 2;
            }
        });
    }
}

