/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.alg.tracker.tld.ConfigTld;
import boofcv.alg.tracker.tld.TldDetection;
import boofcv.alg.tracker.tld.TldFernClassifier;
import boofcv.alg.tracker.tld.TldHelperFunctions;
import boofcv.alg.tracker.tld.TldRegion;
import boofcv.alg.tracker.tld.TldRegionFernInfo;
import boofcv.alg.tracker.tld.TldTemplateMatching;
import boofcv.alg.tracker.tld.TldVarianceFilter;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.ImageGray;
import georegression.struct.shapes.Rectangle2D_F64;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;

public class TldLearning<T extends ImageGray<T>> {
    private Random rand;
    private TldFernClassifier<T> fern;
    private TldTemplateMatching<T> template;
    private TldVarianceFilter<T> variance;
    private TldDetection<T> detection;
    private DogArray_F64 storageMetric = new DogArray_F64();
    private List<ImageRectangle> fernNegative = new ArrayList<ImageRectangle>();
    private ImageRectangle targetRegion_I32 = new ImageRectangle();
    private TldHelperFunctions helper = new TldHelperFunctions();
    private ConfigTld config;

    public TldLearning(Random rand, ConfigTld config, TldTemplateMatching<T> template, TldVarianceFilter<T> variance, TldFernClassifier<T> fern, TldDetection<T> detection) {
        this.rand = rand;
        this.config = config;
        this.template = template;
        this.variance = variance;
        this.fern = fern;
        this.detection = detection;
    }

    public void initialLearning(Rectangle2D_F64 targetRegion, DogArray<ImageRectangle> cascadeRegions) {
        this.storageMetric.reset();
        this.fernNegative.clear();
        TldHelperFunctions.convertRegion(targetRegion, this.targetRegion_I32);
        this.variance.selectThreshold(this.targetRegion_I32);
        this.template.addDescriptor(true, this.targetRegion_I32);
        this.fern.learnFernNoise(true, this.targetRegion_I32);
        for (int i = 0; i < cascadeRegions.size; ++i) {
            double overlap;
            ImageRectangle r = (ImageRectangle)cascadeRegions.get(i);
            if (!this.variance.checkVariance(r) || (overlap = this.helper.computeOverlap(this.targetRegion_I32, r)) > this.config.overlapLower) continue;
            this.fernNegative.add(r);
        }
        int N = this.fernNegative.size();
        for (int i = 0; i < N; ++i) {
            this.fern.learnFern(false, this.fernNegative.get(i));
        }
        this.detection.detectionCascade(cascadeRegions);
        this.learnAmbiguousNegative(targetRegion);
    }

    public void updateLearning(Rectangle2D_F64 targetRegion) {
        this.storageMetric.reset();
        TldHelperFunctions.convertRegion(targetRegion, this.targetRegion_I32);
        this.template.addDescriptor(true, this.targetRegion_I32);
        this.fern.learnFernNoise(true, this.targetRegion_I32);
        DogArray<TldRegionFernInfo> ferns = this.detection.getFernInfo();
        int N = Math.min(this.config.numNegativeFerns, ferns.size);
        for (int i = 0; i < N; ++i) {
            int index = this.rand.nextInt(ferns.size);
            TldRegionFernInfo f = (TldRegionFernInfo)ferns.get(index);
            double overlap = this.helper.computeOverlap(this.targetRegion_I32, f.r);
            if (overlap > this.config.overlapLower) continue;
            this.fern.learnFern(false, f.r);
        }
        this.learnAmbiguousNegative(targetRegion);
    }

    protected void learnAmbiguousNegative(Rectangle2D_F64 targetRegion) {
        TldHelperFunctions.convertRegion(targetRegion, this.targetRegion_I32);
        if (this.detection.isSuccess()) {
            TldRegion best = Objects.requireNonNull(this.detection.getBest());
            double overlap = this.helper.computeOverlap(best.rect, this.targetRegion_I32);
            if (overlap <= this.config.overlapLower) {
                this.template.addDescriptor(false, best.rect);
            }
            List<ImageRectangle> ambiguous = this.detection.getAmbiguousRegions();
            for (int ambiguousIdx = 0; ambiguousIdx < ambiguous.size(); ++ambiguousIdx) {
                ImageRectangle r = ambiguous.get(ambiguousIdx);
                overlap = this.helper.computeOverlap(r, this.targetRegion_I32);
                if (!(overlap <= this.config.overlapLower)) continue;
                this.fern.learnFernNoise(false, r);
                this.template.addDescriptor(false, r);
            }
        }
    }
}

