/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.alg.tracker.tld.ConfigTld;
import boofcv.alg.tracker.tld.TldFernClassifier;
import boofcv.alg.tracker.tld.TldHelperFunctions;
import boofcv.alg.tracker.tld.TldNonMaximalSuppression;
import boofcv.alg.tracker.tld.TldRegion;
import boofcv.alg.tracker.tld.TldRegionFernInfo;
import boofcv.alg.tracker.tld.TldTemplateMatching;
import boofcv.alg.tracker.tld.TldVarianceFilter;
import boofcv.struct.ImageRectangle;
import boofcv.struct.image.ImageGray;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.sorting.QuickSelect;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.DogArray_F64;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class TldDetection<T extends ImageGray<T>> {
    private TldFernClassifier<T> fern;
    protected TldTemplateMatching<T> template;
    private TldVarianceFilter<T> variance;
    protected DogArray<TldRegionFernInfo> fernInfo = new DogArray<TldRegionFernInfo>(TldRegionFernInfo::new);
    protected ConfigTld config;
    private final DogArray_F64 storageMetric = new DogArray_F64();
    private final DogArray_I32 storageIndexes = new DogArray_I32();
    private final List<ImageRectangle> storageRect = new ArrayList<ImageRectangle>();
    protected List<ImageRectangle> fernRegions = new ArrayList<ImageRectangle>();
    protected DogArray<TldRegion> candidateDetections = new DogArray<TldRegion>(TldRegion::new);
    private final DogArray<TldRegion> localMaximums = new DogArray<TldRegion>(TldRegion::new);
    private final List<ImageRectangle> ambiguousRegions = new ArrayList<ImageRectangle>();
    private final TldHelperFunctions helper = new TldHelperFunctions();
    @Nullable
    private TldRegion best;
    protected boolean ambiguous;
    private boolean success;
    private TldNonMaximalSuppression nonmax;

    public TldDetection(TldFernClassifier<T> fern, TldTemplateMatching<T> template, TldVarianceFilter<T> variance, ConfigTld config) {
        this.fern = fern;
        this.template = template;
        this.variance = variance;
        this.config = config;
        this.nonmax = new TldNonMaximalSuppression(config.regionConnect);
    }

    protected TldDetection() {
    }

    protected void detectionCascade(DogArray<ImageRectangle> cascadeRegions) {
        this.success = false;
        this.ambiguous = false;
        this.best = null;
        this.candidateDetections.reset();
        this.localMaximums.reset();
        this.ambiguousRegions.clear();
        this.storageMetric.reset();
        this.storageIndexes.reset();
        this.storageRect.clear();
        this.fernRegions.clear();
        this.fernInfo.reset();
        int totalP = 0;
        int totalN = 0;
        TldRegionFernInfo info = this.fernInfo.grow();
        for (int i = 0; i < cascadeRegions.size; ++i) {
            ImageRectangle region = (ImageRectangle)cascadeRegions.get(i);
            if (!this.variance.checkVariance(region)) continue;
            info.r = region;
            if (!this.fern.lookupFernPN(info)) continue;
            totalP += info.sumP;
            totalN += info.sumN;
            info = this.fernInfo.grow();
        }
        this.fernInfo.removeTail();
        if (totalP > 0xFFFFFFF) {
            this.fern.renormalizeP();
        }
        if (totalN > 0xFFFFFFF) {
            this.fern.renormalizeN();
        }
        this.selectBestRegionsFern(totalP, totalN);
        this.computeTemplateConfidence();
        if (this.candidateDetections.size == 0) {
            return;
        }
        this.nonmax.process(this.candidateDetections, this.localMaximums);
        this.best = this.selectBest();
        if (this.best != null) {
            this.ambiguous = this.checkAmbiguous(this.best);
            this.success = true;
        }
    }

    protected void computeTemplateConfidence() {
        double max = 0.0;
        for (int i = 0; i < this.fernRegions.size(); ++i) {
            ImageRectangle region = this.fernRegions.get(i);
            double confidence = this.template.computeConfidence(region);
            max = Math.max(max, confidence);
            if (confidence < this.config.confidenceThresholdUpper) continue;
            TldRegion r = this.candidateDetections.grow();
            r.connections = 0;
            r.rect.setTo(region);
            r.confidence = confidence;
        }
    }

    protected void selectBestRegionsFern(double totalP, double totalN) {
        for (int i = 0; i < this.fernInfo.size; ++i) {
            TldRegionFernInfo info = (TldRegionFernInfo)this.fernInfo.get(i);
            double probP = (double)info.sumP / totalP;
            double probN = (double)info.sumN / totalN;
            if (!(probP > probN)) continue;
            this.storageMetric.add(-(probP - probN));
            this.storageRect.add(info.r);
        }
        if (this.config.maximumCascadeConsider < this.storageMetric.size) {
            int N = Math.min(this.config.maximumCascadeConsider, this.storageMetric.size);
            this.storageIndexes.resize(this.storageMetric.size);
            QuickSelect.selectIndex(this.storageMetric.data, N - 1, this.storageMetric.size, this.storageIndexes.data);
            for (int i = 0; i < N; ++i) {
                this.fernRegions.add(this.storageRect.get(this.storageIndexes.get(i)));
            }
        } else {
            this.fernRegions.addAll(this.storageRect);
        }
    }

    @Nullable
    public TldRegion selectBest() {
        TldRegion best = null;
        double bestConfidence = 0.0;
        for (int i = 0; i < this.localMaximums.size; ++i) {
            TldRegion r = (TldRegion)this.localMaximums.get(i);
            if (!(r.confidence > bestConfidence)) continue;
            bestConfidence = r.confidence;
            best = r;
        }
        return best;
    }

    private boolean checkAmbiguous(TldRegion best) {
        double thresh = best.confidence * 0.9;
        for (int i = 0; i < this.localMaximums.size; ++i) {
            double overlap;
            TldRegion r = (TldRegion)this.localMaximums.get(i);
            if (!(r.confidence >= thresh) || !((overlap = this.helper.computeOverlap(r.rect, best.rect)) <= this.config.overlapLower)) continue;
            this.ambiguousRegions.add(r.rect);
        }
        return !this.ambiguousRegions.isEmpty();
    }

    @Nullable
    public TldRegion getBest() {
        return this.best;
    }

    public boolean isAmbiguous() {
        return this.ambiguous;
    }

    public TldNonMaximalSuppression getNonmax() {
        return this.nonmax;
    }

    public DogArray_F64 getStorageMetric() {
        return this.storageMetric;
    }

    public List<ImageRectangle> getStorageRect() {
        return this.storageRect;
    }

    public DogArray<TldRegion> getCandidateDetections() {
        return this.candidateDetections;
    }

    public DogArray<TldRegion> getLocalMaximums() {
        return this.localMaximums;
    }

    public List<ImageRectangle> getAmbiguousRegions() {
        return this.ambiguousRegions;
    }

    public DogArray<TldRegionFernInfo> getFernInfo() {
        return this.fernInfo;
    }

    public List<ImageRectangle> getSelectedFernRectangles() {
        return this.fernRegions;
    }

    public boolean isSuccess() {
        return this.success;
    }
}

