/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.template;

import boofcv.abst.transform.fft.DiscreteFourierTransform;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.misc.PixelMath;
import boofcv.alg.template.TemplateMatchingIntensity;
import boofcv.alg.transform.fft.DiscreteFourierTransformOps;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.InterleavedF32;
import org.jetbrains.annotations.Nullable;

public class TemplateCorrelationFFT
implements TemplateMatchingIntensity<GrayF32> {
    DiscreteFourierTransform<GrayF32, InterleavedF32> dft = DiscreteFourierTransformOps.createTransformF32();
    int borderX0;
    int borderY0;
    int borderX1;
    int borderY1;
    GrayF32 normalizedImage = new GrayF32(1, 1);
    GrayF32 normalizedTemplate = new GrayF32(1, 1);
    GrayF32 enlargedTemplate = new GrayF32(1, 1);
    InterleavedF32 fftImage = new InterleavedF32(1, 1, 2);
    InterleavedF32 fftTemplate = new InterleavedF32(1, 1, 2);
    InterleavedF32 fftMult = new InterleavedF32(1, 1, 2);
    GrayF32 correlation = new GrayF32(1, 1);
    float maxValue;
    float mean;

    @Override
    public void setInputImage(GrayF32 image) {
        this.enlargedTemplate.reshape(image.width, image.height);
        this.fftImage.reshape(image.width, image.height);
        this.fftTemplate.reshape(image.width, image.height);
        this.fftMult.reshape(image.width, image.height);
        this.correlation.reshape(image.width, image.height);
        this.normalizedImage.reshape(image.width, image.height);
        this.maxValue = ImageStatistics.max(image) + 1.0E-4f;
        this.mean = ImageStatistics.mean(image);
        PixelMath.divide(image, this.maxValue, this.normalizedImage);
        PixelMath.minus(this.normalizedImage, this.mean / this.maxValue, this.normalizedImage);
        this.dft.forward(this.normalizedImage, this.fftImage);
    }

    @Override
    public void process(GrayF32 template) {
        this.process(template, (GrayF32)null);
    }

    @Override
    public void process(GrayF32 template, @Nullable GrayF32 mask) {
        int y;
        if (template.width > this.fftImage.width || template.height > this.fftImage.height) {
            throw new IllegalArgumentException("Template must be smaller than or equal to the image");
        }
        this.normalizedTemplate.reshape(template.width, template.height);
        PixelMath.divide(template, this.maxValue, this.normalizedTemplate);
        PixelMath.minus(this.normalizedTemplate, this.mean / this.maxValue, this.normalizedTemplate);
        if (mask != null) {
            for (y = 0; y < mask.height; ++y) {
                for (int x = 0; x < mask.width; ++x) {
                    if (mask.unsafe_get(x, y) != 0.0f) continue;
                    this.normalizedTemplate.unsafe_set(x, y, 0.0f);
                }
            }
        }
        this.borderX0 = template.width / 2;
        this.borderX1 = template.width - this.borderX0;
        this.borderY0 = template.height / 2;
        this.borderY1 = template.height - this.borderY0;
        GImageMiscOps.fill((ImageBase)this.enlargedTemplate, 0.0);
        for (y = 0; y < template.height; ++y) {
            int yy = y - this.borderY0 + (1 - template.height % 2);
            if (yy < 0) {
                yy = this.enlargedTemplate.height + yy;
            }
            for (int x = 0; x < template.width; ++x) {
                int xx = x - this.borderX0 + (1 - template.width % 2);
                if (xx < 0) {
                    xx = this.enlargedTemplate.width + xx;
                }
                this.enlargedTemplate.unsafe_set(xx, yy, this.normalizedTemplate.unsafe_get(x, y));
            }
        }
        this.dft.forward(this.enlargedTemplate, this.fftTemplate);
        DiscreteFourierTransformOps.multiplyComplex(this.fftImage, this.fftTemplate, this.fftMult);
        this.dft.inverse(this.fftMult, this.correlation);
    }

    @Override
    public GrayF32 getIntensity() {
        return this.correlation;
    }

    @Override
    public boolean isBorderProcessed() {
        return false;
    }

    @Override
    public int getBorderX0() {
        return this.borderX0;
    }

    @Override
    public int getBorderX1() {
        return this.borderX1;
    }

    @Override
    public int getBorderY0() {
        return this.borderY0;
    }

    @Override
    public int getBorderY1() {
        return this.borderY1;
    }

    @Override
    public boolean isMaximize() {
        return true;
    }
}

