/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure.score3d;

import boofcv.alg.geo.MultiViewOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.robust.DistanceFundamentalGeometric;
import boofcv.alg.geo.selfcalib.RefineTwoViewPinholeRotation;
import boofcv.alg.structure.EpipolarScore3D;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.geo.AssociatedPair;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.point.Point2D_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.struct.DogArray_I32;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.jetbrains.annotations.Nullable;

public class ScoreFundamentalVsRotation
implements EpipolarScore3D {
    ModelMatcher<DMatrixRMaj, AssociatedPair> robust3D;
    public double ratio3D = 1.5;
    public double maxRatioScore = 10.0;
    public final ConfigLength minimumInliers = ConfigLength.relative(0.1, 30.0);
    public double inlierErrorTol = 1.0;
    public final RefineTwoViewPinholeRotation fitRotation = new RefineTwoViewPinholeRotation();
    DistanceFundamentalGeometric distanceF = new DistanceFundamentalGeometric();
    protected final DogArray_I32 inliersRotationIdx = new DogArray_I32();
    protected final DMatrixRMaj K1 = new DMatrixRMaj(3, 3);
    protected final DMatrixRMaj K2 = new DMatrixRMaj(3, 3);
    protected final DMatrixRMaj R = new DMatrixRMaj(3, 3);
    private final CameraPinhole pinhole1 = new CameraPinhole();
    private final CameraPinhole pinhole2 = new CameraPinhole();
    final Point2D_F64 predictedPixel = new Point2D_F64();
    List<AssociatedPair> inliersRansac = new ArrayList<AssociatedPair>();
    double score;
    boolean is3D;
    @Nullable
    PrintStream verbose;

    public ScoreFundamentalVsRotation(ModelMatcher<DMatrixRMaj, AssociatedPair> robust3D) {
        this.robust3D = robust3D;
        this.fitRotation.converge.maxIterations = 100;
        this.fitRotation.setAssumeUnityAspect(true);
        this.fitRotation.setKnownFocalLength(false);
        this.fitRotation.setZeroSkew(true);
    }

    @Override
    public void process(CameraPinholeBrown cameraA, @Nullable CameraPinholeBrown cameraB, int featuresA, int featuresB, List<AssociatedPair> pairs, DMatrixRMaj fundamental, DogArray_I32 inliersIdx) {
        boolean sameCamera;
        BoofMiscOps.checkTrue(featuresA >= pairs.size());
        BoofMiscOps.checkTrue(featuresB >= pairs.size());
        this.inliersRotationIdx.reset();
        inliersIdx.reset();
        this.is3D = false;
        this.score = 0.0;
        boolean bl = sameCamera = cameraB == null;
        if (cameraB == null) {
            cameraB = cameraA;
        }
        this.pinhole1.setTo(cameraA);
        this.pinhole2.setTo(cameraB);
        if (pairs.size() < this.robust3D.getMinimumSize()) {
            if (this.verbose != null) {
                this.verbose.printf("pairs.size=%d less than robust3D.getMinimumSize()\n", pairs.size());
            }
            return;
        }
        if (!this.fitFundamentalMatrix(pairs, fundamental)) {
            return;
        }
        int fitFundamental = this.countFitFundamental(this.robust3D.getModelParameters(), pairs, inliersIdx);
        int fitRotation = this.fitPureRotation(pairs, sameCamera);
        this.selectBestModel(pairs, inliersIdx, fitFundamental, fitRotation);
    }

    private boolean fitFundamentalMatrix(List<AssociatedPair> pairs, DMatrixRMaj fundamental) {
        int minimumAllowed = this.minimumInliers.computeI(pairs.size());
        if (pairs.size() < minimumAllowed) {
            if (this.verbose != null) {
                this.verbose.printf("REJECTED: pairs.size=%d < minimum.size=%d\n", pairs.size(), minimumAllowed);
            }
            return false;
        }
        if (!this.robust3D.process(pairs)) {
            this.is3D = false;
            this.score = 0.0;
            if (this.verbose != null) {
                this.verbose.println("ransac failed. not 3D");
            }
            return false;
        }
        fundamental.setTo(this.robust3D.getModelParameters());
        int numInliers = this.robust3D.getMatchSet().size();
        this.inliersRansac.clear();
        for (int i = 0; i < numInliers; ++i) {
            this.inliersRansac.add(pairs.get(this.robust3D.getInputIndex(i)));
        }
        return true;
    }

    private int fitPureRotation(List<AssociatedPair> pairs, boolean sameCamera) {
        CommonOps_DDRM.setIdentity(this.R);
        this.fitRotation.setAssumeSameIntrinsics(sameCamera);
        if (!this.fitRotation.refine(this.inliersRansac, this.R, this.pinhole1, this.pinhole2)) {
            return -1;
        }
        boolean badRotation = false;
        badRotation |= this.pinhole1.cx < 0.0 || this.pinhole1.cy < 0.0 || this.pinhole1.cx >= (double)this.pinhole1.width || this.pinhole1.cy >= (double)this.pinhole1.height;
        if (badRotation |= this.pinhole2.cx < 0.0 || this.pinhole2.cy < 0.0 || this.pinhole2.cx >= (double)this.pinhole2.width || this.pinhole2.cy >= (double)this.pinhole2.height) {
            return -2;
        }
        PerspectiveOps.pinholeToMatrix(this.pinhole1, this.K1);
        PerspectiveOps.pinholeToMatrix(this.pinhole2, this.K2);
        DMatrixRMaj H21 = MultiViewOps.homographyFromRotation(this.R, this.K1, this.K2, null);
        return this.countFitRotation(H21, pairs, this.inliersRotationIdx);
    }

    private int countFitFundamental(DMatrixRMaj fundamental, List<AssociatedPair> pairs, DogArray_I32 inliersIdx) {
        this.distanceF.setModel(fundamental);
        double threshold = this.inlierErrorTol * this.inlierErrorTol * 2.0;
        inliersIdx.reset();
        inliersIdx.reserve(pairs.size());
        for (int i = 0; i < pairs.size(); ++i) {
            double doubleDistanceSq = this.distanceF.distance(pairs.get(i));
            if (!(doubleDistanceSq <= threshold)) continue;
            inliersIdx.add(i);
        }
        return inliersIdx.size;
    }

    private int countFitRotation(DMatrixRMaj H21, List<AssociatedPair> pairs, DogArray_I32 inliersIdx) {
        double adjustedTol = this.inlierErrorTol * 2.0;
        double threshold = adjustedTol * adjustedTol;
        inliersIdx.reset();
        inliersIdx.reserve(pairs.size());
        for (int i = 0; i < pairs.size(); ++i) {
            double error;
            AssociatedPair obs = pairs.get(i);
            GeometryMath_F64.mult(H21, obs.p1, this.predictedPixel);
            if (!this.pinhole2.isInside(this.predictedPixel.x, this.predictedPixel.y) || (error = this.predictedPixel.distance2(obs.p2)) >= threshold) continue;
            inliersIdx.add(i);
        }
        return inliersIdx.size;
    }

    private void selectBestModel(List<AssociatedPair> pairs, DogArray_I32 inliersIdx, int fitModelF, int fitRotation) {
        if (this.inliersRotationIdx.size > inliersIdx.size) {
            inliersIdx.setTo(this.inliersRotationIdx);
        }
        int minimumAllowed = this.minimumInliers.computeI(pairs.size());
        if (inliersIdx.size() < minimumAllowed) {
            if (this.verbose != null) {
                this.verbose.printf("REJECTED: Inliers, pairs.size=%d inlier.size=%d < minimum.size=%d\n", pairs.size(), inliersIdx.size(), minimumAllowed);
            }
            this.is3D = false;
            return;
        }
        this.is3D = (double)Math.max(1, fitRotation) * this.ratio3D <= (double)fitModelF;
        double ratio = (double)fitModelF / (double)Math.max(1, fitRotation);
        this.score = Math.min(this.maxRatioScore, ratio) * (double)inliersIdx.size / 200.0;
        if (this.verbose != null) {
            this.verbose.printf("score=%7.2f pairs=%d inliers=%d ratio=%6.2f, fitR=%d fitF=%d 3d=%s\n", this.score, pairs.size(), inliersIdx.size, ratio, fitRotation, fitModelF, this.is3D);
        }
    }

    @Override
    public double getScore() {
        return this.score;
    }

    @Override
    public boolean is3D() {
        return this.is3D;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
        BoofMiscOps.verboseChildren(this.verbose, configuration, this.fitRotation);
    }

    public ModelMatcher<DMatrixRMaj, AssociatedPair> getRobust3D() {
        return this.robust3D;
    }

    public double getRatio3D() {
        return this.ratio3D;
    }

    public void setRatio3D(double ratio3D) {
        this.ratio3D = ratio3D;
    }

    public double getMaxRatioScore() {
        return this.maxRatioScore;
    }

    public void setMaxRatioScore(double maxRatioScore) {
        this.maxRatioScore = maxRatioScore;
    }

    public ConfigLength getMinimumInliers() {
        return this.minimumInliers;
    }

    public double getInlierErrorTol() {
        return this.inlierErrorTol;
    }

    public void setInlierErrorTol(double inlierErrorTol) {
        this.inlierErrorTol = inlierErrorTol;
    }

    public RefineTwoViewPinholeRotation getFitRotation() {
        return this.fitRotation;
    }
}

