/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.structure.expand;

import boofcv.abst.geo.TriangulateNViewsMetricH;
import boofcv.abst.geo.bundle.MetricBundleAdjustmentUtils;
import boofcv.abst.geo.bundle.SceneObservations;
import boofcv.abst.geo.bundle.SceneStructureMetric;
import boofcv.alg.distort.brown.RemoveBrownPtoN_F64;
import boofcv.alg.geo.bundle.cameras.BundlePinholeSimplified;
import boofcv.alg.structure.MetricSanityChecks;
import boofcv.alg.structure.PairwiseGraphUtils;
import boofcv.alg.structure.SceneWorkingGraph;
import boofcv.alg.structure.expand.MetricExpandByOneView;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinholeBrown;
import boofcv.struct.geo.AssociatedTriple;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.DogArray_I32;
import org.jetbrains.annotations.Nullable;

public class EstimateViewUtils {
    public final MetricBundleAdjustmentUtils metricSba = new MetricBundleAdjustmentUtils();
    public final DogArray_I32 usedThreeViewInliers = new DogArray_I32();
    public double local_to_global;
    public final RemoveBrownPtoN_F64 normalize1 = new RemoveBrownPtoN_F64();
    public final RemoveBrownPtoN_F64 normalize2 = new RemoveBrownPtoN_F64();
    public final RemoveBrownPtoN_F64 normalize3 = new RemoveBrownPtoN_F64();
    public final Se3_F64 view1_to_view1 = new Se3_F64();
    public final Se3_F64 view1_to_view2 = new Se3_F64();
    public final Se3_F64 view1_to_target = new Se3_F64();
    public final List<Point2D_F64> pixelNorms = BoofMiscOps.createListFilled(3, Point2D_F64::new);
    public final List<Se3_F64> listMotion = new ArrayList<Se3_F64>();
    public MetricSanityChecks checks = new MetricSanityChecks();
    List<CameraPinholeBrown> listPriorCameras = new ArrayList<CameraPinholeBrown>();
    SceneWorkingGraph.View wview1;
    SceneWorkingGraph.View wview2;
    BundlePinholeSimplified camera1;
    BundlePinholeSimplified camera2;
    BundlePinholeSimplified camera3;

    public EstimateViewUtils() {
        this.listMotion.add(this.view1_to_view1);
        this.listMotion.add(this.view1_to_view2);
        this.listMotion.add(this.view1_to_target);
    }

    public void initialize(boolean knownView3, SceneWorkingGraph workGraph, PairwiseGraphUtils pairwiseUtils) {
        this.wview1 = workGraph.lookupView(pairwiseUtils.seed.id);
        this.wview2 = workGraph.lookupView(pairwiseUtils.viewB.id);
        this.camera1 = workGraph.getViewCamera((SceneWorkingGraph.View)this.wview1).intrinsic;
        this.camera2 = workGraph.getViewCamera((SceneWorkingGraph.View)this.wview2).intrinsic;
        this.normalize1.setK(this.camera1.f, this.camera1.f, 0.0, 0.0, 0.0).setDistortion(this.camera1.k1, this.camera1.k2);
        this.normalize2.setK(this.camera2.f, this.camera2.f, 0.0, 0.0, 0.0).setDistortion(this.camera2.k1, this.camera2.k2);
        if (knownView3) {
            int targetCameraDB = pairwiseUtils.dbCams.viewToCamera(pairwiseUtils.viewC.id);
            this.camera3 = workGraph.cameras.get((int)targetCameraDB).intrinsic;
            this.normalize3.setK(this.camera3.f, this.camera3.f, 0.0, 0.0, 0.0).setDistortion(this.camera3.k1, this.camera3.k2);
        } else {
            this.dereferenceCamera3();
            this.normalize3.reset();
        }
        this.wview1.world_to_view.invert((Se3_F64)null).concat(this.wview2.world_to_view, this.view1_to_view2);
        this.local_to_global = this.view1_to_view2.T.norm();
        BoofMiscOps.checkTrue(this.local_to_global != 0.0, "BUG! Two views are at the same location");
        this.view1_to_view2.T.divide(this.local_to_global);
    }

    private void dereferenceCamera3() {
        this.camera3 = null;
    }

    public void setCamera3(BundlePinholeSimplified camera3) {
        this.camera3 = camera3;
        this.normalize3.setK(camera3.f, camera3.f, 0.0, 0.0, 0.0).setDistortion(camera3.k1, camera3.k2);
    }

    public void copyToSolution(PairwiseGraphUtils pairwiseUtils, MetricExpandByOneView.Solution solution) {
        solution.commonFeatureIndexes.resize(this.usedThreeViewInliers.size());
        for (int i = 0; i < this.usedThreeViewInliers.size(); ++i) {
            int commonIndex = pairwiseUtils.inlierIdx.get(this.usedThreeViewInliers.get(i));
            solution.commonFeatureIndexes.set(i, commonIndex);
        }
        this.view1_to_target.T.scale(this.local_to_global);
        this.wview1.world_to_view.concat(this.view1_to_target, solution.world_to_target);
        solution.intrinsic.setTo(this.camera3);
    }

    public void configureSbaStructure(List<AssociatedTriple> inliersThreeView) {
        SceneStructureMetric structure = this.metricSba.structure;
        SceneObservations observations = this.metricSba.observations;
        structure.initialize(3, 3, this.usedThreeViewInliers.size);
        observations.initialize(3);
        structure.setCamera(0, true, this.camera1);
        structure.setCamera(1, true, this.camera2);
        structure.setCamera(2, true, this.camera3);
        structure.setView(0, 0, true, this.view1_to_view1);
        structure.setView(1, 1, true, this.view1_to_view2);
        structure.setView(2, 2, true, this.view1_to_target);
        observations.getView(0).resize(this.usedThreeViewInliers.size());
        observations.getView(1).resize(this.usedThreeViewInliers.size());
        observations.getView(2).resize(this.usedThreeViewInliers.size());
        SceneObservations.View viewObs1 = observations.getView(0);
        SceneObservations.View viewObs2 = observations.getView(1);
        SceneObservations.View viewObs3 = observations.getView(2);
        TriangulateNViewsMetricH triangulator = this.metricSba.triangulator;
        Point4D_F64 foundX = new Point4D_F64();
        for (int inlierCnt = 0; inlierCnt < this.usedThreeViewInliers.size(); ++inlierCnt) {
            int threeViewInlierIndex = this.usedThreeViewInliers.get(inlierCnt);
            AssociatedTriple a = inliersThreeView.get(threeViewInlierIndex);
            viewObs1.set(inlierCnt, inlierCnt, (float)a.p1.x, (float)a.p1.y);
            viewObs2.set(inlierCnt, inlierCnt, (float)a.p2.x, (float)a.p2.y);
            viewObs3.set(inlierCnt, inlierCnt, (float)a.p3.x, (float)a.p3.y);
            this.normalize1.compute(a.p1.x, a.p1.y, this.pixelNorms.get(0));
            this.normalize2.compute(a.p2.x, a.p2.y, this.pixelNorms.get(1));
            this.normalize3.compute(a.p3.x, a.p3.y, this.pixelNorms.get(2));
            if (!triangulator.triangulate(this.pixelNorms, this.listMotion, foundX)) {
                throw new RuntimeException("Triangulation failed. Possibly bad input. Handle this problem");
            }
            if (structure.isHomogenous()) {
                structure.setPoint(inlierCnt, foundX.x, foundX.y, foundX.z, foundX.w);
            } else {
                structure.setPoint(inlierCnt, foundX.x / foundX.w, foundX.y / foundX.w, foundX.z / foundX.w);
            }
            structure.connectPointToView(inlierCnt, 0);
            structure.connectPointToView(inlierCnt, 1);
            structure.connectPointToView(inlierCnt, 2);
        }
    }

    public boolean performBundleAdjustment(@Nullable PrintStream verbose) {
        if (!this.metricSba.process()) {
            return false;
        }
        this.view1_to_target.setTo(this.metricSba.structure.getParentToView(2));
        if (verbose != null) {
            verbose.printf("refined 1_to_3 T=(%.2f %.2f %.2f) f=%.1f k1=%.3f k2=%.3f\n", this.view1_to_target.T.x, this.view1_to_target.T.y, this.view1_to_target.T.z, this.camera3.f, this.camera3.k1, this.camera3.k2);
        }
        return true;
    }

    public RemoveResults removedBadFeatures(PairwiseGraphUtils utils, double fractionBadFeaturesRecover, @Nullable PrintStream verbose) {
        if (verbose != null) {
            verbose.printf("prior: A={fx=%.1f cx=%.1f %.1f} B={fx=%.1f cx=%.1f %.1f} C={fx=%.1f cx=%.1f %.1f}\n", utils.priorCamA.fx, utils.priorCamA.cx, utils.priorCamA.cy, utils.priorCamB.fx, utils.priorCamB.cx, utils.priorCamB.cy, utils.priorCamC.fx, utils.priorCamC.cx, utils.priorCamC.cy);
        }
        this.listPriorCameras.clear();
        this.listPriorCameras.add(utils.priorCamA);
        this.listPriorCameras.add(utils.priorCamB);
        this.listPriorCameras.add(utils.priorCamC);
        if (!this.checks.checkPhysicalConstraints(this.metricSba, this.listPriorCameras)) {
            if (verbose != null) {
                verbose.println("Fatal error when checking constraints");
            }
            return RemoveResults.FAILED;
        }
        BoofMiscOps.checkEq(this.usedThreeViewInliers.size(), this.checks.badFeatures.size);
        int countBadFeatures = this.checks.badFeatures.count(true);
        if ((double)countBadFeatures > fractionBadFeaturesRecover * (double)this.checks.badFeatures.size) {
            if (verbose != null) {
                verbose.println("Failed check on image and physical constraints. bad=" + countBadFeatures + "/" + this.checks.badFeatures.size);
            }
            return RemoveResults.FAILED;
        }
        if (countBadFeatures == 0) {
            return RemoveResults.GOOD;
        }
        for (int inlierIdx = this.checks.badFeatures.size - 1; inlierIdx >= 0; --inlierIdx) {
            if (!this.checks.badFeatures.get(inlierIdx)) continue;
            this.usedThreeViewInliers.removeSwap(inlierIdx);
        }
        return RemoveResults.AGAIN;
    }

    public boolean verifyPhysicalConstraints(double fractionAccept, @Nullable PrintStream verbose) {
        if (!this.checks.checkPhysicalConstraints(this.metricSba, this.listPriorCameras)) {
            if (verbose != null) {
                verbose.println("Fatal error when checking constraints");
            }
            return false;
        }
        BoofMiscOps.checkEq(this.usedThreeViewInliers.size(), this.checks.badFeatures.size);
        int countBadFeatures = this.checks.badFeatures.count(true);
        if ((double)countBadFeatures > fractionAccept * (double)this.checks.badFeatures.size) {
            if (verbose != null) {
                verbose.println("Failed check on image and physical constraints. bad=" + countBadFeatures + "/" + this.checks.badFeatures.size + " maxFraction=" + fractionAccept);
            }
            return false;
        }
        return true;
    }

    static enum RemoveResults {
        GOOD,
        FAILED,
        AGAIN;

    }
}

