/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.similar;

import boofcv.abst.scene.nister2006.ConfigRecognitionNister2006;
import boofcv.factory.feature.associate.ConfigAssociate;
import boofcv.factory.feature.describe.ConfigConvertTupleDesc;
import boofcv.factory.feature.describe.ConfigDescribePoint;
import boofcv.factory.feature.describe.ConfigDescribeRegion;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigLength;
import boofcv.struct.Configuration;

public class ConfigSimilarImagesTrackThenMatch
implements Configuration {
    public int limitQuery = 20;
    public int minimumRecognizeDistance = 30;
    public int sequentialSearchRadius = 8;
    public final ConfigLength sequentialMinimumCommonTracks = ConfigLength.relative(0.4, 200.0);
    public final ConfigLength minimumSimilar = ConfigLength.relative(0.35, 150.0);
    public final ConfigDescribePoint descriptions = new ConfigDescribePoint();
    public final ConfigRecognitionNister2006 recognizeNister2006 = new ConfigRecognitionNister2006();
    public final ConfigAssociate associate = new ConfigAssociate();

    public ConfigSimilarImagesTrackThenMatch() {
        this.recognizeNister2006.learningMinimumPointsForChildren.setFixed(20.0);
        this.descriptions.descriptors.type = ConfigDescribeRegion.Type.SURF_STABLE;
        this.descriptions.radius = 20.0;
        this.descriptions.convert.outputData = ConfigConvertTupleDesc.DataType.F32;
    }

    @Override
    public void checkValidity() {
        BoofMiscOps.checkTrue(this.limitQuery >= 1, "Must consider at least 1 match");
        this.descriptions.checkValidity();
        this.recognizeNister2006.checkValidity();
        this.associate.checkValidity();
        this.sequentialMinimumCommonTracks.checkValidity();
    }

    public ConfigSimilarImagesTrackThenMatch setTo(ConfigSimilarImagesTrackThenMatch src) {
        this.sequentialSearchRadius = src.sequentialSearchRadius;
        this.sequentialMinimumCommonTracks.setTo(src.sequentialMinimumCommonTracks);
        this.limitQuery = src.limitQuery;
        this.minimumRecognizeDistance = src.minimumRecognizeDistance;
        this.minimumSimilar.setTo(src.minimumSimilar);
        this.descriptions.setTo(src.descriptions);
        this.recognizeNister2006.setTo(src.recognizeNister2006);
        this.associate.setTo(src.associate);
        return this;
    }
}

