/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm;

import boofcv.abst.disparity.StereoDisparitySparse;
import boofcv.abst.sfm.ImagePixelTo3D;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.sfm.StereoProcessingBase;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;

public class StereoSparse3D<T extends ImageGray<T>>
extends StereoProcessingBase<T>
implements ImagePixelTo3D {
    private final StereoDisparitySparse<T> disparity;
    private Point2Transform2_F64 leftPixelToRect;
    private final Point2D_F64 pixelRect = new Point2D_F64();
    private final Point3D_F64 pointLeft = new Point3D_F64();
    private double w;

    public StereoSparse3D(StereoDisparitySparse<T> disparity, Class<T> imageType) {
        super(imageType);
        this.disparity = disparity;
    }

    @Override
    public void setCalibration(StereoParameters stereoParam) {
        super.setCalibration(stereoParam);
        this.leftPixelToRect = RectifyImageOps.transformPixelToRect(stereoParam.left, this.rect1);
    }

    @Override
    public void setImages(T leftImage, T rightImage) {
        super.setImages(leftImage, rightImage);
        this.disparity.setImages(this.imageLeftRect, this.imageRightRect);
    }

    @Override
    public boolean process(double x, double y) {
        this.leftPixelToRect.compute(x, y, this.pixelRect);
        if (!this.disparity.process((int)(this.pixelRect.x + 0.5), (int)(this.pixelRect.y + 0.5))) {
            return false;
        }
        this.w = this.disparity.getDisparity();
        this.computeHomo3D(this.pixelRect.x, this.pixelRect.y, this.pointLeft);
        return true;
    }

    @Override
    public double getX() {
        return this.pointLeft.x;
    }

    @Override
    public double getY() {
        return this.pointLeft.y;
    }

    @Override
    public double getZ() {
        return this.pointLeft.z;
    }

    @Override
    public double getW() {
        return this.w;
    }
}

