/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.scene.nister2006;

import boofcv.misc.BoofMiscOps;
import org.ddogleg.struct.DogArray_F32;

public interface TupleMapDistanceNorm {
    public void normalize(DogArray_F32 var1);

    public float distanceUpdate(float var1, float var2);

    public TupleMapDistanceNorm newInstanceThread();

    public static class L2
    implements TupleMapDistanceNorm {
        @Override
        public void normalize(DogArray_F32 weights) {
            int i;
            float norm = 0.0f;
            for (i = 0; i < weights.size; ++i) {
                float value = weights.data[i];
                norm += value * value;
            }
            BoofMiscOps.checkTrue((double)(norm = (float)Math.sqrt(norm)) != 0.0, "Sum of weights is zero. Something went very wrong");
            i = 0;
            while (i < weights.size) {
                int n = i++;
                weights.data[n] = weights.data[n] / norm;
            }
        }

        @Override
        public float distanceUpdate(float valA, float valB) {
            return -2.0f * valA * valB;
        }

        @Override
        public TupleMapDistanceNorm newInstanceThread() {
            return new L2();
        }
    }

    public static class L1
    implements TupleMapDistanceNorm {
        @Override
        public void normalize(DogArray_F32 weights) {
            int i;
            float norm = 0.0f;
            for (i = 0; i < weights.size; ++i) {
                norm += weights.get(i);
            }
            BoofMiscOps.checkTrue(norm != 0.0f, "Norm value is zero. Something went very wrong");
            i = 0;
            while (i < weights.size) {
                int n = i++;
                weights.data[n] = weights.data[n] / norm;
            }
        }

        @Override
        public float distanceUpdate(float valA, float valB) {
            return Math.abs(valA - valB) - valA - valB;
        }

        @Override
        public TupleMapDistanceNorm newInstanceThread() {
            return new L1();
        }
    }

    public static enum Types {
        L1,
        L2;

    }
}

