/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class StereoPairGraph {
    public final Map<String, Vertex> vertexes = new HashMap<String, Vertex>();

    public Vertex addVertex(String id, int indexSba) {
        Vertex v = new Vertex();
        v.id = id;
        v.indexSba = indexSba;
        if (null != this.vertexes.put(v.id, v)) {
            throw new IllegalArgumentException("There was already a node with id=" + v.id);
        }
        return v;
    }

    public Edge connect(String a, String b, double quality3D) {
        Vertex va = Objects.requireNonNull(this.vertexes.get(a));
        Vertex vb = Objects.requireNonNull(this.vertexes.get(b));
        Edge e = new Edge();
        e.va = va;
        e.vb = vb;
        e.quality3D = quality3D;
        va.pairs.add(e);
        vb.pairs.add(e);
        return e;
    }

    public void reset() {
        this.vertexes.clear();
    }

    public static class Vertex {
        public String id = "";
        public int indexSba = -1;
        public final List<Edge> pairs = new ArrayList<Edge>();
    }

    public static class Edge {
        public Vertex va;
        public Vertex vb;
        public double quality3D = 0.0;

        public Vertex other(Vertex src) {
            if (src == this.va) {
                return this.vb;
            }
            if (src == this.vb) {
                return this.va;
            }
            throw new IllegalArgumentException("Edge does not link to src.id=" + src.id);
        }
    }
}

