/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.mvs;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.distort.pinhole.PixelTransformPinholeNorm_F64;
import boofcv.alg.geo.rectify.DisparityParameters;
import boofcv.alg.mvs.impl.ImplMultiViewStereoOps;
import boofcv.misc.BoofLambdas;
import boofcv.struct.distort.PixelTransform;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.jetbrains.annotations.Nullable;

public class MultiViewStereoOps {
    public static void maskOutPointsInCloud(List<Point3D_F64> cloud, GrayF32 inverseDepth, Se3_F64 cloud_to_camera, Point2Transform2_F64 rectNorm_to_dispPixel, double tolerance, GrayU8 mask) {
        InputSanityCheck.checkSameShape(inverseDepth, mask);
        Point3D_F64 cameraPt = new Point3D_F64();
        Point2D_F64 pixel = new Point2D_F64();
        for (int cloudIdx = 0; cloudIdx < cloud.size(); ++cloudIdx) {
            double projInv;
            float inv;
            Point3D_F64 cloudPt = cloud.get(cloudIdx);
            SePointOps_F64.transform(cloud_to_camera, cloudPt, cameraPt);
            if (cameraPt.z <= 0.0) continue;
            rectNorm_to_dispPixel.compute(cameraPt.x / cameraPt.z, cameraPt.y / cameraPt.z, pixel);
            int px = (int)(pixel.x + 0.5);
            int py = (int)(pixel.y + 0.5);
            if (pixel.x < -0.5 || pixel.y < -0.5 || px >= inverseDepth.width || py >= inverseDepth.height || mask.unsafe_get(px, py) != 0 || (inv = inverseDepth.unsafe_get(px, py)) < 0.0f || Math.abs((double)inv - (projInv = 1.0 / cameraPt.z)) > tolerance) continue;
            mask.unsafe_set(px, py, 1);
        }
    }

    public static void disparityToCloud(GrayF32 disparity, DisparityParameters parameters, BoofLambdas.PixXyzConsumer_F64 consumer) {
        ImplMultiViewStereoOps.disparityToCloud(disparity, parameters, consumer);
    }

    public static void disparityToCloud(ImageGray<?> disparity, DisparityParameters parameters, @Nullable PixelTransform<Point2D_F64> pixelToNorm, BoofLambdas.PixXyzConsumer_F64 consumer) {
        if (pixelToNorm == null) {
            pixelToNorm = new PixelTransformPinholeNorm_F64().fset(parameters.pinhole);
        }
        if (disparity instanceof GrayF32) {
            ImplMultiViewStereoOps.disparityToCloud((GrayF32)disparity, parameters, (PixelTransform<Point2D_F64>)pixelToNorm, consumer);
        } else if (disparity instanceof GrayU8) {
            ImplMultiViewStereoOps.disparityToCloud((GrayU8)disparity, parameters, (PixelTransform<Point2D_F64>)pixelToNorm, consumer);
        } else {
            throw new IllegalArgumentException("Unknown image type. " + disparity.getClass().getSimpleName());
        }
    }

    public static void inverseToCloud(GrayF32 inverseDepth, PixelTransform<Point2D_F64> pixelToNorm, BoofLambdas.PixXyzConsumer_F64 consumer) {
        ImplMultiViewStereoOps.inverseToCloud(inverseDepth, pixelToNorm, consumer);
    }

    public static float averageScore(ImageGray<?> disparity, double disparityRange, GrayF32 score) {
        if (disparity instanceof GrayU8) {
            return ImplMultiViewStereoOps.averageScore((GrayU8)disparity, (int)disparityRange, score);
        }
        if (disparity instanceof GrayF32) {
            return ImplMultiViewStereoOps.averageScore((GrayF32)disparity, (float)disparityRange, score);
        }
        throw new RuntimeException("Unsupported image type");
    }

    public static void invalidateUsingError(ImageGray<?> disparity, double disparityRange, GrayF32 score, float threshold) {
        if (disparity instanceof GrayU8) {
            ImplMultiViewStereoOps.invalidateUsingError((GrayU8)disparity, (int)disparityRange, score, threshold);
        } else if (disparity instanceof GrayF32) {
            ImplMultiViewStereoOps.invalidateUsingError((GrayF32)disparity, (float)disparityRange, score, threshold);
        } else {
            throw new RuntimeException("Unsupported image type");
        }
    }

    public static void invalidateBorder(int width, int height, PixelTransform<Point2D_F64> dist_to_undist, DMatrixRMaj undist_to_rect, int radius, float invalidValue, GrayF32 disparity) {
        if (radius <= 0) {
            return;
        }
        Point2D_F64 pixel = new Point2D_F64();
        BoofLambdas.ProcessII op = (x, y) -> {
            dist_to_undist.compute(x, y, pixel);
            GeometryMath_F64.mult(undist_to_rect, pixel, pixel);
            if (pixel.x < 0.0 || pixel.y < 0.0) {
                return;
            }
            int cx = (int)(pixel.x + 0.5);
            int cy = (int)(pixel.y + 0.5);
            if (cx >= disparity.width || cy >= disparity.height) {
                return;
            }
            for (int i = -radius; i <= radius; ++i) {
                int yy = cy + i;
                if (yy < 0 || yy >= disparity.height) continue;
                for (int j = -radius; j <= radius; ++j) {
                    int xx = cx + j;
                    if (xx < 0 || xx >= disparity.width) continue;
                    disparity.unsafe_set(xx, yy, invalidValue);
                }
            }
        };
        for (int x2 = 0; x2 < width; ++x2) {
            op.process(x2, 0);
            op.process(x2, height - 1);
        }
        for (int y2 = 1; y2 < height - 1; ++y2) {
            op.process(0, y2);
            op.process(width - 1, y2);
        }
    }
}

