/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.misc;

import boofcv.alg.misc.impl.ImplImageBandMath;
import boofcv.alg.misc.impl.ImplImageBandMath_MT;
import boofcv.concurrency.BoofConcurrency;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayS64;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import org.jetbrains.annotations.Nullable;

public class ImageBandMath {
    public static <T extends ImageGray<T>> void checkInput(Planar<T> input, int startBand, int lastBand) {
        if (startBand < 0 || lastBand < 0) {
            throw new IllegalArgumentException("startBand or lastBand is less than zero");
        }
        if (startBand > lastBand) {
            throw new IllegalArgumentException("startBand should <= lastBand");
        }
        if (lastBand >= input.getNumBands()) {
            throw new IllegalArgumentException("lastBand should be less than number of Bands in input");
        }
    }

    public static void minimum(Planar<GrayU8> input, GrayU8 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.minimum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void minimum(Planar<GrayU8> input, GrayU8 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.minimum(input, output, startBand, lastBand);
        }
    }

    public static void maximum(Planar<GrayU8> input, GrayU8 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.maximum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void maximum(Planar<GrayU8> input, GrayU8 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.maximum(input, output, startBand, lastBand);
        }
    }

    public static void average(Planar<GrayU8> input, GrayU8 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.average(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void average(Planar<GrayU8> input, GrayU8 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.average(input, output, startBand, lastBand);
        }
    }

    public static void median(Planar<GrayU8> input, GrayU8 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.median(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void median(Planar<GrayU8> input, GrayU8 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.median(input, output, startBand, lastBand);
        }
    }

    public static void stdDev(Planar<GrayU8> input, GrayU8 output, @Nullable GrayU8 avg) {
        ImageBandMath.stdDev(input, output, avg, 0, input.getNumBands() - 1);
    }

    public static void stdDev(Planar<GrayU8> input, GrayU8 output, @Nullable GrayU8 avg, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (avg == null) {
            avg = new GrayU8(input.width, input.height);
            ImageBandMath.average(input, avg, startBand, lastBand);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.stdDev(input, output, avg, startBand, lastBand);
        } else {
            ImplImageBandMath.stdDev(input, output, avg, startBand, lastBand);
        }
    }

    public static void minimum(Planar<GrayS16> input, GrayS16 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.minimum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void minimum(Planar<GrayS16> input, GrayS16 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.minimum(input, output, startBand, lastBand);
        }
    }

    public static void maximum(Planar<GrayS16> input, GrayS16 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.maximum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void maximum(Planar<GrayS16> input, GrayS16 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.maximum(input, output, startBand, lastBand);
        }
    }

    public static void average(Planar<GrayS16> input, GrayS16 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.average(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void average(Planar<GrayS16> input, GrayS16 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.average(input, output, startBand, lastBand);
        }
    }

    public static void median(Planar<GrayS16> input, GrayS16 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.median(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void median(Planar<GrayS16> input, GrayS16 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.median(input, output, startBand, lastBand);
        }
    }

    public static void stdDev(Planar<GrayS16> input, GrayS16 output, @Nullable GrayS16 avg) {
        ImageBandMath.stdDev(input, output, avg, 0, input.getNumBands() - 1);
    }

    public static void stdDev(Planar<GrayS16> input, GrayS16 output, @Nullable GrayS16 avg, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (avg == null) {
            avg = new GrayS16(input.width, input.height);
            ImageBandMath.average(input, avg, startBand, lastBand);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.stdDev(input, output, avg, startBand, lastBand);
        } else {
            ImplImageBandMath.stdDev(input, output, avg, startBand, lastBand);
        }
    }

    public static void minimum(Planar<GrayU16> input, GrayU16 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.minimum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void minimum(Planar<GrayU16> input, GrayU16 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.minimum(input, output, startBand, lastBand);
        }
    }

    public static void maximum(Planar<GrayU16> input, GrayU16 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.maximum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void maximum(Planar<GrayU16> input, GrayU16 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.maximum(input, output, startBand, lastBand);
        }
    }

    public static void average(Planar<GrayU16> input, GrayU16 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.average(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void average(Planar<GrayU16> input, GrayU16 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.average(input, output, startBand, lastBand);
        }
    }

    public static void median(Planar<GrayU16> input, GrayU16 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.median(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void median(Planar<GrayU16> input, GrayU16 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.median(input, output, startBand, lastBand);
        }
    }

    public static void stdDev(Planar<GrayU16> input, GrayU16 output, @Nullable GrayU16 avg) {
        ImageBandMath.stdDev(input, output, avg, 0, input.getNumBands() - 1);
    }

    public static void stdDev(Planar<GrayU16> input, GrayU16 output, @Nullable GrayU16 avg, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (avg == null) {
            avg = new GrayU16(input.width, input.height);
            ImageBandMath.average(input, avg, startBand, lastBand);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.stdDev(input, output, avg, startBand, lastBand);
        } else {
            ImplImageBandMath.stdDev(input, output, avg, startBand, lastBand);
        }
    }

    public static void minimum(Planar<GrayS32> input, GrayS32 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.minimum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void minimum(Planar<GrayS32> input, GrayS32 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.minimum(input, output, startBand, lastBand);
        }
    }

    public static void maximum(Planar<GrayS32> input, GrayS32 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.maximum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void maximum(Planar<GrayS32> input, GrayS32 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.maximum(input, output, startBand, lastBand);
        }
    }

    public static void average(Planar<GrayS32> input, GrayS32 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.average(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void average(Planar<GrayS32> input, GrayS32 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.average(input, output, startBand, lastBand);
        }
    }

    public static void median(Planar<GrayS32> input, GrayS32 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.median(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void median(Planar<GrayS32> input, GrayS32 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.median(input, output, startBand, lastBand);
        }
    }

    public static void stdDev(Planar<GrayS32> input, GrayS32 output, @Nullable GrayS32 avg) {
        ImageBandMath.stdDev(input, output, avg, 0, input.getNumBands() - 1);
    }

    public static void stdDev(Planar<GrayS32> input, GrayS32 output, @Nullable GrayS32 avg, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (avg == null) {
            avg = new GrayS32(input.width, input.height);
            ImageBandMath.average(input, avg, startBand, lastBand);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.stdDev(input, output, avg, startBand, lastBand);
        } else {
            ImplImageBandMath.stdDev(input, output, avg, startBand, lastBand);
        }
    }

    public static void minimum(Planar<GrayS64> input, GrayS64 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.minimum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void minimum(Planar<GrayS64> input, GrayS64 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.minimum(input, output, startBand, lastBand);
        }
    }

    public static void maximum(Planar<GrayS64> input, GrayS64 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.maximum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void maximum(Planar<GrayS64> input, GrayS64 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.maximum(input, output, startBand, lastBand);
        }
    }

    public static void average(Planar<GrayS64> input, GrayS64 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.average(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void average(Planar<GrayS64> input, GrayS64 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.average(input, output, startBand, lastBand);
        }
    }

    public static void median(Planar<GrayS64> input, GrayS64 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.median(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void median(Planar<GrayS64> input, GrayS64 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.median(input, output, startBand, lastBand);
        }
    }

    public static void stdDev(Planar<GrayS64> input, GrayS64 output, @Nullable GrayS64 avg) {
        ImageBandMath.stdDev(input, output, avg, 0, input.getNumBands() - 1);
    }

    public static void stdDev(Planar<GrayS64> input, GrayS64 output, @Nullable GrayS64 avg, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (avg == null) {
            avg = new GrayS64(input.width, input.height);
            ImageBandMath.average(input, avg, startBand, lastBand);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.stdDev(input, output, avg, startBand, lastBand);
        } else {
            ImplImageBandMath.stdDev(input, output, avg, startBand, lastBand);
        }
    }

    public static void minimum(Planar<GrayF32> input, GrayF32 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.minimum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void minimum(Planar<GrayF32> input, GrayF32 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.minimum(input, output, startBand, lastBand);
        }
    }

    public static void maximum(Planar<GrayF32> input, GrayF32 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.maximum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void maximum(Planar<GrayF32> input, GrayF32 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.maximum(input, output, startBand, lastBand);
        }
    }

    public static void average(Planar<GrayF32> input, GrayF32 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.average(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void average(Planar<GrayF32> input, GrayF32 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.average(input, output, startBand, lastBand);
        }
    }

    public static void median(Planar<GrayF32> input, GrayF32 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.median(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void median(Planar<GrayF32> input, GrayF32 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.median(input, output, startBand, lastBand);
        }
    }

    public static void stdDev(Planar<GrayF32> input, GrayF32 output, @Nullable GrayF32 avg) {
        ImageBandMath.stdDev(input, output, avg, 0, input.getNumBands() - 1);
    }

    public static void stdDev(Planar<GrayF32> input, GrayF32 output, @Nullable GrayF32 avg, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (avg == null) {
            avg = new GrayF32(input.width, input.height);
            ImageBandMath.average(input, avg, startBand, lastBand);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.stdDev(input, output, avg, startBand, lastBand);
        } else {
            ImplImageBandMath.stdDev(input, output, avg, startBand, lastBand);
        }
    }

    public static void minimum(Planar<GrayF64> input, GrayF64 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.minimum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void minimum(Planar<GrayF64> input, GrayF64 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.minimum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.minimum(input, output, startBand, lastBand);
        }
    }

    public static void maximum(Planar<GrayF64> input, GrayF64 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.maximum(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void maximum(Planar<GrayF64> input, GrayF64 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.maximum(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.maximum(input, output, startBand, lastBand);
        }
    }

    public static void average(Planar<GrayF64> input, GrayF64 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.average(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void average(Planar<GrayF64> input, GrayF64 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.average(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.average(input, output, startBand, lastBand);
        }
    }

    public static void median(Planar<GrayF64> input, GrayF64 output) {
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, 0, input.getNumBands() - 1);
        } else {
            ImplImageBandMath.median(input, output, 0, input.getNumBands() - 1);
        }
    }

    public static void median(Planar<GrayF64> input, GrayF64 output, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.median(input, output, startBand, lastBand);
        } else {
            ImplImageBandMath.median(input, output, startBand, lastBand);
        }
    }

    public static void stdDev(Planar<GrayF64> input, GrayF64 output, @Nullable GrayF64 avg) {
        ImageBandMath.stdDev(input, output, avg, 0, input.getNumBands() - 1);
    }

    public static void stdDev(Planar<GrayF64> input, GrayF64 output, @Nullable GrayF64 avg, int startBand, int lastBand) {
        ImageBandMath.checkInput(input, startBand, lastBand);
        output.reshape(input.width, input.height);
        if (avg == null) {
            avg = new GrayF64(input.width, input.height);
            ImageBandMath.average(input, avg, startBand, lastBand);
        }
        if (BoofConcurrency.USE_CONCURRENT) {
            ImplImageBandMath_MT.stdDev(input, output, avg, startBand, lastBand);
        } else {
            ImplImageBandMath.stdDev(input, output, avg, startBand, lastBand);
        }
    }
}

