/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.interpolate.impl;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.convolve.KernelContinuous1D_F32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.ImageType;

public class ImplInterpolatePixelConvolution_S16
implements InterpolatePixelS<GrayS16> {
    private ImageBorder_S32 border;
    private final KernelContinuous1D_F32 kernel;
    private GrayS16 image;
    private final float min;
    private final float max;

    public ImplInterpolatePixelConvolution_S16(KernelContinuous1D_F32 kernel, float min, float max) {
        this.kernel = kernel;
        this.min = min;
        this.max = max;
    }

    @Override
    public void setBorder(ImageBorder<GrayS16> border) {
        this.border = (ImageBorder_S32)border;
    }

    @Override
    public void setImage(GrayS16 image) {
        if (this.border != null) {
            this.border.setImage(image);
        }
        this.image = image;
    }

    @Override
    public GrayS16 getImage() {
        return this.image;
    }

    @Override
    public float get(float x, float y) {
        if (x < 0.0f || y < 0.0f || x > (float)(this.image.width - 1) || y > (float)(this.image.height - 1)) {
            return this.get_border(x, y);
        }
        int xx = (int)x;
        int yy = (int)y;
        int radius = this.kernel.getRadius();
        int width = this.kernel.getWidth();
        int x0 = xx - radius;
        int x1 = x0 + width;
        int y0 = yy - radius;
        int y1 = y0 + width;
        if (x0 < 0) {
            x0 = 0;
        }
        if (x1 > this.image.width) {
            x1 = this.image.width;
        }
        if (y0 < 0) {
            y0 = 0;
        }
        if (y1 > this.image.height) {
            y1 = this.image.height;
        }
        float value = 0.0f;
        float totalWeightY = 0.0f;
        for (int i = y0; i < y1; ++i) {
            int indexSrc = this.image.startIndex + i * this.image.stride + x0;
            float totalWeightX = 0.0f;
            float valueX = 0.0f;
            for (int j = x0; j < x1; ++j) {
                float w = this.kernel.compute((float)j - x);
                totalWeightX += w;
                valueX += w * (float)this.image.data[indexSrc++];
            }
            float w = this.kernel.compute((float)i - y);
            totalWeightY += w;
            value += w * valueX / totalWeightX;
        }
        if ((value /= totalWeightY) > this.max) {
            return this.max;
        }
        if (value < this.min) {
            return this.min;
        }
        return value;
    }

    public float get_border(float x, float y) {
        int xx = (int)Math.floor(x);
        int yy = (int)Math.floor(y);
        int radius = this.kernel.getRadius();
        int width = this.kernel.getWidth();
        int x0 = xx - radius;
        int x1 = x0 + width;
        int y0 = yy - radius;
        int y1 = y0 + width;
        float value = 0.0f;
        for (int i = y0; i < y1; ++i) {
            float valueX = 0.0f;
            for (int j = x0; j < x1; ++j) {
                float w = this.kernel.compute((float)j - x);
                valueX += w * (float)this.border.get(j, i);
            }
            float w = this.kernel.compute((float)i - y);
            value += w * valueX;
        }
        if (value > this.max) {
            return this.max;
        }
        if (value < this.min) {
            return this.min;
        }
        return value;
    }

    @Override
    public float get_fast(float x, float y) {
        int xx = (int)x;
        int yy = (int)y;
        int radius = this.kernel.getRadius();
        int width = this.kernel.getWidth();
        int x0 = xx - radius;
        int x1 = x0 + width;
        int y0 = yy - radius;
        int y1 = y0 + width;
        float value = 0.0f;
        for (int i = y0; i < y1; ++i) {
            int indexSrc = this.image.startIndex + i * this.image.stride + x0;
            float valueX = 0.0f;
            for (int j = x0; j < x1; ++j) {
                float w = this.kernel.compute((float)j - x);
                valueX += w * (float)this.image.data[indexSrc++];
            }
            float w = this.kernel.compute((float)i - y);
            value += w * valueX;
        }
        if (value > this.max) {
            return this.max;
        }
        if (value < this.min) {
            return this.min;
        }
        return value;
    }

    @Override
    public boolean isInFastBounds(float x, float y) {
        float r = this.kernel.getRadius();
        return x - r >= 0.0f && y - r >= 0.0f && x + r < (float)this.image.width && y + r < (float)this.image.height;
    }

    @Override
    public int getFastBorderX() {
        return this.kernel.getRadius();
    }

    @Override
    public int getFastBorderY() {
        return this.kernel.getRadius();
    }

    @Override
    public ImageBorder<GrayS16> getBorder() {
        return this.border;
    }

    @Override
    public InterpolatePixelS<GrayS16> copy() {
        ImplInterpolatePixelConvolution_S16 out = new ImplInterpolatePixelConvolution_S16(this.kernel, this.min, this.max);
        out.setBorder(this.border.copy());
        return out;
    }

    @Override
    public ImageType<GrayS16> getImageType() {
        return ImageType.single(GrayS16.class);
    }
}

