/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.selfcalib.TwoViewToCalibratingHomography;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.geo.AssociatedPair;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.VerbosePrint;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import org.jetbrains.annotations.Nullable;

public class SelfCalibrationEssentialGuessAndCheck
implements VerbosePrint {
    public double sampleFocalRatioMin = 0.3;
    public double sampleFocalRatioMax = 2.5;
    public int numberOfSamples = 50;
    public boolean fixedFocus = false;
    public double focalLengthA;
    public double focalLengthB;
    public final DMatrixRMaj rectifyingHomography = new DMatrixRMaj(4, 4);
    public boolean isLimit;
    public int imageLengthPixels = 0;
    public final TwoViewToCalibratingHomography calibrator = new TwoViewToCalibratingHomography();
    private final SingularValueDecomposition_F64<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(3, 3, false, false, false);
    final DMatrixRMaj E = new DMatrixRMaj(3, 3);
    final DMatrixRMaj K1 = new DMatrixRMaj(3, 3);
    final DMatrixRMaj K2 = new DMatrixRMaj(3, 3);
    @Nullable
    private PrintStream verbose;

    public void configure(double sampleFocalRatioMin, double sampleFocalRatioMax) {
        this.sampleFocalRatioMin = sampleFocalRatioMin;
        this.sampleFocalRatioMax = sampleFocalRatioMax;
    }

    public boolean process(DMatrixRMaj F21, DMatrixRMaj P2, List<AssociatedPair> observations) {
        BoofMiscOps.checkTrue(this.imageLengthPixels > 0, "Must set imageLengthPixels to max(imageWidth,imageHeight)");
        BoofMiscOps.checkTrue(this.sampleFocalRatioMin != 0.0 && this.sampleFocalRatioMax != 0.0, "You must call configure");
        BoofMiscOps.checkTrue(this.sampleFocalRatioMin < this.sampleFocalRatioMax && this.sampleFocalRatioMin > 0.0);
        BoofMiscOps.checkTrue(observations.size() > 0);
        BoofMiscOps.checkTrue(this.numberOfSamples > 0);
        this.calibrator.initialize(F21, P2);
        double logCoef = Math.log(this.sampleFocalRatioMax / this.sampleFocalRatioMin) / (double)(this.numberOfSamples - 1);
        this.isLimit = false;
        if (this.fixedFocus) {
            this.searchFixedFocus(logCoef);
        } else {
            this.searchDynamicFocus(logCoef);
        }
        this.computeHomography(this.focalLengthA, this.focalLengthB, observations);
        return true;
    }

    private void searchDynamicFocus(double logCoef) {
        this.K1.set(2, 2, 1.0);
        this.K2.set(2, 2, 1.0);
        double bestError = Double.MAX_VALUE;
        for (int idxA = 0; idxA < this.numberOfSamples; ++idxA) {
            double focalRatioA = this.sampleFocalRatioMin * Math.exp(logCoef * (double)idxA);
            double focalPixelsA = focalRatioA * (double)this.imageLengthPixels;
            this.K1.set(0, 0, focalPixelsA);
            this.K1.set(1, 1, focalPixelsA);
            for (int idxB = 0; idxB < this.numberOfSamples; ++idxB) {
                double focalRatioB = this.sampleFocalRatioMin * Math.exp(logCoef * (double)idxB);
                double focalPixelsB = focalRatioB * (double)this.imageLengthPixels;
                this.K2.set(0, 0, focalPixelsB);
                this.K2.set(1, 1, focalPixelsB);
                PerspectiveOps.multTranA(this.K2, this.calibrator.F21, this.K1, this.E);
                if (!this.svd.decompose(this.E)) continue;
                double error = this.computeFitError();
                if (this.verbose != null) {
                    this.verbose.printf("[%3d,%3d] f1=%5.2f f2=%5.2f error=%f\n", idxA, idxB, focalPixelsA, focalPixelsB, error);
                }
                if (!(error < bestError)) continue;
                this.isLimit = idxA == 0 || idxA == this.numberOfSamples - 1;
                this.isLimit |= idxB == 0 || idxB == this.numberOfSamples - 1;
                bestError = error;
                this.focalLengthA = focalPixelsA;
                this.focalLengthB = focalPixelsB;
            }
        }
    }

    private void computeHomography(double F1, double F2, List<AssociatedPair> observations) {
        DMatrixRMaj K1 = CommonOps_DDRM.diag(F1, F1, 1.0);
        DMatrixRMaj K2 = CommonOps_DDRM.diag(F2, F2, 1.0);
        this.calibrator.process(K1, K2, observations);
        this.rectifyingHomography.setTo(this.calibrator.getCalibrationHomography());
    }

    private void searchFixedFocus(double logCoef) {
        this.K1.set(2, 2, 1.0);
        double bestError = Double.MAX_VALUE;
        for (int idxA = 0; idxA < this.numberOfSamples; ++idxA) {
            double focalRatioA = this.sampleFocalRatioMin * Math.exp(logCoef * (double)idxA);
            double focalPixelsA = focalRatioA * (double)this.imageLengthPixels;
            this.K1.set(0, 0, focalPixelsA);
            this.K1.set(1, 1, focalPixelsA);
            PerspectiveOps.multTranA(this.K1, this.calibrator.F21, this.K1, this.E);
            if (!this.svd.decompose(this.E)) continue;
            double error = this.computeFitError();
            if (this.verbose != null) {
                this.verbose.printf("[%3d] f=%5.2f svd-error=%f\n", idxA, focalPixelsA, error);
            }
            if (!(error < bestError)) continue;
            this.isLimit = idxA == 0 || idxA == this.numberOfSamples - 1;
            bestError = error;
            this.focalLengthA = focalPixelsA;
        }
        this.focalLengthB = this.focalLengthA;
    }

    private double computeFitError() {
        double v1;
        double v0;
        double[] sv = this.svd.getSingularValues();
        if (sv[0] > sv[1]) {
            v0 = sv[0];
            v1 = sv[1];
        } else {
            v0 = sv[1];
            v1 = sv[0];
        }
        if (v1 < sv[2]) {
            v1 = sv[2];
        }
        Arrays.sort(sv, 0, 3);
        double mean = (v0 + v1) / 2.0;
        return Math.abs(v0 - mean) / mean;
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
    }

    public double getSampleFocalRatioMin() {
        return this.sampleFocalRatioMin;
    }

    public double getSampleFocalRatioMax() {
        return this.sampleFocalRatioMax;
    }

    public int getNumberOfSamples() {
        return this.numberOfSamples;
    }

    public boolean isFixedFocus() {
        return this.fixedFocus;
    }

    public double getFocalLengthA() {
        return this.focalLengthA;
    }

    public double getFocalLengthB() {
        return this.focalLengthB;
    }

    public DMatrixRMaj getRectifyingHomography() {
        return this.rectifyingHomography;
    }

    public boolean isLimit() {
        return this.isLimit;
    }

    public TwoViewToCalibratingHomography getCalibrator() {
        return this.calibrator;
    }
}

