/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.selfcalib;

import boofcv.abst.geo.TriangulateNViewsMetricH;
import boofcv.alg.distort.pinhole.PinholePtoN_F64;
import boofcv.alg.geo.MetricCameras;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.selfcalib.MetricCameraTriple;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import boofcv.struct.geo.AssociatedTriple;
import boofcv.struct.geo.AssociatedTuple;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point4D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.VerbosePrint;
import org.jetbrains.annotations.Nullable;

public class ResolveSignAmbiguityPositiveDepth
implements VerbosePrint {
    public TriangulateNViewsMetricH triangulator = FactoryMultiView.triangulateNViewMetricH(null);
    public boolean signChanged;
    public int bestInvalid;
    Point4D_F64 pointIn1 = new Point4D_F64();
    Point4D_F64 Xcam = new Point4D_F64();
    DogArray<PinholePtoN_F64> normalizers = new DogArray<PinholePtoN_F64>(PinholePtoN_F64::new);
    DogArray<Point2D_F64> pixelNorms = new DogArray<Point2D_F64>(Point2D_F64::new);
    DogArray<Se3_F64> worldToViews = new DogArray<Se3_F64>(Se3_F64::new);
    @Nullable
    PrintStream verbose;

    public void process(List<AssociatedTuple> observations, MetricCameras views) {
        int viewIdx;
        BoofMiscOps.checkTrue(views.intrinsics.size == views.motion_1_to_k.size + 1);
        BoofMiscOps.checkTrue(observations.size() > 0);
        int numViews = views.intrinsics.size;
        int numObs = observations.size();
        this.normalizers.resize(numViews);
        this.pixelNorms.resize(numViews);
        this.worldToViews.resize(numViews);
        for (viewIdx = 0; viewIdx < numViews; ++viewIdx) {
            ((PinholePtoN_F64)this.normalizers.get(viewIdx)).setK((CameraPinhole)views.intrinsics.get(viewIdx));
        }
        for (viewIdx = 1; viewIdx < numViews; ++viewIdx) {
            ((Se3_F64)this.worldToViews.get(viewIdx)).setTo((Se3_F64)views.motion_1_to_k.get(viewIdx - 1));
        }
        this.signChanged = false;
        int best = -1;
        this.bestInvalid = Integer.MAX_VALUE;
        for (int trial = 0; trial < 2; ++trial) {
            int foundInvalid = 0;
            for (int obsIdx = 0; obsIdx < numObs; ++obsIdx) {
                int viewIdx2;
                for (viewIdx2 = 0; viewIdx2 < numViews; ++viewIdx2) {
                    Point2D_F64 pixel = observations.get(obsIdx).get(viewIdx2);
                    ((PinholePtoN_F64)this.normalizers.get(viewIdx2)).compute(pixel.x, pixel.y, (Point2D_F64)this.pixelNorms.get(viewIdx2));
                }
                if (!this.triangulator.triangulate(this.pixelNorms.toList(), this.worldToViews.toList(), this.pointIn1)) {
                    foundInvalid += 2;
                    continue;
                }
                if (PerspectiveOps.isBehindCamera(this.pointIn1)) {
                    ++foundInvalid;
                }
                for (viewIdx2 = 1; viewIdx2 < numViews; ++viewIdx2) {
                    SePointOps_F64.transform((Se3_F64)this.worldToViews.get(viewIdx2), this.pointIn1, this.Xcam);
                    if (!PerspectiveOps.isBehindCamera(this.Xcam)) continue;
                    ++foundInvalid;
                }
            }
            if (this.verbose != null) {
                this.verbose.println("trial=" + trial + " invalid=" + foundInvalid + " obs=" + numObs);
            }
            for (int i = 1; i < this.worldToViews.size(); ++i) {
                ((Se3_F64)this.worldToViews.get((int)i)).T.scale(-1.0);
            }
            if (this.bestInvalid <= foundInvalid) continue;
            this.bestInvalid = foundInvalid;
            best = trial;
        }
        if (best == 1) {
            this.signChanged = true;
            for (int viewIdx3 = 0; viewIdx3 < views.motion_1_to_k.size; ++viewIdx3) {
                ((Se3_F64)views.motion_1_to_k.get((int)viewIdx3)).T.scale(-1.0);
            }
        }
        if (this.verbose != null) {
            this.verbose.println("best=" + best + " signChanged=" + this.signChanged);
        }
    }

    public void process(List<AssociatedTriple> observations, MetricCameraTriple result) {
        this.signChanged = false;
        int best = -1;
        this.bestInvalid = Integer.MAX_VALUE;
        this.normalizers.resize(3);
        this.pixelNorms.resize(3);
        this.worldToViews.resize(3);
        PinholePtoN_F64 normalize1 = (PinholePtoN_F64)this.normalizers.get(0);
        PinholePtoN_F64 normalize2 = (PinholePtoN_F64)this.normalizers.get(1);
        PinholePtoN_F64 normalize3 = (PinholePtoN_F64)this.normalizers.get(2);
        Point2D_F64 n1 = (Point2D_F64)this.pixelNorms.get(0);
        Point2D_F64 n2 = (Point2D_F64)this.pixelNorms.get(1);
        Point2D_F64 n3 = (Point2D_F64)this.pixelNorms.get(2);
        ((Se3_F64)this.worldToViews.get(1)).setTo(result.view_1_to_2);
        ((Se3_F64)this.worldToViews.get(2)).setTo(result.view_1_to_3);
        normalize1.setK(result.view1);
        normalize2.setK(result.view2);
        normalize3.setK(result.view3);
        for (int trial = 0; trial < 2; ++trial) {
            int i;
            int foundInvalid = 0;
            for (i = 0; i < observations.size(); ++i) {
                AssociatedTriple ap = observations.get(i);
                normalize1.compute(ap.p1.x, ap.p1.y, n1);
                normalize2.compute(ap.p2.x, ap.p2.y, n2);
                normalize2.compute(ap.p3.x, ap.p3.y, n3);
                this.triangulator.triangulate(this.pixelNorms.toList(), this.worldToViews.toList(), this.pointIn1);
                if (PerspectiveOps.isBehindCamera(this.pointIn1)) {
                    ++foundInvalid;
                }
                SePointOps_F64.transform(result.view_1_to_2, this.pointIn1, this.Xcam);
                if (PerspectiveOps.isBehindCamera(this.Xcam)) {
                    ++foundInvalid;
                }
                SePointOps_F64.transform(result.view_1_to_3, this.pointIn1, this.Xcam);
                if (!PerspectiveOps.isBehindCamera(this.Xcam)) continue;
                ++foundInvalid;
            }
            if (this.verbose != null) {
                this.verbose.println("trial=" + trial + " invalid=" + foundInvalid + " obs=" + observations.size());
            }
            for (i = 1; i < this.worldToViews.size(); ++i) {
                ((Se3_F64)this.worldToViews.get((int)i)).T.scale(-1.0);
            }
            if (this.bestInvalid <= foundInvalid) continue;
            this.bestInvalid = foundInvalid;
            best = trial;
        }
        if (best == 1) {
            this.signChanged = true;
            result.view_1_to_2.T.scale(-1.0);
            result.view_1_to_3.T.scale(-1.0);
        }
        if (this.verbose != null) {
            this.verbose.println("best=" + best + " signChanged=" + this.signChanged);
        }
    }

    @Override
    public void setVerbose(@Nullable PrintStream out, @Nullable Set<String> configuration) {
        this.verbose = BoofMiscOps.addPrefix(this, out);
    }
}

