/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.robust;

import boofcv.alg.geo.DistanceFromModelMultiView;
import boofcv.alg.geo.robust.ModelMatcherMultiview;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.CameraPinhole;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelMatcherPost;
import org.ddogleg.fitting.modelset.lmeds.LeastMedianOfSquares;
import org.ddogleg.struct.Factory;

public class LeastMedianOfSquaresCalibrated<Model, Point>
implements ModelMatcherMultiview<Model, Point>,
ModelMatcherPost<Model, Point> {
    private final LeastMedianOfSquares<Model, Point> fitter;
    final List<CameraPinhole> listIntrinsics = new ArrayList<CameraPinhole>();

    public LeastMedianOfSquaresCalibrated(LeastMedianOfSquares<Model, Point> fitter) {
        this.fitter = fitter;
        fitter.setInitializeModels((generator, distance) -> {
            DistanceFromModelMultiView dist = (DistanceFromModelMultiView)distance;
            BoofMiscOps.checkEq(dist.getNumberOfViews(), this.listIntrinsics.size(), "Must first call setModel()");
            for (int viewIdx = 0; viewIdx < this.listIntrinsics.size(); ++viewIdx) {
                CameraPinhole intrinscs = Objects.requireNonNull(this.listIntrinsics.get(viewIdx), "Must first specify intrinsics for each camera");
                dist.setIntrinsic(viewIdx, intrinscs);
            }
        });
    }

    @Override
    public void setIntrinsic(int view, CameraPinhole intrinsic) {
        if (this.listIntrinsics.size() == 0) {
            throw new IllegalArgumentException("You must call setModel() first");
        }
        this.listIntrinsics.set(view, intrinsic);
    }

    @Override
    public int getNumberOfViews() {
        return this.listIntrinsics.size();
    }

    @Override
    public boolean process(List<Point> list) {
        return this.fitter.process(list);
    }

    @Override
    public Model getModelParameters() {
        return this.fitter.getModelParameters();
    }

    @Override
    public List<Point> getMatchSet() {
        return this.fitter.getMatchSet();
    }

    @Override
    public int getInputIndex(int i) {
        return this.fitter.getInputIndex(i);
    }

    @Override
    public double getFitQuality() {
        return this.fitter.getFitQuality();
    }

    @Override
    public int getMinimumSize() {
        return this.fitter.getMinimumSize();
    }

    @Override
    public void reset() {
        this.fitter.reset();
    }

    @Override
    public Class<Point> getPointType() {
        return this.fitter.getPointType();
    }

    @Override
    public Class<Model> getModelType() {
        return this.fitter.getModelType();
    }

    @Override
    public void setModel(Factory<ModelGenerator<Model, Point>> factoryGenerator, Factory<DistanceFromModel<Model, Point>> factoryDistance) {
        int numViews = ((DistanceFromModelMultiView)factoryDistance.newInstance()).getNumberOfViews();
        this.listIntrinsics.clear();
        for (int i = 0; i < numViews; ++i) {
            this.listIntrinsics.add(null);
        }
        this.fitter.setModel(factoryGenerator, factoryDistance);
    }

    public LeastMedianOfSquares<Model, Point> getFitter() {
        return this.fitter;
    }
}

