/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.pose;

import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.so.Rodrigues_F64;
import org.ddogleg.fitting.modelset.ModelCodec;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;

public class PnPRodriguesCodec
implements ModelCodec<Se3_F64> {
    SingularValueDecomposition<DMatrixRMaj> svd = DecompositionFactory_DDRM.svd(3, 3, true, true, false);
    DMatrixRMaj R = new DMatrixRMaj(3, 3);
    Rodrigues_F64 rotation = new Rodrigues_F64();

    @Override
    public void decode(double[] input, Se3_F64 outputModel) {
        this.rotation.setParamVector(input[0], input[1], input[2]);
        ConvertRotation3D_F64.rodriguesToMatrix(this.rotation, outputModel.getR());
        Vector3D_F64 T = outputModel.getT();
        T.x = input[3];
        T.y = input[4];
        T.z = input[5];
    }

    @Override
    public void encode(Se3_F64 input, double[] output) {
        if (!this.svd.decompose(input.getR())) {
            throw new RuntimeException("SVD failed");
        }
        DMatrixRMaj U = this.svd.getU(null, false);
        DMatrixRMaj V = this.svd.getV(null, false);
        CommonOps_DDRM.multTransB(U, V, this.R);
        ConvertRotation3D_F64.matrixToRodrigues(this.R, this.rotation);
        output[0] = this.rotation.unitAxisRotation.x * this.rotation.theta;
        output[1] = this.rotation.unitAxisRotation.y * this.rotation.theta;
        output[2] = this.rotation.unitAxisRotation.z * this.rotation.theta;
        Vector3D_F64 T = input.getT();
        output[3] = T.x;
        output[4] = T.y;
        output[5] = T.z;
    }

    @Override
    public int getParamLength() {
        return 6;
    }
}

