/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.LowLevelMultiViewOps;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.f.FundamentalLinear;
import boofcv.struct.geo.AssociatedPair;
import java.util.List;
import org.ejml.data.DMatrixRMaj;

public class FundamentalLinear8
extends FundamentalLinear {
    public FundamentalLinear8(boolean computeFundamental) {
        super(computeFundamental);
    }

    public boolean process(List<AssociatedPair> points, DMatrixRMaj solution) {
        if (points.size() < 8) {
            throw new IllegalArgumentException("Must be at least 8 points. Was only " + points.size());
        }
        LowLevelMultiViewOps.computeNormalization(points, this.N1, this.N2);
        this.createA(points, this.A);
        if (this.process(this.A, solution)) {
            return false;
        }
        PerspectiveOps.multTranA(this.N2.matrix(null), solution, this.N1.matrix(null), solution);
        if (this.computeFundamental) {
            return this.projectOntoFundamentalSpace(solution);
        }
        return this.projectOntoEssential(solution);
    }

    protected boolean process(DMatrixRMaj A2, DMatrixRMaj F) {
        if (!this.solverNull.process(A2, 1, F)) {
            return true;
        }
        F.numRows = 3;
        F.numCols = 3;
        return false;
    }
}

