/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.f;

import boofcv.alg.geo.MassageSingularValues;
import boofcv.alg.geo.NormalizationPoint2D;
import boofcv.misc.BoofLambdas;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.linsol.svd.SolveNullSpaceSvd_DDRM;
import org.ejml.interfaces.SolveNullSpace;

public abstract class FundamentalLinear {
    protected DMatrixRMaj A = new DMatrixRMaj(1, 9);
    protected SolveNullSpace<DMatrixRMaj> solverNull = new SolveNullSpaceSvd_DDRM();
    protected MassageSingularValues massger = new MassageSingularValues();
    protected BoofLambdas.ProcessObject<DMatrixRMaj> opEssential;
    protected BoofLambdas.ProcessObject<DMatrixRMaj> opFundamental;
    protected NormalizationPoint2D N1 = new NormalizationPoint2D();
    protected NormalizationPoint2D N2 = new NormalizationPoint2D();
    boolean computeFundamental;

    protected FundamentalLinear(boolean computeFundamental) {
        this.computeFundamental = computeFundamental;
        this.opEssential = W -> {
            W.unsafe_set(0, 0, 1.0);
            W.unsafe_set(1, 1, 1.0);
            W.unsafe_set(2, 2, 0.0);
        };
        this.opFundamental = W -> W.set(2, 2, 0.0);
    }

    protected boolean projectOntoEssential(DMatrixRMaj E) {
        return this.massger.process(E, this.opEssential);
    }

    protected boolean projectOntoFundamentalSpace(DMatrixRMaj F) {
        return this.massger.process(F, this.opFundamental);
    }

    protected void createA(List<AssociatedPair> points, DMatrixRMaj A2) {
        A2.reshape(points.size(), 9, false);
        A2.zero();
        Point2D_F64 f_norm = new Point2D_F64();
        Point2D_F64 s_norm = new Point2D_F64();
        int size = points.size();
        for (int i = 0; i < size; ++i) {
            AssociatedPair p = points.get(i);
            Point2D_F64 f = p.p1;
            Point2D_F64 s = p.p2;
            this.N1.apply(f, f_norm);
            this.N2.apply(s, s_norm);
            A2.unsafe_set(i, 0, s_norm.x * f_norm.x);
            A2.unsafe_set(i, 1, s_norm.x * f_norm.y);
            A2.unsafe_set(i, 2, s_norm.x);
            A2.unsafe_set(i, 3, s_norm.y * f_norm.x);
            A2.unsafe_set(i, 4, s_norm.y * f_norm.y);
            A2.unsafe_set(i, 5, s_norm.y);
            A2.unsafe_set(i, 6, f_norm.x);
            A2.unsafe_set(i, 7, f_norm.y);
            A2.unsafe_set(i, 8, 1.0);
        }
    }

    public boolean isComputeFundamental() {
        return this.computeFundamental;
    }
}

