/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.geo.calibration.cameras;

import boofcv.abst.geo.bundle.BundleAdjustmentCamera;
import boofcv.alg.geo.bundle.BundleAdjustmentOps;
import boofcv.alg.geo.bundle.cameras.BundleKannalaBrandt;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.geo.calibration.cameras.Zhang99Camera;
import boofcv.struct.calib.CameraKannalaBrandt;
import boofcv.struct.calib.CameraModel;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ejml.data.DMatrixRMaj;

public class Zhang99CameraKannalaBrandt
implements Zhang99Camera {
    boolean assumeZeroSkew;
    int numSymmetric;
    int numAsymmetric;

    public Zhang99CameraKannalaBrandt(boolean assumeZeroSkew, int numSymmetric, int numAsymmetric) {
        this.assumeZeroSkew = assumeZeroSkew;
        this.numSymmetric = numSymmetric;
        this.numAsymmetric = numAsymmetric;
    }

    @Override
    public void setLayout(List<Point2D_F64> layout) {
    }

    @Override
    public BundleAdjustmentCamera initializeCamera(DMatrixRMaj K, List<DMatrixRMaj> homographies, List<CalibrationObservation> observations) {
        BundleKannalaBrandt ret = new BundleKannalaBrandt();
        ret.configure(this.assumeZeroSkew, this.numSymmetric, this.numAsymmetric);
        ret.model.fsetK(K);
        for (int i = 0; i < this.numAsymmetric; ++i) {
            ret.model.radial[i] = i % 2 == 0 ? 0.005 : -0.005;
            ret.model.tangent[i] = i % 2 == 0 ? 0.005 : -0.005;
        }
        return ret;
    }

    @Override
    public CameraModel getCameraModel(BundleAdjustmentCamera bundleCam) {
        BundleKannalaBrandt cam = (BundleKannalaBrandt)bundleCam;
        return BundleAdjustmentOps.convert(cam, 0, 0, (CameraKannalaBrandt)null);
    }
}

