/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.flow;

import boofcv.alg.flow.UtilDenseOpticalFlow;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.misc.GImageStatistics;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import boofcv.struct.pyramid.ImagePyramid;
import boofcv.struct.pyramid.PyramidFloat;

public abstract class DenseFlowPyramidBase<T extends ImageGray<T>> {
    private final GrayF32 norm1 = new GrayF32(1, 1);
    private final GrayF32 norm2 = new GrayF32(1, 1);
    private final double scale;
    private final double sigma;
    private final int maxLayers;
    protected PyramidFloat<GrayF32> pyr1;
    protected PyramidFloat<GrayF32> pyr2;
    protected InterpolatePixelS<GrayF32> interp;

    protected DenseFlowPyramidBase(double scale, double sigma, int maxLayers, InterpolatePixelS<GrayF32> interp) {
        this.scale = scale;
        this.sigma = sigma;
        this.maxLayers = maxLayers;
        this.interp = interp;
        interp.setBorder((ImageBorder<GrayF32>)FactoryImageBorder.single(BorderType.EXTENDED, GrayF32.class));
    }

    public void process(T image1, T image2) {
        if (this.pyr1 == null || this.pyr1.getInputWidth() != ((ImageGray)image1).width || this.pyr1.getInputHeight() != ((ImageGray)image1).height) {
            this.pyr1 = UtilDenseOpticalFlow.standardPyramid(((ImageGray)image1).width, ((ImageGray)image1).height, this.scale, this.sigma, 5, this.maxLayers, GrayF32.class);
            this.pyr2 = UtilDenseOpticalFlow.standardPyramid(((ImageGray)image1).width, ((ImageGray)image1).height, this.scale, this.sigma, 5, this.maxLayers, GrayF32.class);
            this.pyr1.initialize(((ImageGray)image1).width, ((ImageGray)image1).height);
            this.pyr2.initialize(((ImageGray)image1).width, ((ImageGray)image1).height);
        }
        this.norm1.reshape(((ImageGray)image1).width, ((ImageGray)image1).height);
        this.norm2.reshape(((ImageGray)image1).width, ((ImageGray)image1).height);
        DenseFlowPyramidBase.imageNormalization(image1, image2, this.norm1, this.norm2);
        this.pyr1.process(this.norm1);
        this.pyr2.process(this.norm2);
        this.process((ImagePyramid<GrayF32>)this.pyr1, (ImagePyramid<GrayF32>)this.pyr2);
    }

    protected void interpolateFlowScale(GrayF32 prev, GrayF32 curr) {
        this.interp.setImage(prev);
        float scaleX = (float)prev.width / (float)curr.width;
        float scaleY = (float)prev.height / (float)curr.height;
        float scale = (float)prev.width / (float)curr.width;
        int indexCurr = 0;
        for (int y = 0; y < curr.height; ++y) {
            float yy = (float)y * scaleY;
            for (int x = 0; x < curr.width; ++x) {
                float xx = (float)x * scaleX;
                curr.data[indexCurr++] = this.interp.isInFastBounds(xx, yy) ? this.interp.get_fast((float)x * scaleX, (float)y * scaleY) / scale : this.interp.get((float)x * scaleX, (float)y * scaleY) / scale;
            }
        }
    }

    protected void warpImageTaylor(GrayF32 before, GrayF32 flowX, GrayF32 flowY, GrayF32 after) {
        this.interp.setBorder((ImageBorder<GrayF32>)FactoryImageBorder.single(BorderType.EXTENDED, before.getImageType().getImageClass()));
        this.interp.setImage(before);
        for (int y = 0; y < before.height; ++y) {
            int pixelIndex = y * before.width;
            int x = 0;
            while (x < before.width) {
                float u = flowX.data[pixelIndex];
                float v = flowY.data[pixelIndex];
                float wx = (float)x + u;
                float wy = (float)y + v;
                after.data[pixelIndex] = this.interp.get(wx, wy);
                ++x;
                ++pixelIndex;
            }
        }
    }

    public abstract void process(ImagePyramid<GrayF32> var1, ImagePyramid<GrayF32> var2);

    protected static <T extends ImageGray<T>> void imageNormalization(T image1, T image2, GrayF32 normalized1, GrayF32 normalized2) {
        float min2;
        float min1;
        float min;
        float max2;
        float max1 = (float)GImageStatistics.max(image1);
        float max = max1 > (max2 = (float)GImageStatistics.max(image2)) ? max1 : max2;
        float range = max - (min = (min1 = (float)GImageStatistics.min(image1)) < (min2 = (float)GImageStatistics.min(image2)) ? min1 : min2);
        if (range > 0.0f) {
            int indexN = 0;
            for (int y = 0; y < image1.height; ++y) {
                int x = 0;
                while (x < image1.width) {
                    float pv1 = (float)GeneralizedImageOps.get(image1, x, y);
                    float pv2 = (float)GeneralizedImageOps.get(image2, x, y);
                    normalized1.data[indexN] = (pv1 - min) / range;
                    normalized2.data[indexN] = (pv2 - min) / range;
                    ++x;
                    ++indexN;
                }
            }
        } else {
            GConvertImage.convert(image1, normalized1);
            GConvertImage.convert(image2, normalized2);
        }
    }
}

