/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.filter.derivative.DerivativeLaplacian;
import boofcv.alg.filter.derivative.DerivativeType;
import boofcv.alg.filter.derivative.GradientPrewitt;
import boofcv.alg.filter.derivative.GradientScharr;
import boofcv.alg.filter.derivative.GradientSobel;
import boofcv.alg.filter.derivative.GradientThree;
import boofcv.alg.filter.derivative.GradientTwo0;
import boofcv.alg.filter.derivative.GradientTwo1;
import boofcv.alg.filter.derivative.HessianFromGradient;
import boofcv.alg.filter.derivative.HessianSobel;
import boofcv.alg.filter.derivative.HessianThree;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderIndex1D_Extend;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.border.ImageBorder1D_F32;
import boofcv.struct.border.ImageBorder1D_S32;
import boofcv.struct.border.ImageBorder_F32;
import boofcv.struct.border.ImageBorder_S32;
import boofcv.struct.convolve.Kernel1D;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.KernelBase;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;

public class GImageDerivativeOps {
    public static <I extends ImageGray<I>, D extends ImageGray<D>> void laplace(I input, D output, BorderType borderType) {
        ImageBorder<I> border;
        ImageBorder<I> imageBorder = border = BorderType.SKIP == borderType ? null : FactoryImageBorder.wrap(borderType, input);
        if (input instanceof GrayF32) {
            DerivativeLaplacian.process((GrayF32)input, (GrayF32)output, (ImageBorder_F32)border);
        } else if (input instanceof GrayU8) {
            DerivativeLaplacian.process((GrayU8)input, (GrayS16)output, (ImageBorder_S32)border);
        } else {
            throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
        }
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> Class<D> getDerivativeType(Class<I> imageType) {
        if (imageType == GrayF32.class) {
            return GrayF32.class;
        }
        if (imageType == GrayU8.class) {
            return GrayS16.class;
        }
        if (imageType == GrayU16.class) {
            return GrayS32.class;
        }
        throw new IllegalArgumentException("Unknown input image type: " + imageType.getSimpleName());
    }

    public static <I extends ImageBase<I>, D extends ImageBase<D>> ImageType<D> getDerivativeType(ImageType<I> imageType) {
        switch (imageType.getFamily()) {
            case GRAY: {
                return ImageType.single(GImageDerivativeOps.getDerivativeType(imageType.getImageClass()));
            }
            case PLANAR: {
                int numBands = imageType.getNumBands();
                return ImageType.pl(numBands, GImageDerivativeOps.getDerivativeType(imageType.getImageClass()));
            }
            case INTERLEAVED: {
                ImageType imageType2;
                int numBands = imageType.getNumBands();
                switch (imageType.getDataType()) {
                    case F32: {
                        imageType2 = ImageType.il(numBands, ImageDataType.F32);
                        break;
                    }
                    case F64: {
                        imageType2 = ImageType.il(numBands, ImageDataType.F64);
                        break;
                    }
                    case U8: {
                        imageType2 = ImageType.il(numBands, ImageDataType.S16);
                        break;
                    }
                    case U16: {
                        imageType2 = ImageType.il(numBands, ImageDataType.S32);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown image type");
                    }
                }
                return imageType2;
            }
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> void gradient(DerivativeType type, I input, D derivX, D derivY, BorderType borderType) {
        ImageBorder<I> border = BorderType.SKIP == borderType ? null : FactoryImageBorder.wrap(borderType, input);
        switch (type) {
            case PREWITT: {
                if (input instanceof GrayF32) {
                    GradientPrewitt.process((GrayF32)input, (GrayF32)derivX, (GrayF32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    GradientPrewitt.process((GrayU8)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    GradientPrewitt.process((GrayS16)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case SOBEL: {
                if (input instanceof GrayF32) {
                    GradientSobel.process((GrayF32)input, (GrayF32)derivX, (GrayF32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    GradientSobel.process((GrayU8)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    GradientSobel.process((GrayS16)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case SCHARR: {
                if (input instanceof GrayF32) {
                    GradientScharr.process((GrayF32)input, (GrayF32)derivX, (GrayF32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    GradientScharr.process((GrayU8)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    GradientScharr.process((GrayS16)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case THREE: {
                if (input instanceof GrayF32) {
                    GradientThree.process((GrayF32)input, (GrayF32)derivX, (GrayF32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    GradientThree.process((GrayU8)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    GradientThree.process((GrayS16)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case TWO_0: {
                if (input instanceof GrayF32) {
                    GradientTwo0.process((GrayF32)input, (GrayF32)derivX, (GrayF32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    GradientTwo0.process((GrayU8)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    GradientTwo0.process((GrayS16)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case TWO_1: {
                if (input instanceof GrayF32) {
                    GradientTwo1.process((GrayF32)input, (GrayF32)derivX, (GrayF32)derivY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    GradientTwo1.process((GrayU8)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                if (input instanceof GrayS16) {
                    GradientTwo1.process((GrayS16)input, (GrayS16)derivX, (GrayS16)derivY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unknown type: " + type);
            }
        }
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> void hessian(DerivativeType type, I input, D derivXX, D derivYY, D derivXY, BorderType borderType) {
        ImageBorder<I> border = BorderType.SKIP == borderType ? null : FactoryImageBorder.wrap(borderType, input);
        switch (type) {
            case SOBEL: {
                if (input instanceof GrayF32) {
                    HessianSobel.process((GrayF32)input, (GrayF32)derivXX, (GrayF32)derivYY, (GrayF32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    HessianSobel.process((GrayU8)input, (GrayS16)derivXX, (GrayS16)derivYY, (GrayS16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            case THREE: {
                if (input instanceof GrayF32) {
                    HessianThree.process((GrayF32)input, (GrayF32)derivXX, (GrayF32)derivYY, (GrayF32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (input instanceof GrayU8) {
                    HessianThree.process((GrayU8)input, (GrayS16)derivXX, (GrayS16)derivYY, (GrayS16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unsupported derivative type " + type);
            }
        }
    }

    public static <D extends ImageGray<D>> void hessian(DerivativeType type, D derivX, D derivY, D derivXX, D derivYY, D derivXY, BorderType borderType) {
        ImageBorder<D> border = BorderType.SKIP == borderType ? null : FactoryImageBorder.wrap(borderType, derivX);
        switch (type) {
            case PREWITT: {
                if (derivX instanceof GrayF32) {
                    HessianFromGradient.hessianPrewitt((GrayF32)derivX, (GrayF32)derivY, (GrayF32)derivXX, (GrayF32)derivYY, (GrayF32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (derivX instanceof GrayS16) {
                    HessianFromGradient.hessianPrewitt((GrayS16)derivX, (GrayS16)derivY, (GrayS16)derivXX, (GrayS16)derivYY, (GrayS16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + derivX.getClass().getSimpleName());
            }
            case SOBEL: {
                if (derivX instanceof GrayF32) {
                    HessianFromGradient.hessianSobel((GrayF32)derivX, (GrayF32)derivY, (GrayF32)derivXX, (GrayF32)derivYY, (GrayF32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (derivX instanceof GrayS16) {
                    HessianFromGradient.hessianSobel((GrayS16)derivX, (GrayS16)derivY, (GrayS16)derivXX, (GrayS16)derivYY, (GrayS16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + derivX.getClass().getSimpleName());
            }
            case THREE: {
                if (derivX instanceof GrayF32) {
                    HessianFromGradient.hessianThree((GrayF32)derivX, (GrayF32)derivY, (GrayF32)derivXX, (GrayF32)derivYY, (GrayF32)derivXY, (ImageBorder_F32)border);
                    break;
                }
                if (derivX instanceof GrayS16) {
                    HessianFromGradient.hessianThree((GrayS16)derivX, (GrayS16)derivY, (GrayS16)derivXX, (GrayS16)derivYY, (GrayS16)derivXY, (ImageBorder_S32)border);
                    break;
                }
                throw new IllegalArgumentException("Unknown input image type: " + derivX.getClass().getSimpleName());
            }
            default: {
                throw new IllegalArgumentException("Unsupported derivative type " + type);
            }
        }
    }

    public static KernelBase lookupKernelX(DerivativeType type, boolean isInteger) {
        KernelBase kernelBase;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case PREWITT: {
                kernelBase = GradientPrewitt.getKernelX(isInteger);
                break;
            }
            case SOBEL: {
                kernelBase = GradientSobel.getKernelX(isInteger);
                break;
            }
            case SCHARR: {
                kernelBase = GradientScharr.getKernelX(isInteger);
                break;
            }
            case THREE: {
                kernelBase = GradientThree.getKernelX(isInteger);
                break;
            }
            case TWO_0: {
                kernelBase = GradientTwo0.getKernelX(isInteger);
                break;
            }
            case TWO_1: {
                kernelBase = GradientTwo1.getKernelX(isInteger);
            }
        }
        return kernelBase;
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> AnyImageDerivative<I, D> createAnyDerivatives(DerivativeType type, Class<I> inputType, Class<D> derivType) {
        boolean isInteger = !GeneralizedImageOps.isFloatingPoint(inputType);
        KernelBase kernel = GImageDerivativeOps.lookupKernelX(type, isInteger);
        if (kernel instanceof Kernel1D) {
            return new AnyImageDerivative<I, D>((Kernel1D)kernel, inputType, derivType);
        }
        return new AnyImageDerivative<I, D>((Kernel2D)kernel, inputType, derivType);
    }

    public static <I extends ImageGray<I>, D extends ImageGray<D>> AnyImageDerivative<I, D> derivativeForScaleSpace(Class<I> inputType, Class<D> derivType) {
        return GImageDerivativeOps.createAnyDerivatives(DerivativeType.THREE, inputType, derivType);
    }

    public static ImageBorder_S32 borderDerivative_I32() {
        return new ImageBorder1D_S32(BorderIndex1D_Extend::new);
    }

    public static ImageBorder_F32 borderDerivative_F32() {
        return new ImageBorder1D_F32(BorderIndex1D_Extend::new);
    }
}

