/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve;

import boofcv.alg.filter.convolve.ConvolveImageDownNoBorder;
import boofcv.alg.filter.convolve.down.ConvolveDownNormalizedNaive;
import boofcv.alg.filter.convolve.down.ConvolveDownNormalized_JustBorder;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_S32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.convolve.Kernel2D_S32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;

public class ConvolveImageDownNormalized {
    public static void horizontal(Kernel1D_F32 kernel, GrayF32 image, GrayF32 dest, int skip) {
        ConvolveImageDownNoBorder.checkParameters(image, dest, skip);
        if (kernel.width >= image.width) {
            ConvolveDownNormalizedNaive.horizontal(kernel, image, dest, skip);
        } else {
            ConvolveImageDownNoBorder.horizontal(kernel, image, dest, skip);
            ConvolveDownNormalized_JustBorder.horizontal(kernel, image, dest, skip);
        }
    }

    public static void vertical(Kernel1D_F32 kernel, GrayF32 image, GrayF32 dest, int skip) {
        ConvolveImageDownNoBorder.checkParameters(image, dest, skip);
        if (kernel.width >= image.width) {
            ConvolveDownNormalizedNaive.vertical(kernel, image, dest, skip);
        } else {
            ConvolveImageDownNoBorder.vertical(kernel, image, dest, skip);
            ConvolveDownNormalized_JustBorder.vertical(kernel, image, dest, skip);
        }
    }

    public static void convolve(Kernel2D_F32 kernel, GrayF32 image, GrayF32 dest, int skip) {
        ConvolveImageDownNoBorder.checkParameters(image, dest, skip);
        if (kernel.width >= image.width) {
            ConvolveDownNormalizedNaive.convolve(kernel, image, dest, skip);
        } else {
            ConvolveImageDownNoBorder.convolve(kernel, image, dest, skip);
            ConvolveDownNormalized_JustBorder.convolve(kernel, image, dest, skip);
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayU8 image, GrayI8 dest, int skip) {
        ConvolveImageDownNoBorder.checkParameters(image, dest, skip);
        if (kernel.width >= image.width) {
            ConvolveDownNormalizedNaive.horizontal(kernel, image, dest, skip);
        } else {
            ConvolveImageDownNoBorder.horizontal(kernel, image, dest, skip, kernel.computeSum());
            ConvolveDownNormalized_JustBorder.horizontal(kernel, image, dest, skip);
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayU8 image, GrayI8 dest, int skip) {
        ConvolveImageDownNoBorder.checkParameters(image, dest, skip);
        if (kernel.width >= image.width) {
            ConvolveDownNormalizedNaive.vertical(kernel, image, dest, skip);
        } else {
            ConvolveImageDownNoBorder.vertical(kernel, image, dest, skip, kernel.computeSum());
            ConvolveDownNormalized_JustBorder.vertical(kernel, image, dest, skip);
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayU8 image, GrayI8 dest, int skip) {
        ConvolveImageDownNoBorder.checkParameters(image, dest, skip);
        if (kernel.width >= image.width) {
            ConvolveDownNormalizedNaive.convolve(kernel, image, dest, skip);
        } else {
            ConvolveImageDownNoBorder.convolve(kernel, image, dest, skip, kernel.computeSum());
            ConvolveDownNormalized_JustBorder.convolve(kernel, image, dest, skip);
        }
    }

    public static void horizontal(Kernel1D_S32 kernel, GrayS16 image, GrayI16 dest, int skip) {
        ConvolveImageDownNoBorder.checkParameters(image, dest, skip);
        if (kernel.width >= image.width) {
            ConvolveDownNormalizedNaive.horizontal(kernel, image, dest, skip);
        } else {
            ConvolveImageDownNoBorder.horizontal(kernel, image, dest, skip, kernel.computeSum());
            ConvolveDownNormalized_JustBorder.horizontal(kernel, image, dest, skip);
        }
    }

    public static void vertical(Kernel1D_S32 kernel, GrayS16 image, GrayI16 dest, int skip) {
        ConvolveImageDownNoBorder.checkParameters(image, dest, skip);
        if (kernel.width >= image.width) {
            ConvolveDownNormalizedNaive.vertical(kernel, image, dest, skip);
        } else {
            ConvolveImageDownNoBorder.vertical(kernel, image, dest, skip, kernel.computeSum());
            ConvolveDownNormalized_JustBorder.vertical(kernel, image, dest, skip);
        }
    }

    public static void convolve(Kernel2D_S32 kernel, GrayS16 image, GrayI16 dest, int skip) {
        ConvolveImageDownNoBorder.checkParameters(image, dest, skip);
        if (kernel.width >= image.width) {
            ConvolveDownNormalizedNaive.convolve(kernel, image, dest, skip);
        } else {
            ConvolveImageDownNoBorder.convolve(kernel, image, dest, skip, kernel.computeSum());
            ConvolveDownNormalized_JustBorder.convolve(kernel, image, dest, skip);
        }
    }
}

