/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur.impl;

import boofcv.concurrency.BoofConcurrency;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.image.GrayU8;
import java.util.Arrays;
import org.ddogleg.struct.DogArray_I32;
import pabeles.concurrency.GrowArray;

public class ImplMedianHistogramInner_MT {
    public static void process(GrayU8 input, GrayU8 output, int radiusX, int radiusY, GrowArray<DogArray_I32> work) {
        int w = 2 * radiusX + 1;
        int h = 2 * radiusY + 1;
        if (input.width < w || input.height < h) {
            return;
        }
        int threshold = w * h / 2 + 1;
        BoofConcurrency.loopBlocks(radiusY, output.height - radiusY, h, work, (array, y0, y1) -> {
            int[] histogram = BoofMiscOps.checkDeclare(array, 256, false);
            for (int y = y0; y < y1; ++y) {
                int seed = input.startIndex + (y - radiusY) * input.stride;
                Arrays.fill(histogram, 0);
                for (int yi = 0; yi < h; ++yi) {
                    int idx = seed + yi * input.stride;
                    int end = idx + w;
                    while (idx < end) {
                        int n = input.data[idx++] & 0xFF;
                        histogram[n] = histogram[n] + 1;
                    }
                }
                int count = 0;
                int median = 0;
                while ((count += histogram[median]) < threshold) {
                    ++median;
                }
                output.data[output.startIndex + y * output.stride + radiusX] = (byte)median;
                count += ImplMedianHistogramInner_MT.removeSide(input.data, input.stride, h, histogram, seed, median);
                for (int x = radiusX + 1; x < input.width - radiusX; ++x) {
                    seed = input.startIndex + (y - radiusY) * input.stride + (x - radiusX);
                    if ((count += ImplMedianHistogramInner_MT.addSide(input.data, input.stride, h, histogram, seed + w - 1, median)) >= threshold) {
                        while (count >= threshold) {
                            count -= histogram[median--];
                        }
                        count += histogram[++median];
                    } else {
                        while (count < threshold) {
                            count += histogram[++median];
                        }
                    }
                    output.data[output.startIndex + y * output.stride + x] = (byte)median;
                    count += ImplMedianHistogramInner_MT.removeSide(input.data, input.stride, h, histogram, seed, median);
                }
            }
        });
    }

    private static int removeSide(byte[] data, int stride, int height, int[] histogram, int seedIdx, int oldMedian) {
        int count = 0;
        int i = 0;
        while (i < height) {
            int value;
            int n = value = data[seedIdx] & 0xFF;
            histogram[n] = histogram[n] - 1;
            if (value <= oldMedian) {
                --count;
            }
            ++i;
            seedIdx += stride;
        }
        return count;
    }

    private static int addSide(byte[] data, int stride, int height, int[] histogram, int seedIdx, int oldValue) {
        int count = 0;
        int i = 0;
        while (i < height) {
            int value;
            int n = value = data[seedIdx] & 0xFF;
            histogram[n] = histogram[n] + 1;
            if (value <= oldValue) {
                ++count;
            }
            ++i;
            seedIdx += stride;
        }
        return count;
    }
}

