/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.square;

import boofcv.alg.fiducial.square.QuadPoseEstimator;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se3_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import georegression.struct.so.Rodrigues_F64;
import org.ddogleg.struct.DogArray;

public class StabilitySquareFiducialEstimate {
    private final QuadPoseEstimator estimator;
    private final Quadrilateral_F64 work = new Quadrilateral_F64();
    private final Se3_F64 referenceCameraToWorld = new Se3_F64();
    private final Se3_F64 difference = new Se3_F64();
    private final DogArray<Se3_F64> samples = new DogArray<Se3_F64>(Se3_F64::new);
    private final Rodrigues_F64 rodrigues = new Rodrigues_F64();
    private double maxLocation;
    private double maxOrientation;

    public StabilitySquareFiducialEstimate(QuadPoseEstimator estimator) {
        this.estimator = estimator;
    }

    public boolean process(double sampleRadius, Quadrilateral_F64 input) {
        this.work.setTo(input);
        this.samples.reset();
        this.estimator.process(this.work, false);
        this.estimator.getWorldToCamera().invert(this.referenceCameraToWorld);
        this.samples.reset();
        this.createSamples(sampleRadius, this.work.a, input.a);
        this.createSamples(sampleRadius, this.work.b, input.b);
        this.createSamples(sampleRadius, this.work.c, input.c);
        this.createSamples(sampleRadius, this.work.d, input.d);
        if (this.samples.size() < 10) {
            return false;
        }
        this.maxLocation = 0.0;
        this.maxOrientation = 0.0;
        for (int i = 0; i < this.samples.size(); ++i) {
            this.referenceCameraToWorld.concat((Se3_F64)this.samples.get(i), this.difference);
            ConvertRotation3D_F64.matrixToRodrigues(this.difference.getR(), this.rodrigues);
            double theta = Math.abs(this.rodrigues.theta);
            double d = this.difference.getT().norm();
            if (theta > this.maxOrientation) {
                this.maxOrientation = theta;
            }
            if (!(d > this.maxLocation)) continue;
            this.maxLocation = d;
        }
        return true;
    }

    private void createSamples(double sampleRadius, Point2D_F64 workPoint, Point2D_F64 originalPoint) {
        workPoint.x = originalPoint.x + sampleRadius;
        if (this.estimator.process(this.work, false)) {
            this.samples.grow().setTo(this.estimator.getWorldToCamera());
        }
        workPoint.x = originalPoint.x - sampleRadius;
        if (this.estimator.process(this.work, false)) {
            this.samples.grow().setTo(this.estimator.getWorldToCamera());
        }
        workPoint.x = originalPoint.x;
        workPoint.y = originalPoint.y + sampleRadius;
        if (this.estimator.process(this.work, false)) {
            this.samples.grow().setTo(this.estimator.getWorldToCamera());
        }
        workPoint.y = originalPoint.y - sampleRadius;
        if (this.estimator.process(this.work, false)) {
            this.samples.grow().setTo(this.estimator.getWorldToCamera());
        }
        workPoint.setTo(originalPoint);
    }

    public double getLocationStability() {
        return this.maxLocation;
    }

    public double getOrientationStability() {
        return this.maxOrientation;
    }
}

