/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.descriptor.DescriptorDistance;
import boofcv.alg.fiducial.qrcode.QrCode;
import boofcv.alg.fiducial.qrcode.QrCodeMaskPattern;

public class QrCodePolynomialMath {
    public static final int FORMAT_GENERATOR = 1335;
    public static final int VERSION_GENERATOR = 7973;

    public static int encodeVersionBits(int version) {
        int message = version << 12;
        return message ^ QrCodePolynomialMath.bitPolyModulus(message, 7973, 18, 6);
    }

    public static boolean checkVersionBits(int bits) {
        return QrCodePolynomialMath.bitPolyModulus(bits, 7973, 18, 6) == 0;
    }

    public static int correctVersionBits(int bits) {
        return QrCodePolynomialMath.correctDCH(64, bits, 7973, 18, 6);
    }

    public static int encodeFormatBits(QrCode.ErrorLevel level, int mask) {
        return QrCodePolynomialMath.encodeFormatBits(level.value << 3 | mask & 0xFFFFFFF7);
    }

    public static int encodeFormatBits(int message5bits) {
        int message = message5bits << 10;
        return message ^ QrCodePolynomialMath.bitPolyModulus(message, 1335, 15, 5);
    }

    public static boolean checkFormatBits(int bitsNoMask) {
        return QrCodePolynomialMath.bitPolyModulus(bitsNoMask, 1335, 15, 5) == 0;
    }

    public static void decodeFormatMessage(int message, QrCode qr) {
        int error = message >> 3;
        qr.error = QrCode.ErrorLevel.lookup(error);
        qr.mask = QrCodeMaskPattern.lookupMask(message & 7);
    }

    public static int correctFormatBits(int bitsNoMask) {
        return QrCodePolynomialMath.correctDCH(32, bitsNoMask, 1335, 15, 5);
    }

    public static int correctDCH(int N, int messageNoMask, int generator, int totalBits, int dataBits) {
        int bestHamming = 255;
        int bestMessage = -1;
        int errorBits = totalBits - dataBits;
        for (int i = 0; i < N; ++i) {
            int distance;
            int test = i << errorBits;
            if ((distance = DescriptorDistance.hamming((test ^= QrCodePolynomialMath.bitPolyModulus(test, generator, totalBits, dataBits)) ^ messageNoMask)) < bestHamming) {
                bestHamming = distance;
                bestMessage = i;
                continue;
            }
            if (distance != bestHamming) continue;
            bestMessage = -1;
        }
        return bestMessage;
    }

    public static int bitPolyModulus(int data, int generator, int totalBits, int dataBits) {
        int errorBits = totalBits - dataBits;
        for (int i = dataBits - 1; i >= 0; --i) {
            if ((data & 1 << i + errorBits) == 0) continue;
            data ^= generator << i;
        }
        return data;
    }
}

