/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.microqr.MicroQrCode;
import boofcv.alg.fiducial.qrcode.QrCode;
import georegression.struct.point.Point2D_I32;
import java.util.ArrayList;
import java.util.List;
import org.ejml.data.BMatrixRMaj;

public class QrCodeCodeWordLocations
extends BMatrixRMaj {
    public List<Point2D_I32> bits = new ArrayList<Point2D_I32>();

    public static QrCodeCodeWordLocations qrcode(int version) {
        int numModules = QrCode.totalModules(version);
        int[] alignment = QrCode.VERSION_INFO[version].alignment;
        boolean hasVersion = version >= 7;
        QrCodeCodeWordLocations locations = new QrCodeCodeWordLocations(numModules);
        locations.featureMaskQrCode(numModules, alignment, hasVersion);
        locations.computeBitLocations(false);
        return locations;
    }

    public static QrCodeCodeWordLocations microqr(int version) {
        int numModules = MicroQrCode.totalModules(version);
        QrCodeCodeWordLocations locations = new QrCodeCodeWordLocations(numModules);
        locations.featureMaskMicroQr(numModules);
        locations.computeBitLocations(true);
        return locations;
    }

    private QrCodeCodeWordLocations(int numModules) {
        super(numModules, numModules);
    }

    private void featureMaskQrCode(int numModules, int[] alignment, boolean hasVersion) {
        this.markSquare(0, 0, 9);
        this.markRectangle(numModules - 8, 0, 9, 8);
        this.markRectangle(0, numModules - 8, 8, 9);
        this.markRectangle(8, 6, 1, numModules - 8 - 8);
        this.markRectangle(6, 8, numModules - 8 - 8, 1);
        if (hasVersion) {
            this.markRectangle(numModules - 11, 0, 6, 3);
            this.markRectangle(0, numModules - 11, 3, 6);
        }
        for (int i = 0; i < alignment.length; ++i) {
            int row = alignment[i];
            for (int j = 0; j < alignment.length; ++j) {
                if (i == 0 && j == 0 || i == alignment.length - 1 && j == 0 || i == 0 && j == alignment.length - 1) continue;
                int col = alignment[j];
                this.markSquare(row - 2, col - 2, 5);
            }
        }
    }

    private void featureMaskMicroQr(int numModules) {
        this.markSquare(0, 0, 9);
        this.markRectangle(8, 0, 1, numModules - 8);
        this.markRectangle(0, 8, numModules - 8, 1);
    }

    private void markSquare(int row, int col, int width) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < width; ++j) {
                this.set(row + i, col + j, true);
            }
        }
    }

    private void markRectangle(int row, int col, int width, int height) {
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                this.set(row + i, col + j, true);
            }
        }
    }

    private void computeBitLocations(boolean isMicro) {
        int N = this.numRows;
        int row = N - 1;
        int col = N - 1;
        int direction = -1;
        while (col > 0) {
            if (col == 6 && !isMicro) {
                --col;
            }
            if (!this.get(row, col)) {
                this.bits.add(new Point2D_I32(col, row));
            }
            if (!this.get(row, col - 1)) {
                this.bits.add(new Point2D_I32(col - 1, row));
            }
            if ((row += direction) >= 0 && row < N) continue;
            direction = -direction;
            col -= 2;
            row += direction;
        }
    }

    public int getTotalDataBits() {
        return this.numRows * this.numRows - this.sum();
    }
}

