/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.qrcode;

import boofcv.alg.fiducial.qrcode.GaliosFieldTableOps;
import org.ddogleg.struct.DogArray_I8;

public class GaliosFieldTableOps_U8
extends GaliosFieldTableOps {
    public GaliosFieldTableOps_U8(int numBits, int primitive) {
        super(numBits, primitive);
    }

    public void polyScale(DogArray_I8 input, int scale, DogArray_I8 output) {
        output.resize(input.size);
        for (int i = 0; i < input.size; ++i) {
            output.data[i] = (byte)this.multiply(input.data[i] & 0xFF, scale);
        }
    }

    public void polyAdd(DogArray_I8 polyA, DogArray_I8 polyB, DogArray_I8 output) {
        int i;
        output.resize(Math.max(polyA.size, polyB.size));
        int offsetA = Math.max(0, polyB.size - polyA.size);
        int offsetB = Math.max(0, polyA.size - polyB.size);
        int N = output.size;
        for (i = 0; i < offsetB; ++i) {
            output.data[i] = polyA.data[i];
        }
        for (i = 0; i < offsetA; ++i) {
            output.data[i] = polyB.data[i];
        }
        for (i = Math.max(offsetA, offsetB); i < N; ++i) {
            output.data[i] = (byte)(polyA.data[i - offsetA] & 0xFF ^ polyB.data[i - offsetB] & 0xFF);
        }
    }

    public void polyAdd_S(DogArray_I8 polyA, DogArray_I8 polyB, DogArray_I8 output) {
        int M;
        int i;
        output.resize(Math.max(polyA.size, polyB.size));
        for (i = M = Math.min(polyA.size, polyB.size); i < polyA.size; ++i) {
            output.data[i] = polyA.data[i];
        }
        for (i = M; i < polyB.size; ++i) {
            output.data[i] = polyB.data[i];
        }
        for (i = 0; i < M; ++i) {
            output.data[i] = (byte)(polyA.data[i] & 0xFF ^ polyB.data[i] & 0xFF);
        }
    }

    public void polyAddScaleB(DogArray_I8 polyA, DogArray_I8 polyB, int scaleB, DogArray_I8 output) {
        int i;
        output.resize(Math.max(polyA.size, polyB.size));
        int offsetA = Math.max(0, polyB.size - polyA.size);
        int offsetB = Math.max(0, polyA.size - polyB.size);
        int N = output.size;
        for (i = 0; i < offsetB; ++i) {
            output.data[i] = polyA.data[i];
        }
        for (i = 0; i < offsetA; ++i) {
            output.data[i] = (byte)this.multiply(polyB.data[i] & 0xFF, scaleB);
        }
        for (i = Math.max(offsetA, offsetB); i < N; ++i) {
            output.data[i] = (byte)(polyA.data[i - offsetA] & 0xFF ^ this.multiply(polyB.data[i - offsetB] & 0xFF, scaleB));
        }
    }

    public void polyMult(DogArray_I8 polyA, DogArray_I8 polyB, DogArray_I8 output) {
        output.resize(polyA.size + polyB.size - 1);
        output.zero();
        for (int j = 0; j < polyB.size; ++j) {
            int vb = polyB.data[j] & 0xFF;
            for (int i = 0; i < polyA.size; ++i) {
                int va = polyA.data[i] & 0xFF;
                int n = i + j;
                output.data[n] = (byte)(output.data[n] ^ (byte)this.multiply(va, vb));
            }
        }
    }

    public void polyMult_flipA(DogArray_I8 polyA, DogArray_I8 polyB, DogArray_I8 output) {
        output.resize(polyA.size + polyB.size - 1);
        output.zero();
        for (int j = 0; j < polyB.size; ++j) {
            int vb = polyB.data[j] & 0xFF;
            for (int i = 0; i < polyA.size; ++i) {
                int va = polyA.data[polyA.size - i - 1] & 0xFF;
                int n = i + j;
                output.data[n] = (byte)(output.data[n] ^ (byte)this.multiply(va, vb));
            }
        }
    }

    public void polyMult_S(DogArray_I8 polyA, DogArray_I8 polyB, DogArray_I8 output) {
        output.resize(polyA.size + polyB.size - 1);
        output.zero();
        for (int j = polyB.size - 1; j >= 0; --j) {
            int vb = polyB.data[j] & 0xFF;
            for (int i = polyA.size - 1; i >= 0; --i) {
                int va = polyA.data[i] & 0xFF;
                int n = i + j;
                output.data[n] = (byte)(output.data[n] ^ (byte)this.multiply(va, vb));
            }
        }
    }

    public int polyEval(DogArray_I8 input, int x) {
        int y = input.data[0] & 0xFF;
        for (int i = 1; i < input.size; ++i) {
            y = this.multiply(y, x) ^ input.data[i] & 0xFF;
        }
        return y;
    }

    public int polyEval_S(DogArray_I8 input, int x) {
        int y = input.data[input.size - 1] & 0xFF;
        for (int i = input.size - 2; i >= 0; --i) {
            y = this.multiply(y, x) ^ input.data[i] & 0xFF;
        }
        return y;
    }

    public int polyEvalContinue(int previousOutput, DogArray_I8 part, int x) {
        int y = previousOutput;
        for (int i = 0; i < part.size; ++i) {
            y = this.multiply(y, x) ^ part.data[i] & 0xFF;
        }
        return y;
    }

    public void polyDivide(DogArray_I8 dividend, DogArray_I8 divisor, DogArray_I8 quotient, DogArray_I8 remainder) {
        if (divisor.size > dividend.size) {
            remainder.setTo(dividend);
            quotient.resize(0);
            return;
        }
        remainder.resize(divisor.size - 1);
        quotient.setTo(dividend);
        int normalizer = divisor.data[0] & 0xFF;
        int N = dividend.size - divisor.size + 1;
        for (int i = 0; i < N; ++i) {
            quotient.data[i] = (byte)this.divide(quotient.data[i] & 0xFF, normalizer);
            int coef = quotient.data[i] & 0xFF;
            if (coef == 0) continue;
            for (int j = 1; j < divisor.size; ++j) {
                int div_j = divisor.data[j] & 0xFF;
                if (div_j == 0) continue;
                int n = i + j;
                quotient.data[n] = (byte)(quotient.data[n] ^ (byte)this.multiply(div_j, coef));
            }
        }
        System.arraycopy(quotient.data, quotient.size - remainder.size, remainder.data, 0, remainder.size);
        quotient.size -= remainder.size;
    }

    public void polyDivide_S(DogArray_I8 dividend, DogArray_I8 divisor, DogArray_I8 quotient, DogArray_I8 remainder) {
        if (divisor.size > dividend.size) {
            remainder.setTo(dividend);
            quotient.resize(0);
            return;
        }
        quotient.resize(dividend.size - divisor.size + 1);
        remainder.setTo(dividend);
        int normalizer = divisor.data[divisor.size - 1] & 0xFF;
        int N = dividend.size - divisor.size + 1;
        for (int i = 0; i < N; ++i) {
            int q_i = remainder.size - i - 1;
            remainder.data[q_i] = (byte)this.divide(remainder.data[q_i] & 0xFF, normalizer);
            int coef = remainder.data[q_i] & 0xFF;
            if (coef == 0) continue;
            for (int j = 1; j < divisor.size; ++j) {
                int d_j = divisor.size - j - 1;
                int div_j = divisor.data[d_j] & 0xFF;
                if (div_j == 0) continue;
                int n = remainder.size - i - j - 1;
                remainder.data[n] = (byte)(remainder.data[n] ^ (byte)this.multiply(div_j, coef));
            }
        }
        remainder.size -= quotient.size;
        System.arraycopy(remainder.data, remainder.size, quotient.data, 0, quotient.size);
    }
}

