/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.microqr;

import boofcv.alg.fiducial.microqr.MicroQrCode;
import boofcv.struct.distort.DoNothing2Transform2_F64;
import boofcv.struct.distort.Point2Transform2_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.geo.PointIndex2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class MicroQrPose3DUtils {
    public List<PointIndex2D_F64> pixelControl = new ArrayList<PointIndex2D_F64>();
    public List<Point2D3D> point23 = new ArrayList<Point2D3D>();
    public List<Point3D_F64> point3D = new ArrayList<Point3D_F64>();
    protected Point2Transform2_F64 pixelToNorm = new DoNothing2Transform2_F64();
    protected Point2Transform2_F64 undistToDist = new DoNothing2Transform2_F64();

    public MicroQrPose3DUtils() {
        for (int i = 0; i < 4; ++i) {
            this.pixelControl.add(new PointIndex2D_F64(0.0, 0.0, i));
            this.point23.add(new Point2D3D());
            this.point3D.add(new Point3D_F64());
        }
    }

    public List<PointIndex2D_F64> getLandmarkByIndex(MicroQrCode qr) {
        ((Point2D_F64)this.pixelControl.get((int)0).p).setTo(qr.pp.get(0));
        ((Point2D_F64)this.pixelControl.get((int)1).p).setTo(qr.pp.get(1));
        ((Point2D_F64)this.pixelControl.get((int)2).p).setTo(qr.pp.get(2));
        ((Point2D_F64)this.pixelControl.get((int)3).p).setTo(qr.pp.get(3));
        for (int i = 0; i < this.pixelControl.size(); ++i) {
            Point2D_F64 p = (Point2D_F64)this.pixelControl.get((int)i).p;
            this.undistToDist.compute(p.x, p.y, p);
        }
        return this.pixelControl;
    }

    public List<Point2D3D> getLandmark2D3D(MicroQrCode qr) {
        int N = qr.getNumberOfModules();
        this.setPair(0, 0, 0, N, qr.pp.get(0));
        this.setPair(1, 0, 7, N, qr.pp.get(1));
        this.setPair(2, 7, 7, N, qr.pp.get(2));
        this.setPair(3, 7, 0, N, qr.pp.get(3));
        return this.point23;
    }

    public List<Point3D_F64> getLandmark3D(int version) {
        int N = MicroQrCode.totalModules(version);
        this.set3D(0, 0, N, this.point3D.get(0));
        this.set3D(0, 7, N, this.point3D.get(1));
        this.set3D(7, 7, N, this.point3D.get(2));
        this.set3D(7, 0, N, this.point3D.get(3));
        return this.point3D;
    }

    private void setPair(int which, int row, int col, int N, Point2D_F64 pixel) {
        this.set3D(row, col, N, this.point23.get((int)which).location);
        this.pixelToNorm.compute(pixel.x, pixel.y, this.point23.get((int)which).observation);
    }

    private void set3D(int row, int col, int N, Point3D_F64 location) {
        double _N = N;
        double gridX = 2.0 * ((double)col / _N - 0.5);
        double gridY = 2.0 * (0.5 - (double)row / _N);
        location.setTo(gridX, gridY, 0.0);
    }

    public void setLensDistortion(@Nullable Point2Transform2_F64 pixelToNorm, @Nullable Point2Transform2_F64 undistToDist) {
        if (pixelToNorm == null || undistToDist == null) {
            this.pixelToNorm = new DoNothing2Transform2_F64();
            this.undistToDist = new DoNothing2Transform2_F64();
        } else {
            this.pixelToNorm = pixelToNorm;
            this.undistToDist = undistToDist;
        }
    }

    public Point2Transform2_F64 getPixelToNorm() {
        return this.pixelToNorm;
    }
}

