/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.ecocheck;

import boofcv.alg.fiducial.calib.ecocheck.CellValue;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.ReedSolomonCodes_U8;
import boofcv.misc.BoofMiscOps;
import org.ddogleg.struct.DogArray_I8;

public class ECoCheckCodec {
    public static final int MAX_ECC_LEVEL = 9;
    public static final int MAX_CHECKSUM_BITS = 8;
    public static final int WORD_BITS = 8;
    int errorCorrectionLevel = 3;
    int checksumBitCount = 6;
    int wordMask;
    int messageBitCount;
    int markerBitCount;
    int cellBitCount;
    int gridBitLength;
    protected int checksumMask;
    protected int dataWords;
    protected int eccWords;
    protected int paddingBits = 0;
    protected final DogArray_I8 message = new DogArray_I8();
    protected final DogArray_I8 ecc = new DogArray_I8();
    protected final PackedBits8 bits = new PackedBits8();
    private final ReedSolomonCodes_U8 rscodes = new ReedSolomonCodes_U8(8, 285, 0);

    public void configure(int numUniqueMarkers, int numUniqueCells) {
        int packetBitCount;
        BoofMiscOps.checkTrue(this.checksumBitCount >= 0 && this.checksumBitCount <= 8);
        BoofMiscOps.checkTrue(this.errorCorrectionLevel >= 0 && this.errorCorrectionLevel <= 9);
        this.markerBitCount = numUniqueMarkers == 1 ? 0 : (int)Math.ceil(Math.log(numUniqueMarkers) / Math.log(2.0));
        this.cellBitCount = (int)Math.ceil(Math.log(numUniqueCells) / Math.log(2.0));
        this.messageBitCount = this.markerBitCount + this.cellBitCount + this.checksumBitCount;
        this.dataWords = (int)Math.ceil((double)this.messageBitCount / 8.0);
        if (this.errorCorrectionLevel > 0) {
            this.eccWords = (int)(2.0 * Math.ceil((double)this.dataWords * this.errorCorrectionFraction()));
            packetBitCount = (this.dataWords + this.eccWords) * 8;
        } else {
            packetBitCount = this.messageBitCount;
            this.eccWords = 0;
        }
        this.gridBitLength = (int)Math.ceil(Math.sqrt(packetBitCount));
        if (this.errorCorrectionLevel > 0 && this.gridBitLength * this.gridBitLength - packetBitCount >= 8) {
            int extraWords = (this.gridBitLength * this.gridBitLength - packetBitCount) / 8;
            this.eccWords += extraWords;
        }
        this.ecc.resize(this.eccWords);
        this.bits.resize(this.messageBitCount);
        this.rscodes.generator(this.eccWords);
        this.wordMask = BoofMiscOps.generateBitMask(8);
        this.checksumMask = BoofMiscOps.generateBitMask(this.checksumBitCount);
    }

    public void encode(int markerID, int cellID, PackedBits8 encodedPacket) {
        int bitsEncoded;
        int elementsInGrid = this.gridBitLength * this.gridBitLength;
        encodedPacket.resize(elementsInGrid);
        this.bits.resize(0);
        this.bits.append(markerID, this.markerBitCount, false);
        this.bits.append(cellID, this.cellBitCount, false);
        int checkSum = this.computeCheckSum();
        this.bits.append(checkSum, this.checksumBitCount, true);
        BoofMiscOps.checkEq(this.bits.size, this.messageBitCount);
        encodedPacket.resize(0);
        encodedPacket.append(this.bits, this.bits.size);
        if (this.errorCorrectionLevel > 0) {
            this.message.setTo(this.bits.data, 0, this.dataWords);
            this.rscodes.computeECC(this.message, this.ecc);
            System.arraycopy(this.ecc.data, 0, encodedPacket.data, this.dataWords, this.ecc.size);
            bitsEncoded = (this.dataWords + this.ecc.size) * 8;
        } else {
            bitsEncoded = this.bits.size;
        }
        for (int i = encodedPacket.size = bitsEncoded; i < elementsInGrid; i += 32) {
            encodedPacket.append(this.paddingBits, Math.min(32, elementsInGrid - i), false);
        }
    }

    private int computeCheckSum() {
        if (this.checksumBitCount == 0) {
            return 0;
        }
        int checkSum = 171;
        int length = this.bits.length();
        for (int i = 0; i < length; i += this.checksumBitCount) {
            int amount = Math.min(this.checksumBitCount, length - i);
            checkSum ^= this.bits.read(i, amount, false);
        }
        return checkSum & this.checksumMask;
    }

    public boolean decode(PackedBits8 readBits, CellValue cell) {
        BoofMiscOps.checkEq(readBits.size, this.gridBitLength * this.gridBitLength, "Unexpected array size");
        this.message.setTo(readBits.data, 0, this.dataWords);
        this.ecc.setTo(readBits.data, this.dataWords, this.eccWords);
        if (!this.rscodes.correct(this.message, this.ecc)) {
            return false;
        }
        System.arraycopy(this.message.data, 0, this.bits.data, 0, this.dataWords);
        this.bits.size = this.messageBitCount;
        int foundCheckSum = this.bits.read(this.bits.size - this.checksumBitCount, this.checksumBitCount, false);
        this.bits.resize(this.bits.size - this.checksumBitCount);
        int expectedCheckSum = this.computeCheckSum();
        if (foundCheckSum != expectedCheckSum) {
            return false;
        }
        cell.markerID = this.bits.read(0, this.markerBitCount, true);
        cell.cellID = this.bits.read(this.markerBitCount, this.cellBitCount, true);
        return true;
    }

    public double errorCorrectionFraction() {
        return (double)this.errorCorrectionLevel / 9.0;
    }

    public int getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    public void setErrorCorrectionLevel(int errorCorrectionLevel) {
        this.errorCorrectionLevel = errorCorrectionLevel;
    }

    public int getChecksumBitCount() {
        return this.checksumBitCount;
    }

    public void setChecksumBitCount(int checksumBitCount) {
        this.checksumBitCount = checksumBitCount;
    }

    public int getMarkerBitCount() {
        return this.markerBitCount;
    }

    public int getCellBitCount() {
        return this.cellBitCount;
    }

    public int getGridBitLength() {
        return this.gridBitLength;
    }
}

