/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.chess;

import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.fiducial.calib.chess.DetectChessboardSquarePoints;
import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.shapes.polygon.DetectPolygonBinaryGrayRefine;
import boofcv.struct.ConfigLength;
import boofcv.struct.geo.PointIndex2D_F64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.util.List;

public class DetectChessboardBinaryPattern<T extends ImageGray<T>> {
    private DetectChessboardSquarePoints<T> findSeeds;
    private GrayU8 binary = new GrayU8(1, 1);
    private GrayU8 eroded = new GrayU8(1, 1);
    private int numRows;
    private int numCols;
    InputToBinary<T> inputToBinary;

    public DetectChessboardBinaryPattern(int numRows, int numCols, ConfigLength maxCornerDistance, DetectPolygonBinaryGrayRefine<T> detectorSquare, InputToBinary<T> inputToBinary) {
        this.numRows = numRows;
        this.numCols = numCols;
        this.inputToBinary = inputToBinary;
        this.findSeeds = new DetectChessboardSquarePoints<T>(numRows, numCols, maxCornerDistance, detectorSquare);
        this.reset();
    }

    public void reset() {
    }

    public boolean process(T gray) {
        this.binary.reshape(((ImageGray)gray).width, ((ImageGray)gray).height);
        this.eroded.reshape(((ImageGray)gray).width, ((ImageGray)gray).height);
        this.inputToBinary.process(gray, this.binary);
        BinaryImageOps.erode8(this.binary, 1, this.eroded);
        return this.findSeeds.process(gray, this.eroded);
    }

    public List<PointIndex2D_F64> getCalibrationPoints() {
        return this.findSeeds.getCalibrationPoints().toList();
    }

    public int getColumns() {
        return this.numCols;
    }

    public int getRows() {
        return this.numRows;
    }

    public DetectChessboardSquarePoints<T> getFindSeeds() {
        return this.findSeeds;
    }

    public GrayU8 getBinary() {
        return this.binary;
    }

    public GrayU8 getEroded() {
        return this.eroded;
    }
}

