/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.chess;

import boofcv.alg.feature.detect.chess.ChessboardCorner;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.border.BorderType;
import boofcv.struct.image.ImageGray;
import java.util.Arrays;

public class ChessboardCornerEdgeIntensity<T extends ImageGray<T>> {
    InterpolatePixelS<T> interpolate;
    private int lengthSamples = 15;
    private float[] sampleValues = new float[this.lengthSamples];
    float nx;
    float ny;
    float tx;
    float ty;
    float normalDiv = 15.0f;
    float lineLength;
    int width;
    int height;

    public ChessboardCornerEdgeIntensity(Class<T> imageType) {
        this.interpolate = FactoryInterpolation.bilinearPixelS(imageType, BorderType.EXTENDED);
    }

    public void setImage(T image) {
        this.interpolate.setImage(image);
        this.width = ((ImageGray)image).width;
        this.height = ((ImageGray)image).height;
    }

    public float process(ChessboardCorner ca, ChessboardCorner cb, double direction_a_to_b) {
        int n;
        float cx = (float)ca.x;
        float cy = (float)ca.y;
        float dx = (float)(cb.x - ca.x);
        float dy = (float)(cb.y - ca.y);
        this.computeUnitNormal(dx, dy);
        float offsetA = (float)Math.pow(2.0, ca.levelMax);
        float offsetB = (float)Math.pow(2.0, cb.levelMax);
        offsetA = Math.max(1.0f, Math.min(offsetA, this.lineLength * 0.1f));
        offsetB = Math.max(1.0f, Math.min(offsetB, this.lineLength * 0.1f));
        float l = offsetA + offsetB;
        cx += this.nx * offsetA;
        cy += this.ny * offsetA;
        dx -= l * this.nx;
        dy -= l * this.ny;
        this.lineLength -= l;
        if (this.lineLength < 2.0f) {
            return -1.0f;
        }
        int lengthSamples = this.lengthSamples;
        if ((float)lengthSamples > this.lineLength) {
            lengthSamples = (int)this.lineLength;
        }
        float prevLeft = 0.0f;
        float prevRight = 0.0f;
        float prevMiddle = 0.0f;
        float longitudinalMaxValue = 0.0f;
        float tangentMaxDistance = Math.max(0.0f, Math.max(1.0f, this.lineLength / this.normalDiv) - (offsetA + offsetB) / 2.0f);
        for (int i = 0; i < lengthSamples; ++i) {
            float f = (float)i / (float)(lengthSamples - 1);
            float x0 = cx + dx * f;
            float y0 = cy + dy * f;
            float fp = (0.5f - Math.abs(f - 0.5f)) / 0.5f;
            float perpDist = offsetA * (1.0f - f) + offsetB * f + tangentMaxDistance * fp;
            float leftVal = this.interpolate.get(x0 - this.tx * perpDist, y0 - this.ty * perpDist);
            float rightVal = this.interpolate.get(x0 + this.tx * perpDist, y0 + this.ty * perpDist);
            float middle = this.interpolate.get(x0, y0);
            if (i > 0) {
                float ff = ((float)i - 0.5f) / (float)(lengthSamples - 1);
                float fpp = 0.1f + Math.min(1.0f, Math.abs(0.5f - Math.abs(ff - 0.5f)) / 0.35f);
                longitudinalMaxValue = Math.max(longitudinalMaxValue, Math.abs(leftVal - prevLeft) * fpp);
                longitudinalMaxValue = Math.max(longitudinalMaxValue, Math.abs(rightVal - prevRight) * fpp);
                longitudinalMaxValue = Math.max(longitudinalMaxValue, Math.abs(middle - prevMiddle) * fpp);
            }
            prevLeft = leftVal;
            prevRight = rightVal;
            prevMiddle = middle;
            this.sampleValues[i] = leftVal - rightVal;
        }
        Arrays.sort(this.sampleValues, 0, lengthSamples);
        float perpendicularAverage = 0.0f;
        for (int i = n = lengthSamples > 6 ? 2 : (lengthSamples >= 3 ? 1 : 0); i < lengthSamples - n; ++i) {
            perpendicularAverage += this.sampleValues[i];
        }
        perpendicularAverage /= (float)(lengthSamples - n * 2);
        int numNegative = 0;
        for (int i = 0; i < lengthSamples; ++i) {
            if (!(this.sampleValues[i] < 0.0f)) continue;
            ++numNegative;
        }
        if (numNegative > lengthSamples * 3 / 4) {
            perpendicularAverage *= -1.0f;
        }
        return perpendicularAverage - longitudinalMaxValue;
    }

    void computeUnitNormal(float dx, float dy) {
        this.lineLength = (float)Math.sqrt(dx * dx + dy * dy);
        this.nx = dx / this.lineLength;
        this.ny = dy / this.lineLength;
        this.tx = -this.ny;
        this.ty = this.nx;
    }

    public int getLengthSamples() {
        return this.lengthSamples;
    }

    public void setLengthSamples(int lengthSamples) {
        this.lengthSamples = lengthSamples;
        if (this.sampleValues.length < lengthSamples) {
            this.sampleValues = new float[lengthSamples];
        }
    }

    public Class<T> getImageType() {
        return this.interpolate.getImageType().getImageClass();
    }
}

