/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.aztec;

import boofcv.alg.fiducial.aztec.AztecCode;
import boofcv.alg.fiducial.qrcode.PackedBits8;
import boofcv.alg.fiducial.qrcode.ReedSolomonCodes_U16;
import boofcv.misc.BoofMiscOps;
import org.ddogleg.struct.DogArray_I16;

public abstract class AztecMessageErrorCorrection {
    protected final ReedSolomonCodes_U16 ecc6 = new ReedSolomonCodes_U16(6, 67, 1);
    protected final ReedSolomonCodes_U16 ecc8 = new ReedSolomonCodes_U16(8, 301, 1);
    protected final ReedSolomonCodes_U16 ecc10 = new ReedSolomonCodes_U16(10, 1033, 1);
    protected final ReedSolomonCodes_U16 ecc12 = new ReedSolomonCodes_U16(12, 4201, 1);
    protected final DogArray_I16 storageDataWords = new DogArray_I16();
    protected final DogArray_I16 storageEccWords = new DogArray_I16();

    public void computeEccWords(int wordBits, int maxMarkerWords) {
        int actualEccWords = maxMarkerWords - this.storageDataWords.size;
        this.storageEccWords.resize(actualEccWords);
        switch (wordBits) {
            case 6: {
                this.computeEcc(this.ecc6, actualEccWords);
                break;
            }
            case 8: {
                this.computeEcc(this.ecc8, actualEccWords);
                break;
            }
            case 10: {
                this.computeEcc(this.ecc10, actualEccWords);
                break;
            }
            case 12: {
                this.computeEcc(this.ecc12, actualEccWords);
                break;
            }
            default: {
                throw new RuntimeException("BUG!");
            }
        }
    }

    private void computeEcc(ReedSolomonCodes_U16 ecc, int actualEccWords) {
        ecc.generator(actualEccWords);
        ecc.computeECC(this.storageDataWords, this.storageEccWords);
    }

    public boolean applyErrorCorrection(AztecCode marker) {
        this.extractWordsFromMarker(marker);
        int bitErrors = this.applyEcc(marker.getCapacityWords(), marker.getWordBitCount());
        if (bitErrors < 0) {
            return false;
        }
        marker.totalBitErrors = bitErrors;
        int wordBitCount = marker.getWordBitCount();
        int messageBits = this.storageDataWords.size * wordBitCount;
        marker.corrected = new byte[BoofMiscOps.bitToByteCount(messageBits)];
        PackedBits8 bits = PackedBits8.wrap(marker.corrected, 0);
        for (int i = 0; i < this.storageDataWords.size; ++i) {
            int value = this.storageDataWords.get(i) & 0xFFFF;
            bits.append(value, wordBitCount, false);
        }
        return true;
    }

    void extractWordsFromMarker(AztecCode marker) {
        BoofMiscOps.checkTrue(marker.messageWordCount > 0);
        BoofMiscOps.checkTrue(marker.getCapacityWords() >= marker.messageWordCount);
        int wordBitCount = marker.getWordBitCount();
        PackedBits8 bits = PackedBits8.wrap(marker.rawbits, marker.getCapacityBits());
        this.storageDataWords.resize(marker.messageWordCount);
        this.storageEccWords.resize(marker.getCapacityWords() - marker.messageWordCount);
        int locationBits = 0;
        int i = 0;
        while (i < this.storageDataWords.size) {
            this.storageDataWords.data[i] = (short)bits.read(locationBits, wordBitCount, true);
            ++i;
            locationBits += wordBitCount;
        }
        i = 0;
        while (i < this.storageEccWords.size) {
            this.storageEccWords.data[i] = (short)bits.read(locationBits, wordBitCount, true);
            ++i;
            locationBits += wordBitCount;
        }
    }

    int applyEcc(int capacityWords, int wordBitCount) {
        int n;
        switch (wordBitCount) {
            case 6: {
                n = this.applyEcc(capacityWords, this.ecc6);
                break;
            }
            case 8: {
                n = this.applyEcc(capacityWords, this.ecc8);
                break;
            }
            case 10: {
                n = this.applyEcc(capacityWords, this.ecc10);
                break;
            }
            case 12: {
                n = this.applyEcc(capacityWords, this.ecc12);
                break;
            }
            default: {
                throw new RuntimeException("Unexpected word size");
            }
        }
        return n;
    }

    int applyEcc(int capacityWords, ReedSolomonCodes_U16 ecc) {
        ecc.generator(capacityWords - this.storageDataWords.size);
        if (!ecc.correct(this.storageDataWords, this.storageEccWords)) {
            return -1;
        }
        return ecc.getTotalErrors();
    }
}

