/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.aztec;

import boofcv.alg.fiducial.aztec.AztecPyramid;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.shapes.Polygon2D_F64;

public class AztecCode {
    public int dataLayers = 0;
    public int messageWordCount = 0;
    public byte[] rawbits;
    public byte[] corrected;
    public String message = "";
    public Structure structure = Structure.COMPACT;
    public Failure failure = Failure.NONE;
    public boolean transposed;
    public int totalBitErrors;
    public final AztecPyramid locator = new AztecPyramid();
    public Polygon2D_F64 bounds = new Polygon2D_F64(4);
    public Homography2D_F64 Hinv = new Homography2D_F64();

    public int getMarkerWidthSquares() {
        int withoutGrid = this.getLocatorWidthSquares() + 6 + this.dataLayers * 4;
        if (this.structure == Structure.COMPACT || this.dataLayers <= 4) {
            return withoutGrid;
        }
        int radius = 9 + this.dataLayers * 2;
        int gridRingCount = radius / 16;
        return withoutGrid + 1 + gridRingCount * 2 - 1;
    }

    public int getLocatorRingCount() {
        int n;
        switch (this.structure) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case COMPACT: {
                n = 2;
                break;
            }
            case FULL: {
                n = 3;
            }
        }
        return n;
    }

    public int getLocatorWidthSquares() {
        return (this.getLocatorRingCount() - 1) * 4 + 1;
    }

    public int getCapacityBits() {
        return this.getCapacityWords() * this.getWordBitCount();
    }

    public int getCapacityWords() {
        return this.structure.getCodewords(this.dataLayers);
    }

    public int getWordBitCount() {
        return AztecCode.getWordBitCount(this.dataLayers);
    }

    public static int getWordBitCount(int dataLayers) {
        if (dataLayers < 1) {
            throw new RuntimeException("Invalid number of layers. layers=" + dataLayers);
        }
        if (dataLayers <= 2) {
            return 6;
        }
        if (dataLayers <= 8) {
            return 8;
        }
        if (dataLayers <= 22) {
            return 10;
        }
        return 12;
    }

    public double getCorrectionLevel() {
        int wordsErrorCorrection = this.getCapacityWords() - this.messageWordCount;
        return (double)wordsErrorCorrection / (double)this.messageWordCount;
    }

    public void reset() {
        this.dataLayers = 0;
        this.structure = Structure.COMPACT;
        this.message = "";
        this.rawbits = null;
        this.corrected = null;
        this.failure = Failure.NONE;
        this.transposed = false;
        this.totalBitErrors = 0;
        this.locator.reset();
        this.bounds.zero();
        this.Hinv.reset();
    }

    public AztecCode setTo(AztecCode src) {
        this.dataLayers = src.dataLayers;
        this.messageWordCount = src.messageWordCount;
        this.message = src.message;
        this.rawbits = src.rawbits == null ? null : (byte[])src.rawbits.clone();
        this.corrected = src.corrected == null ? null : (byte[])src.corrected.clone();
        this.failure = src.failure;
        this.structure = src.structure;
        this.transposed = src.transposed;
        this.totalBitErrors = src.totalBitErrors;
        this.locator.setTo(src.locator);
        this.bounds.setTo(src.bounds);
        this.Hinv.setTo(src.Hinv);
        return this;
    }

    public AztecCode copy() {
        return new AztecCode().setTo(this);
    }

    public static enum Structure {
        COMPACT(new int[]{17, 40, 51, 76}),
        FULL(new int[]{21, 48, 60, 88, 120, 156, 196, 240, 230, 272, 316, 364, 416, 470, 528, 588, 652, 720, 790, 864, 940, 1020, 920, 992, 1066, 1144, 1224, 1306, 1392, 1480, 1570, 1664});

        final int maxDataLayers;
        private final int[] codewords;

        private Structure(int[] codewords) {
            this.maxDataLayers = codewords.length;
            this.codewords = codewords;
        }

        public int getCodewords(int level) {
            return this.codewords[level - 1];
        }

        public int getCapacityBits(int level) {
            return this.getCodewords(level) * AztecCode.getWordBitCount(level);
        }

        public int getMaxDataLayers() {
            return this.maxDataLayers;
        }
    }

    public static enum Failure {
        NONE,
        IMPROBABLE,
        ORIENTATION,
        MODE_ECC,
        MESSAGE_ECC,
        MESSAGE_PARSE;

    }

    public static enum Mode {
        UPPER(5),
        LOWER(5),
        MIXED(5),
        PUNCT(5),
        DIGIT(4),
        BYTE(8),
        FNC1(5),
        ECI(8);

        final int wordSize;

        private Mode(int wordSize) {
            this.wordSize = wordSize;
        }

        public int getWordSize() {
            return this.wordSize;
        }
    }
}

