/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.selector;

import boofcv.alg.feature.detect.selector.FeatureSelectLimit;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.ConfigGridUniform;
import boofcv.struct.ImageGrid;
import georegression.struct.point.Point2D_F32;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I16;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;
import org.jetbrains.annotations.Nullable;

public abstract class FeatureSelectUniform<Point>
implements FeatureSelectLimit<Point> {
    public ConfigGridUniform configUniform = new ConfigGridUniform();
    public Random rand = new Random(-559038737L);
    ImageGrid<Info<Point>> grid = new ImageGrid<Info>(Info::new, Info::reset);

    @Override
    public void select(int imageWidth, int imageHeight, @Nullable FastAccess<Point> prior, FastAccess<Point> detected, int limit, FastArray<Point> selected) {
        Object p;
        int i;
        BoofMiscOps.checkTrue(limit > 0);
        selected.reset();
        if ((prior == null || prior.size == 0) && detected.size <= limit) {
            selected.addAll(detected);
            return;
        }
        int targetCellSize = this.configUniform.selectTargetCellSize(limit, imageWidth, imageHeight);
        this.grid.initialize(targetCellSize, imageWidth, imageHeight);
        if (prior != null) {
            for (i = 0; i < prior.size; ++i) {
                p = prior.data[i];
                ++this.getGridCell(p).priorCount;
            }
        }
        for (i = 0; i < detected.size; ++i) {
            p = detected.data[i];
            this.getGridCell(p).detected.add(p);
        }
        DogArray cells = this.grid.cells;
        selected.resize(limit);
        selected.reset();
        while (selected.size < limit) {
            boolean change = false;
            for (int cellidx = 0; cellidx < cells.size && selected.size < limit; ++cellidx) {
                Info info = (Info)cells.get(cellidx);
                if (info.priorCount > 0) {
                    --info.priorCount;
                    change = true;
                    continue;
                }
                if (info.detected.isEmpty()) continue;
                selected.add(info.detected.remove(this.rand.nextInt(info.detected.size())));
                change = true;
            }
            if (change) continue;
            break;
        }
    }

    protected abstract Info<Point> getGridCell(Point var1);

    public static class Info<Point> {
        int priorCount = 0;
        List<Point> detected = new ArrayList<Point>();

        public void reset() {
            this.priorCount = 0;
            this.detected.clear();
        }
    }

    public static class F64
    extends FeatureSelectUniform<Point2D_F64> {
        @Override
        protected Info<Point2D_F64> getGridCell(Point2D_F64 p) {
            return (Info)this.grid.getCellAtPixel((int)p.x, (int)p.y);
        }
    }

    public static class F32
    extends FeatureSelectUniform<Point2D_F32> {
        @Override
        protected Info<Point2D_F32> getGridCell(Point2D_F32 p) {
            return (Info)this.grid.getCellAtPixel((int)p.x, (int)p.y);
        }
    }

    public static class I16
    extends FeatureSelectUniform<Point2D_I16> {
        @Override
        protected Info<Point2D_I16> getGridCell(Point2D_I16 p) {
            return (Info)this.grid.getCellAtPixel(p.x, p.y);
        }
    }
}

