/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.line;

import boofcv.alg.feature.detect.line.LineImageOps;
import georegression.metric.Distance2D_F32;
import georegression.metric.Intersection2D_F32;
import georegression.metric.UtilAngle;
import georegression.struct.line.LineParametric2D_F32;
import georegression.struct.line.LineSegment2D_F32;
import georegression.struct.point.Point2D_F32;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class ImageLinePruneMerge {
    List<Data> lines = new ArrayList<Data>();

    public void reset() {
        this.lines.clear();
    }

    public void add(LineParametric2D_F32 line, float intensity) {
        this.lines.add(new Data(line, intensity));
    }

    public void pruneRelative(float fraction) {
        float max = 0.0f;
        for (int lineIdx = 0; lineIdx < this.lines.size(); ++lineIdx) {
            Data d = this.lines.get(lineIdx);
            if (!(d.intensity > max)) continue;
            max = d.intensity;
        }
        float threshold = max * fraction;
        ArrayList<Data> filtered = new ArrayList<Data>();
        for (int lineIdx = 0; lineIdx < this.lines.size(); ++lineIdx) {
            Data d = this.lines.get(lineIdx);
            if (!(d.intensity >= threshold)) continue;
            filtered.add(d);
        }
        this.lines = filtered;
    }

    public void pruneNBest(int N) {
        if (this.lines.size() <= N) {
            return;
        }
        this.sortByIntensity();
        ArrayList<Data> filtered = new ArrayList<Data>();
        for (int i = 0; i < N; ++i) {
            filtered.add(this.lines.get(i));
        }
        this.lines = filtered;
    }

    private void sortByIntensity() {
        Collections.sort(this.lines, (o1, o2) -> {
            if (o1.intensity < o2.intensity) {
                return 1;
            }
            if (o1.intensity > o2.intensity) {
                return -1;
            }
            if (o1.line.p.x < o2.line.p.x) {
                return -1;
            }
            if (o1.line.p.x > o2.line.p.x) {
                return 1;
            }
            return Float.compare(o1.line.p.y, o2.line.p.y);
        });
    }

    public void pruneSimilar(float toleranceAngle, float toleranceDist, int imgWidth, int imgHeight) {
        int i;
        this.sortByIntensity();
        float[] theta = new float[this.lines.size()];
        ArrayList<LineSegment2D_F32> segments = new ArrayList<LineSegment2D_F32>(this.lines.size());
        for (i = 0; i < this.lines.size(); ++i) {
            Data d = this.lines.get(i);
            LineParametric2D_F32 l = d.line;
            theta[i] = UtilAngle.atanSafe(l.getSlopeY(), l.getSlopeX());
            segments.add(LineImageOps.convert(l, imgWidth, imgHeight));
        }
        for (i = 0; i < segments.size(); ++i) {
            LineSegment2D_F32 a = (LineSegment2D_F32)segments.get(i);
            if (a == null) continue;
            for (int j = i + 1; j < segments.size(); ++j) {
                LineSegment2D_F32 b = (LineSegment2D_F32)segments.get(j);
                if (b == null || UtilAngle.distHalf(theta[i], theta[j]) > (double)toleranceAngle) continue;
                Point2D_F32 p = Intersection2D_F32.intersection(a, b, null);
                boolean close = false;
                if (p != null && p.x >= 0.0f && p.y >= 0.0f && p.x < (float)imgWidth && p.y < (float)imgHeight) {
                    close = true;
                }
                if (!close) {
                    float distA = Distance2D_F32.distance(a, b.a);
                    float distB = Distance2D_F32.distance(a, b.b);
                    if (distA > toleranceDist && distB > toleranceDist) continue;
                    distA = Distance2D_F32.distance(b, b.a);
                    distB = Distance2D_F32.distance(b, b.b);
                    if (distA > toleranceDist && distB > toleranceDist) continue;
                    close = true;
                }
                if (!close) continue;
                if (this.lines.get((int)j).intensity > this.lines.get((int)i).intensity) {
                    this.lines.get((int)i).intensity = this.lines.get((int)j).intensity;
                }
                segments.set(j, null);
            }
        }
        ArrayList<Data> filtered = new ArrayList<Data>();
        for (int i2 = 0; i2 < segments.size(); ++i2) {
            if (segments.get(i2) == null) continue;
            filtered.add(this.lines.get(i2));
        }
        this.lines = filtered;
    }

    public List<LineParametric2D_F32> createList(@Nullable List<LineParametric2D_F32> ret) {
        if (ret == null) {
            ret = new ArrayList<LineParametric2D_F32>();
        } else {
            ret.clear();
        }
        for (int lineIdx = 0; lineIdx < this.lines.size(); ++lineIdx) {
            Data d = this.lines.get(lineIdx);
            ret.add(d.line);
        }
        return ret;
    }

    private static class Data {
        LineParametric2D_F32 line;
        float intensity;

        private Data(LineParametric2D_F32 line, float intensity) {
            this.line = line;
            this.intensity = intensity;
        }
    }
}

