/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.interest;

import boofcv.abst.feature.detect.extract.NonMaxLimiter;
import boofcv.abst.filter.convolve.ImageConvolveSparse;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.alg.feature.detect.interest.SiftScaleSpace;
import boofcv.alg.feature.detect.selector.FeatureSelectLimitIntensity;
import boofcv.alg.feature.detect.selector.SampleIntensityScalePoint;
import boofcv.alg.filter.kernel.KernelMath;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.factory.filter.convolve.FactoryConvolveSparse;
import boofcv.struct.border.BorderType;
import boofcv.struct.border.ImageBorder;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.image.GrayF32;
import java.util.List;
import org.ddogleg.struct.DogArray;
import org.ddogleg.struct.FastAccess;
import org.ddogleg.struct.FastArray;

public class SiftDetector {
    double pixelScaleToInput;
    double edgeThreshold;
    public int maxFeaturesAll = -1;
    protected DogArray<SiftPoint> detectionsAll = new DogArray<SiftPoint>(SiftPoint::new);
    ImageConvolveSparse<GrayF32, ?> derivXX;
    ImageConvolveSparse<GrayF32, ?> derivXY;
    ImageConvolveSparse<GrayF32, ?> derivYY;
    GrayF32 dogLower;
    GrayF32 dogTarget;
    GrayF32 dogUpper;
    double sigmaLower;
    double sigmaTarget;
    double sigmaUpper;
    private final NonMaxLimiter extractor;
    private final FeatureSelectLimitIntensity<SiftPoint> selectFeaturesAll;
    private final FastArray<SiftPoint> selectedAll = new FastArray<SiftPoint>(SiftPoint.class);

    public SiftDetector(FeatureSelectLimitIntensity<ScalePoint> selectFeaturesAll, double edgeR, NonMaxLimiter extractor) {
        if (!extractor.getNonmax().canDetectMaximums() || !extractor.getNonmax().canDetectMinimums()) {
            throw new IllegalArgumentException("The extractor must be able to detect maximums and minimums");
        }
        if (edgeR < 1.0) {
            throw new IllegalArgumentException("R must be >= 1");
        }
        if (extractor.getNonmax().getIgnoreBorder() != 1) {
            throw new RuntimeException("Non-max should have an ignore border of 1");
        }
        this.extractor = extractor;
        this.edgeThreshold = (edgeR + 1.0) * (edgeR + 1.0) / edgeR;
        this.selectFeaturesAll = selectFeaturesAll;
        selectFeaturesAll.setSampler(new SampleIntensityScalePoint());
        this.createSparseDerivatives();
    }

    private void createSparseDerivatives() {
        Kernel1D_F32 kernelD = new Kernel1D_F32(new float[]{-1.0f, 0.0f, 1.0f}, 3);
        Kernel1D_F32 kernelDD = KernelMath.convolve1D_F32(kernelD, kernelD);
        Kernel2D_F32 kernelXY = KernelMath.convolve2D(kernelD, kernelD);
        this.derivXX = FactoryConvolveSparse.horizontal1D(GrayF32.class, kernelDD);
        this.derivXY = FactoryConvolveSparse.convolve2D(GrayF32.class, kernelXY);
        this.derivYY = FactoryConvolveSparse.vertical1D(GrayF32.class, kernelDD);
        Object border = FactoryImageBorder.single(BorderType.EXTENDED, GrayF32.class);
        this.derivXX.setImageBorder((ImageBorder<GrayF32>)border);
        this.derivXY.setImageBorder((ImageBorder<GrayF32>)border);
        this.derivYY.setImageBorder((ImageBorder<GrayF32>)border);
    }

    public void process(SiftScaleSpace scaleSpace) {
        this.detectionsAll.reset();
        this.selectedAll.reset();
        for (int octaveIdx = 0; octaveIdx < scaleSpace.octaves.length && !scaleSpace.isOctaveTooSmall(octaveIdx); ++octaveIdx) {
            int octave = octaveIdx + scaleSpace.firstOctave;
            SiftScaleSpace.Octave o = scaleSpace.octaves[octaveIdx];
            this.pixelScaleToInput = scaleSpace.pixelScaleCurrentToInput(octave);
            for (int scaleIdx = 1; scaleIdx < scaleSpace.getNumScales() + 1; ++scaleIdx) {
                this.sigmaLower = scaleSpace.computeSigmaScale(octave, scaleIdx - 1);
                this.sigmaTarget = scaleSpace.computeSigmaScale(octave, scaleIdx);
                this.sigmaUpper = scaleSpace.computeSigmaScale(octave, scaleIdx + 1);
                this.dogLower = o.differenceOfGaussian[scaleIdx - 1];
                this.dogTarget = o.differenceOfGaussian[scaleIdx];
                this.dogUpper = o.differenceOfGaussian[scaleIdx + 1];
                this.detectFeatures(octaveIdx, scaleIdx);
            }
        }
        if (this.maxFeaturesAll > 0) {
            this.selectFeaturesAll.select(null, scaleSpace.getOriginalWidth(), scaleSpace.getOriginalHeight(), true, null, this.detectionsAll, this.maxFeaturesAll, this.selectedAll);
        }
    }

    protected void detectFeatures(int octaveIndex, int scaleIndex) {
        this.extractor.process(this.dogTarget);
        FastAccess<NonMaxLimiter.LocalExtreme> found = this.extractor.getFeatures();
        this.derivXX.setImage(this.dogTarget);
        this.derivXY.setImage(this.dogTarget);
        this.derivYY.setImage(this.dogTarget);
        for (int i = 0; i < found.size; ++i) {
            NonMaxLimiter.LocalExtreme e = found.get(i);
            if (!this.isScaleSpaceExtremum(e.location.x, e.location.y, e.intensity, e.max ? 1.0f : -1.0f) || this.isEdge(e.location.x, e.location.y)) continue;
            SiftPoint p = this.createDetection(e.location.x, e.location.y, e.intensity, e.max);
            p.octaveIdx = (byte)octaveIndex;
            p.scaleIdx = (byte)scaleIndex;
        }
    }

    boolean isScaleSpaceExtremum(int c_x, int c_y, float positiveIntensity, float signAdj) {
        if (c_x <= 1 || c_y <= 1 || c_x >= this.dogLower.width - 1 || c_y >= this.dogLower.height - 1) {
            return false;
        }
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                float v = this.dogLower.unsafe_get(c_x + x, c_y + y);
                if (v * signAdj >= positiveIntensity) {
                    return false;
                }
                v = this.dogUpper.unsafe_get(c_x + x, c_y + y);
                if (!(v * signAdj >= positiveIntensity)) continue;
                return false;
            }
        }
        return true;
    }

    protected SiftPoint createDetection(int x, int y, float positiveIntensity, boolean maximum) {
        float signAdj = maximum ? 1.0f : -1.0f;
        float x0 = this.dogTarget.unsafe_get(x - 1, y) * signAdj;
        float x2 = this.dogTarget.unsafe_get(x + 1, y) * signAdj;
        float y0 = this.dogTarget.unsafe_get(x, y - 1) * signAdj;
        float y2 = this.dogTarget.unsafe_get(x, y + 1) * signAdj;
        float s0 = this.dogLower.unsafe_get(x, y) * signAdj;
        float s2 = this.dogUpper.unsafe_get(x, y) * signAdj;
        SiftPoint p = this.detectionsAll.grow();
        p.pixel.x = this.pixelScaleToInput * (double)((float)x + FastHessianFeatureDetector.polyPeak(x0, positiveIntensity, x2));
        p.pixel.y = this.pixelScaleToInput * (double)((float)y + FastHessianFeatureDetector.polyPeak(y0, positiveIntensity, y2));
        double sigmaInterp = FastHessianFeatureDetector.polyPeak(s0, positiveIntensity, s2);
        p.scale = sigmaInterp < 0.0 ? this.sigmaLower * -sigmaInterp + (1.0 + sigmaInterp) * this.sigmaTarget : this.sigmaUpper * sigmaInterp + (1.0 - sigmaInterp) * this.sigmaTarget;
        p.white = !maximum;
        p.intensity = positiveIntensity;
        return p;
    }

    boolean isEdge(int x, int y) {
        if (this.edgeThreshold <= 0.0) {
            return false;
        }
        double xx = this.derivXX.compute(x, y);
        double xy = this.derivXY.compute(x, y);
        double yy = this.derivYY.compute(x, y);
        double Tr = xx + yy;
        double det = xx * yy - xy * xy;
        if (det <= 0.0) {
            return true;
        }
        return Tr * Tr >= this.edgeThreshold * det;
    }

    public List<SiftPoint> getDetections() {
        return (this.maxFeaturesAll > 0 ? this.selectedAll : this.detectionsAll).toList();
    }

    public NonMaxLimiter getExtractor() {
        return this.extractor;
    }

    public static class SiftPoint
    extends ScalePoint {
        public byte octaveIdx;
        public byte scaleIdx;
    }
}

