/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.describe.llah;

import boofcv.alg.feature.describe.llah.LlahFeature;
import boofcv.alg.geo.PerspectiveOps;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ddogleg.combinatorics.Combinations;
import org.ddogleg.util.PrimitiveArrays;

public abstract class LlahHasher {
    public static int DEFAULT_HASH_K = 25;
    public static int DEFAULT_HASH_SIZE = 12800000;
    protected double[] samples;
    private final long hashK;
    private final int hashSize;
    private final Combinations<Point2D_F64> combinator = new Combinations();

    protected LlahHasher(long hashK, int hashSize) {
        this.hashK = hashK;
        this.hashSize = hashSize;
    }

    public int getNumberOfInvariants(int numPoints) {
        return (int)Combinations.computeTotalCombinations(numPoints, this.getInvariantSampleSize());
    }

    public void computeHash(List<Point2D_F64> points, LlahFeature output) {
        int N = this.getInvariantSampleSize();
        if (points.size() < N) {
            throw new IllegalArgumentException("Must be at least 5 points and not " + points.size());
        }
        this.combinator.init(points, N);
        long hash = 0L;
        int i = 0;
        long k = 1L;
        do {
            double invariant = this.computeInvariant(this.combinator);
            int n = i++;
            int n2 = this.discretize(invariant);
            output.invariants[n] = n2;
            int r = n2;
            hash += (long)r * k;
            k *= this.hashK;
        } while (this.combinator.next());
        output.hashCode = (int)(hash % (long)this.hashSize);
    }

    public void computeInvariants(List<Point2D_F64> points, double[] invariants, int offset) {
        int N = this.getInvariantSampleSize();
        this.combinator.init(points, N);
        int i = 0;
        do {
            invariants[offset + i++] = this.computeInvariant(this.combinator);
        } while (this.combinator.next());
    }

    protected abstract int getInvariantSampleSize();

    protected abstract double computeInvariant(Combinations<Point2D_F64> var1);

    public int discretize(double invariant) {
        return PrimitiveArrays.lowerBound(this.samples, 0, this.samples.length, invariant);
    }

    public void learnDiscretization(int[] histogram, int histLength, double histMaxValue, int numDiscrete) {
        this.samples = new double[numDiscrete - 1];
        int total = 0;
        for (int i = 0; i < histLength; ++i) {
            total += histogram[i];
        }
        int locHist = 0;
        int j = 0;
        for (int i = 1; i < numDiscrete; ++i) {
            int target = (total - 1) * i / numDiscrete;
            while (locHist < target) {
                locHist += histogram[j++];
            }
            this.samples[i - 1] = (double)j * histMaxValue / (double)histLength;
        }
    }

    public int getNumValues() {
        return this.samples.length;
    }

    public void setSamples(double[] samples) {
        this.samples = samples;
    }

    public double[] getSamples() {
        return this.samples;
    }

    public static class CrossRatio
    extends LlahHasher {
        public CrossRatio(long hashK, int hashSize) {
            super(hashK, hashSize);
            this.samples = new double[]{0.01434, 0.03408, 0.05712, 0.08384, 0.11374, 0.14714, 0.18358, 0.2239, 0.26832, 0.31724, 0.37016, 0.4261, 0.48634, 0.5486, 0.6153, 0.68642, 0.75742, 0.8274, 0.90072, 0.96994, 1.0305, 1.12668, 1.26924, 1.48098, 1.80568, 2.35426, 3.29888, 5.3724, 12.1995};
        }

        @Override
        protected int getInvariantSampleSize() {
            return 5;
        }

        @Override
        protected double computeInvariant(Combinations<Point2D_F64> combinator) {
            Point2D_F64 p1 = combinator.get(0);
            Point2D_F64 p2 = combinator.get(1);
            Point2D_F64 p3 = combinator.get(2);
            Point2D_F64 p4 = combinator.get(3);
            Point2D_F64 p5 = combinator.get(4);
            return PerspectiveOps.invariantCrossRatio(p1, p2, p3, p4, p5);
        }
    }

    public static class Affine
    extends LlahHasher {
        public Affine(long hashK, int hashSize) {
            super(hashK, hashSize);
            this.samples = new double[]{0.044, 0.0876, 0.1334, 0.1813, 0.2332, 0.2885, 0.3465, 0.4099, 0.4779, 0.5522, 0.6353, 0.7279, 0.8316, 0.9477, 1.0751, 1.223, 1.3926, 1.5891, 1.8183, 2.0855, 2.4067, 2.8084, 3.3036, 3.9727, 4.9149, 6.2906, 8.5293, 13.0366, 25.6325};
        }

        @Override
        protected int getInvariantSampleSize() {
            return 4;
        }

        @Override
        protected double computeInvariant(Combinations<Point2D_F64> combinator) {
            Point2D_F64 p1 = combinator.get(0);
            Point2D_F64 p2 = combinator.get(1);
            Point2D_F64 p3 = combinator.get(2);
            Point2D_F64 p4 = combinator.get(3);
            return PerspectiveOps.invariantAffine(p1, p2, p3, p4);
        }
    }
}

